/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.wizard.export;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.fields.IProductSelectionListener;
import org.eclipse.scout.sdk.ui.fields.ProductSelectionField;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.internal.wizard.export.DeployableProductFileNodeFilter;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ui.wizard.export.IExportScoutProjectWizard;
import org.eclipse.scout.sdk.workspace.IScoutProject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractExportProductWizardPage
extends AbstractWorkspaceWizardPage {
    private static final String PROP_PRODUCT_FILE = "productFile";
    private static final String PROP_WAR_FILE_NAME = "warFileName";
    private final IScoutProject m_scoutProject;
    private final int m_nodeTypeFilter;
    private final String m_settingsProductFile;
    private final String m_settingsWarFileName;
    protected StyledTextField m_warFileName;
    protected ProductSelectionField m_productField;
    protected IStatus m_productStatus = Status.OK_STATUS;

    public AbstractExportProductWizardPage(IScoutProject scoutProject, String pageName, String title, int nodeTypeFilter, String prodFileSetting, String warFileNameSetting) {
        super(pageName);
        this.m_scoutProject = scoutProject;
        this.m_settingsProductFile = prodFileSetting;
        this.m_settingsWarFileName = warFileNameSetting;
        this.m_nodeTypeFilter = nodeTypeFilter;
        this.setTitle(title);
        this.setDescription(Texts.get((String)"ExportProductDesc"));
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_warFileName = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"WarFile"));
        this.m_warFileName.setReadOnlySuffix(".war");
        this.m_warFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractExportProductWizardPage.this.setWarNameInternal(AbstractExportProductWizardPage.this.m_warFileName.getText());
                AbstractExportProductWizardPage.this.pingStateChanging();
            }
        });
        this.m_warFileName.setText(this.getDialogSettings().get(this.m_settingsWarFileName));
        ITreeNode productTreeRoot = TreeUtility.createProductTree(this.getScoutProject(), new DeployableProductFileNodeFilter(this.m_nodeTypeFilter), false);
        this.m_productField = new ProductSelectionField(parent, productTreeRoot);
        this.m_productField.setLabelText(Texts.get((String)"ProductFile"));
        this.m_productField.addProductSelectionListener(new IProductSelectionListener(){

            @Override
            public void productSelected(IFile productFile) {
                AbstractExportProductWizardPage.this.setProductFileInternal(productFile);
                AbstractExportProductWizardPage.this.pingStateChanging();
            }
        });
        IFile defaultSelection = this.getProductFileSetting();
        if (defaultSelection == null) {
            ITreeNode[] productNodes = TreeUtility.findNodes(productTreeRoot, NodeFilters.getByType(2999));
            if (productNodes.length == 1) {
                defaultSelection = (IFile)productNodes[0].getData();
            } else if (productNodes.length == 0) {
                this.m_productStatus = new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"WarExportNoServerFound", (String[])new String[]{"org.eclipse.equinox.http.servletbridge", "org.eclipse.equinox.http.registry"}));
            }
        }
        this.m_productField.setProductFile(defaultSelection);
        this.setProductFileInternal(defaultSelection);
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_productField.setLayoutData(new GridData(768));
        this.m_warFileName.setLayoutData(new GridData(768));
        parent.setLayoutData((Object)new GridData(1808));
    }

    private IFile getProductFileSetting() {
        IFile productFile;
        IProject project;
        Path p;
        String path = this.getDialogSettings().get(this.m_settingsProductFile);
        if (!StringUtility.isNullOrEmpty((String)path) && (p = new Path(path)).segmentCount() > 1 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(p.segment(0))) != null && (productFile = project.getFile(p.removeFirstSegments(1))) != null && productFile.exists()) {
            return productFile;
        }
        return null;
    }

    public IExportScoutProjectWizard getWizard() {
        return (IExportScoutProjectWizard)super.getWizard();
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        multiStatus.add(this.getStatusProductField());
        multiStatus.add(this.getStatusWarName());
    }

    protected IStatus getStatusProductField() {
        if (this.getProductFile() == null || !this.getProductFile().exists()) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"NoProductFileSpecified"));
        }
        return this.m_productStatus;
    }

    protected IStatus getStatusWarName() {
        if (!StringUtility.hasText((String)this.m_warFileName.getModifiableText())) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"NoWARFileSpecified"));
        }
        return Status.OK_STATUS;
    }

    public IFile getProductFile() {
        return (IFile)this.getProperty(PROP_PRODUCT_FILE);
    }

    public void setProductFile(IFile productFile) {
        try {
            this.setStateChanging(true);
            this.setProductFileInternal(productFile);
            if (this.isControlCreated()) {
                this.m_productField.setProductFile(productFile);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setProductFileInternal(IFile productFile) {
        this.setProperty(PROP_PRODUCT_FILE, productFile);
        String setting = null;
        if (productFile != null) {
            setting = productFile.getFullPath().toString();
        }
        this.getDialogSettings().put(this.m_settingsProductFile, setting);
    }

    public IScoutProject getScoutProject() {
        return this.m_scoutProject;
    }

    public String getWarName() {
        return (String)this.getProperty(PROP_WAR_FILE_NAME);
    }

    public void setWarName(String name) {
        try {
            this.setStateChanging(true);
            this.setWarNameInternal(name);
            if (this.isControlCreated()) {
                this.m_warFileName.setText(name);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setWarNameInternal(String name) {
        this.setProperty(PROP_WAR_FILE_NAME, name);
        this.getDialogSettings().put(this.m_settingsWarFileName, name);
    }
}

