/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.wizard.newproject;

import java.beans.PropertyChangeListener;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.BasicPropertySupport;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.compatibility.internal.PlatformVersionUtility;
import org.eclipse.scout.sdk.ui.extensions.project.IScoutBundleExtension;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.bundletree.CheckableTree;
import org.eclipse.scout.sdk.ui.fields.bundletree.ICheckStateListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.bundle.ScoutBundleExtension;
import org.eclipse.scout.sdk.ui.internal.extensions.bundle.ScoutBundleExtensionPoint;
import org.eclipse.scout.sdk.ui.internal.wizard.newproject.ScoutProjectNewWizard;
import org.eclipse.scout.sdk.ui.wizard.project.AbstractProjectNewWizardPage;
import org.eclipse.scout.sdk.ui.wizard.project.IScoutProjectWizardPage;
import org.eclipse.scout.sdk.util.PropertyMap;
import org.eclipse.scout.sdk.util.ResourcesUtility;
import org.eclipse.scout.sdk.validation.BundleValidator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ScoutProjectNewWizardPage
extends AbstractProjectNewWizardPage
implements IScoutProjectWizardPage {
    private static final int TYPE_BUNDLE = 99;
    private BasicPropertySupport m_propertySupport = new BasicPropertySupport((Object)this);
    protected StyledTextField m_projectNameField;
    protected StyledTextField m_postFixField;
    protected CheckableTree m_bundleTree;
    protected ITreeNode m_invisibleRootNode;
    protected StyledTextField m_projectAliasNameField;

    public ScoutProjectNewWizardPage() {
        super(ScoutProjectNewWizardPage.class.getName());
        this.setTitle(Texts.get((String)"CreateAScoutProject"));
        this.setDescription(Texts.get((String)"CreateScoutProjectHelpMsg"));
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_projectNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"ProjectName"));
        this.m_projectNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    ScoutProjectNewWizardPage.this.setStateChanging(true);
                    ScoutProjectNewWizardPage.this.setProjectNameInternal(ScoutProjectNewWizardPage.this.m_projectNameField.getText());
                    ScoutProjectNewWizardPage.this.updateBundleNames();
                }
                finally {
                    ScoutProjectNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_postFixField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"ProjectPostfix"));
        this.m_postFixField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    ScoutProjectNewWizardPage.this.setStateChanging(true);
                    ScoutProjectNewWizardPage.this.setProjectNamePostfixInternal(ScoutProjectNewWizardPage.this.m_postFixField.getText());
                    ScoutProjectNewWizardPage.this.updateBundleNames();
                }
                finally {
                    ScoutProjectNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_invisibleRootNode = this.buildBundleTree();
        this.m_bundleTree = new CheckableTree(parent, this.m_invisibleRootNode);
        this.m_bundleTree.addCheckSelectionListener(new ICheckStateListener(){

            @Override
            public void fireNodeCheckStateChanged(ITreeNode node, boolean checkState) {
                ScoutProjectNewWizardPage.this.m_propertySupport.setProperty("selectedBundles", (Object)ScoutProjectNewWizardPage.this.m_bundleTree.getCheckedNodes());
                ScoutBundleExtension ext = (ScoutBundleExtension)node.getData();
                if (!node.isEnabled()) {
                    checkState = false;
                }
                if (ext != null) {
                    ext.getBundleExtention().bundleSelectionChanged(ScoutProjectNewWizardPage.this.getWizard(), checkState);
                }
                ScoutProjectNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_bundleTree.setChecked(TreeUtility.findNodes(this.m_invisibleRootNode, new P_InitialCheckNodesFilter()));
        Control aliasGroup = this.createAliasGroup(parent);
        this.m_projectNameField.setFocus();
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_projectNameField.setLayoutData(new GridData(768));
        this.m_postFixField.setLayoutData(new GridData(768));
        this.m_bundleTree.setLayoutData(new GridData(1808));
        aliasGroup.setLayoutData((Object)new GridData(768));
    }

    private ITreeNode buildBundleTree() {
        TreeNode rootNode = new TreeNode(-1, "root");
        rootNode.setVisible(false);
        ScoutBundleExtension[] scoutBundleExtensionArray = ScoutBundleExtensionPoint.getExtensions();
        int n = scoutBundleExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScoutBundleExtension e = scoutBundleExtensionArray[n2];
            TreeUtility.createNode(rootNode, 99, e.getBundleName(), ScoutSdkUi.getImageDescriptor(e.getIconPath()), e.getOrderNumber(), e);
            ++n2;
        }
        return rootNode;
    }

    private void updateBundleNames() {
        String prefix = "";
        if (!StringUtility.isNullOrEmpty((String)this.getProjectName())) {
            prefix = String.valueOf(this.getProjectName()) + ".";
        }
        String postfix = "";
        String pf = this.getProjectNamePostfix();
        if (!StringUtility.isNullOrEmpty((String)pf)) {
            postfix = "." + pf;
        }
        ITreeNode[] iTreeNodeArray = TreeUtility.findNodes(this.m_invisibleRootNode, NodeFilters.getVisible());
        int n = iTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode node = iTreeNodeArray[n2];
            ScoutBundleExtension ext = (ScoutBundleExtension)node.getData();
            if (ext != null && node.isEnabled()) {
                node.setText(String.valueOf(prefix) + ext.getBundleName() + postfix);
            }
            ++n2;
        }
        this.m_bundleTree.getTreeViewer().refresh();
        String alias = "";
        int dotIndex = this.getProjectName().lastIndexOf(46);
        if (dotIndex > 0 && dotIndex < this.getProjectName().length() - 1) {
            alias = this.getProjectName().substring(dotIndex + 1);
        }
        if (pf != null && pf.length() > 1) {
            alias = String.valueOf(alias) + Character.toUpperCase(pf.charAt(0)) + pf.substring(1);
        }
        this.m_projectAliasNameField.setText(alias);
    }

    protected Control createAliasGroup(Composite parent) {
        Group group = new Group(parent, 4);
        group.setText(Texts.get((String)"ProjectAlias"));
        Label label = new Label((Composite)group, 0);
        label.setText(Texts.get((String)"ProjectAliasHelp"));
        this.m_projectAliasNameField = this.getFieldToolkit().createStyledTextField((Composite)group, Texts.get((String)"ProjectAlias"));
        this.m_projectAliasNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ScoutProjectNewWizardPage.this.setProjectAliasInternal(ScoutProjectNewWizardPage.this.m_projectAliasNameField.getText());
                ScoutProjectNewWizardPage.this.pingStateChanging();
            }
        });
        group.setLayout((Layout)new GridLayout(1, true));
        label.setLayoutData((Object)new GridData(768));
        this.m_projectAliasNameField.setLayoutData(new GridData(768));
        return group;
    }

    @Override
    public void putProperties(PropertyMap properties) {
        String postfix = this.getProjectNamePostfix();
        if (postfix != null && (postfix = postfix.trim()).length() == 0) {
            postfix = null;
        }
        properties.setProperty("GROUP", (Object)this.getProjectName().trim());
        properties.setProperty("POSTFIX", (Object)postfix);
        properties.setProperty("ALIAS", (Object)this.getProjectAlias().trim());
        properties.setProperty("TARGET_PLATFORM_VERSION", (Object)PlatformVersionUtility.getPlatformVersion());
        ITreeNode[] nodes = TreeUtility.findNodes(this.m_invisibleRootNode, NodeFilters.getVisible());
        HashSet<String> checkedNodeExtensionIds = new HashSet<String>(nodes.length);
        ITreeNode[] iTreeNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            ScoutBundleExtension ext;
            ITreeNode node = iTreeNodeArray[n2];
            if (this.m_bundleTree.isChecked(node) && node.isEnabled() && (ext = (ScoutBundleExtension)node.getData()) != null) {
                checkedNodeExtensionIds.add(ext.getBundleID());
            }
            ++n2;
        }
        properties.setProperty("CHECKED_NODES", checkedNodeExtensionIds);
    }

    public void performHelp() {
        ResourcesUtility.showUrlInBrowser((String)"http://wiki.eclipse.org/Scout/HowTo/3.8/Create_a_new_project#Step_1");
    }

    public ScoutProjectNewWizard getWizard() {
        return (ScoutProjectNewWizard)super.getWizard();
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        multiStatus.add(this.getStatusProjectName());
        multiStatus.add(this.getStatusProjectPostfix());
        multiStatus.add(this.getStatusProjectAlias());
        ITreeNode[] iTreeNodeArray = TreeUtility.findNodes(this.m_invisibleRootNode, NodeFilters.getVisible());
        int n = iTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScoutBundleExtension ext;
            ITreeNode node = iTreeNodeArray[n2];
            if (this.m_bundleTree.isChecked(node) && (ext = (ScoutBundleExtension)node.getData()) != null) {
                multiStatus.add(ext.getBundleExtention().getStatus(this.getWizard()));
            }
            ++n2;
        }
    }

    protected IStatus getStatusProjectPostfix() {
        if (StringUtility.isNullOrEmpty((String)this.getProjectNamePostfix())) {
            return Status.OK_STATUS;
        }
        if (this.getProjectNamePostfix().matches("[a-zA-Z]{1}[a-zA-Z0-9]*[a-zA-Z]{1}")) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.scout.sdk.ui", "Project postfix is not valid.");
    }

    protected IStatus getStatusProjectName() {
        return BundleValidator.validateNewBundleName((String)this.getProjectName());
    }

    protected IStatus getStatusProjectAlias() {
        if (StringUtility.isNullOrEmpty((String)this.getProjectAlias())) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"ProjectAliasMissing"));
        }
        if (this.getProjectAlias().matches("[a-zA-Z]{1}[a-zA-Z0-9]*[a-zA-Z]{1}")) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.scout.sdk.ui", "Project alias is not valid.");
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.removePropertyChangeListener(listener);
    }

    @Override
    public boolean isBundleNodesSelected(String ... extensionIds) {
        ITreeNode[] nodes;
        ITreeNode[] iTreeNodeArray = nodes = TreeUtility.findNodes(this.m_invisibleRootNode, new P_NodeByExtensionIdFilter(extensionIds));
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode n3 = iTreeNodeArray[n2];
            if (!this.m_bundleTree.isChecked(n3)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void setBundleNodeAvailable(boolean available, String ... extensionIds) {
        ITreeNode[] nodes;
        ITreeNode[] iTreeNodeArray = nodes = TreeUtility.findNodes(this.m_invisibleRootNode, new P_NodeByExtensionIdFilter(extensionIds));
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode n3 = iTreeNodeArray[n2];
            n3.setEnabled(available);
            ++n2;
        }
    }

    @Override
    public boolean hasSelectedBundle(IScoutBundleExtension.BundleTypes ... types) {
        ITreeNode[] nodes;
        ITreeNode[] iTreeNodeArray = nodes = TreeUtility.findNodes(this.m_invisibleRootNode, new P_NodeByBundleTypeFilter(types));
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode n3 = iTreeNodeArray[n2];
            if (this.m_bundleTree.isChecked(n3)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public String getProjectName() {
        return this.m_propertySupport.getPropertyString("projectName");
    }

    public void setProjectName(String projectName) {
        try {
            this.setStateChanging(true);
            this.setProjectNameInternal(projectName);
            if (this.isControlCreated()) {
                this.m_projectNameField.setText(projectName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setProjectNameInternal(String projectName) {
        this.m_propertySupport.setPropertyString("projectName", projectName);
    }

    @Override
    public String getProjectNamePostfix() {
        return this.m_propertySupport.getPropertyString("projectNamePostfix");
    }

    public void setProjectNamePostfix(String projectPostfix) {
        try {
            this.setStateChanging(true);
            this.setProjectNamePostfixInternal(projectPostfix);
            if (this.isControlCreated()) {
                this.m_postFixField.setText(projectPostfix);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setProjectNamePostfixInternal(String projectPostfix) {
        this.m_propertySupport.setPropertyString("projectNamePostfix", projectPostfix);
    }

    @Override
    public String getProjectAlias() {
        return this.m_propertySupport.getPropertyString("projectAlias");
    }

    public void setProjectAlias(String projectAlias) {
        try {
            this.setStateChanging(true);
            this.setProjectAliasInternal(projectAlias);
            if (this.isControlCreated()) {
                this.m_projectAliasNameField.setText(projectAlias);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setProjectAliasInternal(String alias) {
        this.m_propertySupport.setPropertyString("projectAlias", alias);
    }

    private class P_InitialCheckNodesFilter
    implements ITreeNodeFilter {
        private P_InitialCheckNodesFilter() {
        }

        @Override
        public boolean accept(ITreeNode node) {
            switch (node.getType()) {
                case 99: {
                    return true;
                }
            }
            return false;
        }
    }

    private class P_NodeByBundleTypeFilter
    implements ITreeNodeFilter {
        private final HashSet<IScoutBundleExtension.BundleTypes> m_types = new HashSet();

        public P_NodeByBundleTypeFilter(IScoutBundleExtension.BundleTypes ... types) {
            if (types != null) {
                IScoutBundleExtension.BundleTypes[] bundleTypesArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    IScoutBundleExtension.BundleTypes s = bundleTypesArray[n2];
                    this.m_types.add(s);
                    ++n2;
                }
            }
        }

        @Override
        public boolean accept(ITreeNode node) {
            ScoutBundleExtension extension = (ScoutBundleExtension)node.getData();
            if (extension != null) {
                return this.m_types.contains((Object)extension.getBundleType());
            }
            return false;
        }
    }

    private class P_NodeByExtensionIdFilter
    implements ITreeNodeFilter {
        private final HashSet<String> m_ids = new HashSet();

        public P_NodeByExtensionIdFilter(String ... extensionIds) {
            if (extensionIds != null) {
                String[] stringArray = extensionIds;
                int n = extensionIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    this.m_ids.add(s);
                    ++n2;
                }
            }
        }

        @Override
        public boolean accept(ITreeNode node) {
            ScoutBundleExtension extension = (ScoutBundleExtension)node.getData();
            if (extension != null) {
                return this.m_ids.contains(extension.getBundleID());
            }
            return false;
        }
    }
}

