/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.menu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.commands.Command;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.extensions.IContextMenuContributor;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.ContextMenuContributorExtensionPoint;
import org.eclipse.scout.sdk.ui.menu.ScoutMenuContributionItemFactory;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.ui.services.IServiceLocator;

public class MenuVisibilityTester
extends PropertyTester {
    private static <T> boolean contains(T[] list, T toSearch) {
        if (list == null) {
            return false;
        }
        T[] TArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            if (t != null && t.equals(toSearch)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static IContextMenuContributor getMenuContributor(Class<? extends IScoutHandler> menu, IPage p) {
        IContextMenuContributor[] iContextMenuContributorArray = ContextMenuContributorExtensionPoint.getContextMenuContributors(p);
        int n = iContextMenuContributorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContextMenuContributor c = iContextMenuContributorArray[n2];
            Class<? extends IScoutHandler>[] menus = c.getSupportedMenuActionsFor(p);
            if (MenuVisibilityTester.contains(menus, menu)) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    private static HashMap<IPage, IContextMenuContributor> getMenuContributorsForAllPages(Class<? extends IScoutHandler> menu, IPage[] pages) {
        HashMap<IPage, IContextMenuContributor> mapping = new HashMap<IPage, IContextMenuContributor>();
        IPage[] iPageArray = pages;
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IPage p = iPageArray[n2];
            IContextMenuContributor c = MenuVisibilityTester.getMenuContributor(menu, p);
            mapping.put(p, c);
            ++n2;
        }
        return mapping;
    }

    private static void prepareMenu(IScoutHandler menu, HashMap<IPage, IContextMenuContributor> contributors) {
        for (IPage p : contributors.keySet()) {
            contributors.get(p).prepareMenuAction(p, menu);
        }
    }

    private static boolean isMenuAvailableInAllPages(HashMap<IPage, IContextMenuContributor> contributors) {
        for (IContextMenuContributor c : contributors.values()) {
            if (c != null) continue;
            return false;
        }
        return true;
    }

    private static IPage[] getFilteredSelection(Collection<?> c) {
        ArrayList<IPage> ret = new ArrayList<IPage>(c.size());
        for (Object o : c) {
            if (!(o instanceof IPage)) continue;
            ret.add((IPage)o);
        }
        return ret.toArray(new IPage[ret.size()]);
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof StructuredSelection) {
            receiver = ((StructuredSelection)receiver).toList();
        }
        if (receiver instanceof Collection && args != null && args.length == 3 && args[0] instanceof Class && args[1] instanceof Command && args[2] instanceof IServiceLocator && IScoutHandler.class.isAssignableFrom((Class)args[0])) {
            IScoutHandler currentMenu;
            Command cmd;
            block12: {
                HashMap<IPage, IContextMenuContributor> contributors;
                block11: {
                    IPage[] selectedNodes;
                    block10: {
                        Class currentMenuClass;
                        block9: {
                            selectedNodes = MenuVisibilityTester.getFilteredSelection((Collection)receiver);
                            if (selectedNodes.length == 0) {
                                return false;
                            }
                            currentMenuClass = (Class)args[0];
                            cmd = (Command)args[1];
                            contributors = MenuVisibilityTester.getMenuContributorsForAllPages(currentMenuClass, selectedNodes);
                            if (MenuVisibilityTester.isMenuAvailableInAllPages(contributors)) break block9;
                            return false;
                        }
                        currentMenu = ScoutMenuContributionItemFactory.getMenuInstance(currentMenuClass);
                        if (currentMenu != null) break block10;
                        return false;
                    }
                    if (currentMenu.isMultiSelectSupported() || selectedNodes.length <= 1) break block11;
                    return false;
                }
                MenuVisibilityTester.prepareMenu(currentMenu, contributors);
                if (currentMenu.isVisible()) break block12;
                return false;
            }
            try {
                IServiceLocator serviceLocator = (IServiceLocator)args[2];
                ScoutMenuContributionItemFactory.activateHandler(serviceLocator, currentMenu);
                ScoutMenuContributionItemFactory.registerKeyStroke(currentMenu.getKeyStroke(), cmd);
                return true;
            }
            catch (Exception e) {
                ScoutSdkUi.logError(e);
            }
        }
        return false;
    }
}

