/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.presenter.single;

import java.util.regex.Matcher;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.method.ScoutMethodDeleteOperation;
import org.eclipse.scout.sdk.ui.fields.tooltip.JavadocTooltip;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.AbstractPresenter;
import org.eclipse.scout.sdk.ui.view.properties.presenter.util.MethodErrorPresenterContent;
import org.eclipse.scout.sdk.util.Regex;
import org.eclipse.scout.sdk.util.SdkProperties;
import org.eclipse.scout.sdk.util.log.ScoutStatus;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public abstract class AbstractMethodPresenter
extends AbstractPresenter {
    private ConfigurationMethod m_configurationMethod;
    private Hyperlink m_labelLink;
    private Label m_label;
    private Composite m_body;
    private Composite m_linkComposite;
    private MethodErrorPresenterContent m_errorContent;
    private JavadocTooltip m_tooltip;
    private ImageHyperlink m_deleteButton;

    public AbstractMethodPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
        this.create(this.getContainer());
    }

    protected boolean isLinkMode() {
        return this.m_configurationMethod != null && this.m_configurationMethod.isImplemented();
    }

    protected void init(ConfigurationMethod method) throws CoreException {
        if (this.m_labelLink != null) {
            this.m_labelLink.dispose();
        }
        if (this.m_label != null) {
            this.m_label.dispose();
        }
        GridData gd = new GridData(131072, 128, true, false);
        if (this.isLinkMode()) {
            this.m_labelLink = this.getToolkit().createHyperlink(this.m_linkComposite, SdkProperties.getMethodPresenterName((IMethod)method.peekMethod()), 0);
            this.m_labelLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    AbstractMethodPresenter.this.handleLabelLinkSelected();
                }
            });
            this.m_labelLink.setEnabled(true);
            this.m_labelLink.setFont(this.getFont("org.eclipse.jface.dialogfont", true));
            this.m_labelLink.setLayoutData((Object)gd);
            this.m_labelLink.getParent().layout();
            this.m_tooltip = new JavadocTooltip((Control)this.m_labelLink);
        } else {
            this.m_label = this.getToolkit().createLabel(this.m_linkComposite, SdkProperties.getMethodPresenterName((IMethod)method.peekMethod()));
            this.m_label.setForeground(new Color((Device)this.m_linkComposite.getDisplay(), 0, 0, 128));
            this.m_label.setLayoutData((Object)gd);
            this.m_tooltip = new JavadocTooltip((Control)this.m_label);
        }
        this.m_tooltip.setMember((IMember)method.peekMethod());
    }

    protected void create(Composite parent) {
        GridLayout glayout = new GridLayout(1, true);
        glayout.horizontalSpacing = 0;
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.verticalSpacing = 0;
        parent.setLayout((Layout)glayout);
        this.createBody(parent);
    }

    private Control createBody(Composite parent) {
        this.m_body = this.getToolkit().createComposite(parent);
        this.m_linkComposite = this.getToolkit().createComposite(this.m_body);
        Control content = this.createContent(this.m_body);
        Composite buttonArea = this.getToolkit().createComposite(this.m_body);
        Canvas placeHolderControl = new Canvas(buttonArea, 0);
        this.fillButtonArea(buttonArea);
        GridLayout bodyLayout = new GridLayout(3, false);
        bodyLayout.horizontalSpacing = 0;
        bodyLayout.marginHeight = 0;
        bodyLayout.marginWidth = 0;
        bodyLayout.verticalSpacing = 0;
        this.m_body.setLayout((Layout)bodyLayout);
        GridData bodyLayoutData = new GridData(1808);
        this.m_body.setLayoutData((Object)bodyLayoutData);
        GridData linkCompData = new GridData();
        linkCompData.widthHint = 180;
        this.m_linkComposite.setLayoutData((Object)linkCompData);
        GridData contentData = new GridData(768);
        if (content != null) {
            content.setLayoutData((Object)contentData);
        }
        GridData buttonAreaData = new GridData(1040);
        buttonArea.setLayoutData((Object)buttonAreaData);
        this.m_linkComposite.setLayout((Layout)new GridLayout(1, true));
        GridLayout buttonBarLayout = new GridLayout(100, false);
        buttonBarLayout.horizontalSpacing = 0;
        buttonBarLayout.marginHeight = 0;
        buttonBarLayout.marginWidth = 0;
        buttonBarLayout.verticalSpacing = 0;
        buttonArea.setLayout((Layout)buttonBarLayout);
        placeHolderControl.setLayoutData((Object)new GridData(1, 1));
        return this.m_body;
    }

    protected void fillButtonArea(Composite buttonArea) {
        this.m_deleteButton = this.getToolkit().createImageHyperlink(buttonArea, 8);
        this.m_deleteButton.setImage(ScoutSdkUi.getImage("remove.png"));
        this.m_deleteButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (AbstractMethodPresenter.this.getMethod().isImplemented()) {
                    ScoutMethodDeleteOperation op = new ScoutMethodDeleteOperation(AbstractMethodPresenter.this.getMethod().peekMethod());
                    OperationJob job = new OperationJob(new IOperation[]{op});
                    job.schedule();
                }
            }
        });
        GridData deleteButtonData = new GridData(1028);
        this.m_deleteButton.setLayoutData((Object)deleteButtonData);
    }

    protected abstract Control createContent(Composite var1);

    public final void setMethod(ConfigurationMethod configurationMethod) {
        try {
            this.getContainer().setRedraw(false);
            this.m_configurationMethod = configurationMethod;
            try {
                this.init(configurationMethod);
                this.setErrorPresenterVisible(false);
            }
            catch (CoreException e) {
                if (this.m_errorContent == null) {
                    this.m_errorContent = new MethodErrorPresenterContent(this.getContainer(), this.getToolkit());
                    this.m_errorContent.setLayoutData(new GridData(1808));
                }
                if (e instanceof MethodErrorPresenterException) {
                    this.m_errorContent.setPresenterText(e.getMessage());
                }
                this.m_errorContent.setMethod(configurationMethod);
                this.setErrorPresenterVisible(true);
            }
            ((GridData)this.m_deleteButton.getLayoutData()).exclude = !configurationMethod.isImplemented();
            this.m_deleteButton.setVisible(configurationMethod.isImplemented());
            this.m_deleteButton.setToolTipText(Texts.get((String)"RemoveXinY", (String[])new String[]{this.getMethod().getMethodName(), this.getMethod().getType().getElementName()}));
        }
        finally {
            this.getContainer().setRedraw(true);
            this.getContainer().layout(true, true);
        }
    }

    private void setErrorPresenterVisible(boolean visible) {
        this.m_body.setVisible(!visible);
        ((GridData)this.m_body.getLayoutData()).exclude = visible;
        if (this.m_errorContent != null) {
            this.m_errorContent.setVisible(visible);
            ((GridData)this.m_errorContent.getLayoutData()).exclude = !visible;
        }
    }

    public ConfigurationMethod getMethod() {
        return this.m_configurationMethod;
    }

    public void setLabelText(String text) {
        if (!this.isDisposed()) {
            this.m_labelLink.setText(text);
        }
    }

    public String getLabelText() {
        String labelText = null;
        if (!this.isDisposed()) {
            labelText = this.m_labelLink.getText();
        }
        return labelText;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!this.isDisposed()) {
            if (this.m_errorContent != null) {
                this.m_errorContent.setEnabled(enabled);
            }
            this.m_deleteButton.setEnabled(enabled);
        }
    }

    @Override
    public boolean isEnabled() {
        if (!this.isDisposed()) {
            return this.m_deleteButton.isEnabled();
        }
        return false;
    }

    protected void handleLabelLinkSelected() {
        this.showJavaElementInEditor((IJavaElement)this.getMethod().peekMethod());
    }

    protected void showJavaElementInEditor(IJavaElement e) {
        this.showJavaElementInEditor(e, true);
    }

    protected void showJavaElementInEditor(IJavaElement e, boolean createNew) {
        UiUtility.showJavaElementInEditor(e, createNew);
    }

    protected final String readInitalValue() throws CoreException {
        try {
            Matcher m = Regex.REGEX_PROPERTY_METHOD_REPRESENTER_VALUE.matcher(this.getMethod().peekMethod().getSource());
            if (m.find()) {
                return m.group(1);
            }
            throw new CoreException((IStatus)new ScoutStatus(this.getMethod().peekMethod().getSource()));
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError(e);
            return null;
        }
    }

    protected static class MethodErrorPresenterException
    extends CoreException {
        private static final long serialVersionUID = 1L;

        public MethodErrorPresenterException(IStatus status) {
            super(status);
        }
    }
}

