/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.code.type;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.CodeTypeNewOperation;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.JavaElementAbstractTypeContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.signature.SignatureProposalProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.fields.code.CodeIdField;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.Regex;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class CodeTypeNewWizardPage
extends AbstractWorkspaceWizardPage {
    final IType iCodeType = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.common.code.ICodeType");
    final IType abstractCodeType = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.common.code.AbstractCodeType");
    private String m_nextCodeId;
    private String m_nextCodeIdSource;
    private INlsEntry m_nlsName;
    private String m_typeName;
    private IType m_superType;
    private String m_genericSignature;
    private CodeIdField m_nextCodeIdField;
    private ProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_superTypeField;
    private ProposalTextField m_genericTypeField;
    private final IScoutBundle m_sharedBundle;

    public CodeTypeNewWizardPage(IScoutBundle sharedBundle) {
        super(CodeTypeNewWizardPage.class.getName());
        this.m_sharedBundle = sharedBundle;
        this.setTitle(Texts.get((String)"NewCodeType"));
        this.setDescription(Texts.get((String)"CreateANewCodeType"));
        this.m_superType = this.abstractCodeType;
        this.m_genericSignature = Signature.createTypeSignature((String)Long.class.getName(), (boolean)true);
    }

    @Override
    public void postActivate() {
        this.m_nlsNameField.setFocus();
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_nextCodeIdField = new CodeIdField(parent, this.getSharedBundle().getScoutProject());
        this.m_nextCodeIdField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CodeTypeNewWizardPage.this.m_nextCodeId = CodeTypeNewWizardPage.this.m_nextCodeIdField.getValue();
                CodeTypeNewWizardPage.this.m_nextCodeIdSource = CodeTypeNewWizardPage.this.m_nextCodeIdField.getValueSource();
                CodeTypeNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, this.getSharedBundle().findBestMatchNlsProject(), Texts.get((String)"Name"));
        this.m_nlsNameField.acceptProposal(this.m_nlsName);
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    CodeTypeNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = CodeTypeNewWizardPage.this.getNlsName();
                    CodeTypeNewWizardPage.this.m_nlsName = (INlsEntry)event.proposal;
                    if (CodeTypeNewWizardPage.this.m_nlsName != null && (oldEntry == null || oldEntry.getKey().equals(CodeTypeNewWizardPage.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((String)CodeTypeNewWizardPage.this.m_typeNameField.getModifiableText()))) {
                        CodeTypeNewWizardPage.this.m_typeNameField.setText(CodeTypeNewWizardPage.this.m_nlsName.getKey());
                    }
                }
                finally {
                    CodeTypeNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"TypeName"));
        this.m_typeNameField.setReadOnlySuffix("CodeType");
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CodeTypeNewWizardPage.this.m_typeName = CodeTypeNewWizardPage.this.m_typeNameField.getText();
                CodeTypeNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_superTypeField = this.getFieldToolkit().createJavaElementProposalField(parent, Texts.get((String)"SuperType"), new JavaElementAbstractTypeContentProvider(this.iCodeType, this.getSharedBundle().getJavaProject(), this.abstractCodeType));
        this.m_superTypeField.acceptProposal(this.m_superType);
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    CodeTypeNewWizardPage.this.setStateChanging(true);
                    CodeTypeNewWizardPage.this.m_superType = (IType)event.proposal;
                    if (TypeUtility.isGenericType((IType)CodeTypeNewWizardPage.this.getSuperType())) {
                        CodeTypeNewWizardPage.this.m_genericTypeField.setEnabled(true);
                        if (CodeTypeNewWizardPage.this.getGenericSignature() == null) {
                            CodeTypeNewWizardPage.this.m_genericTypeField.acceptProposal(TypeUtility.getType((String)Long.class.getName()));
                        }
                    } else {
                        CodeTypeNewWizardPage.this.m_genericTypeField.setEnabled(false);
                    }
                }
                finally {
                    CodeTypeNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_genericTypeField = this.getFieldToolkit().createSignatureProposalField(parent, Texts.get((String)"GenericType"), this.getSharedBundle(), SignatureProposalProvider.DEFAULT_MOST_USED);
        this.m_genericTypeField.acceptProposal(this.getGenericSignature());
        this.m_genericTypeField.setEnabled(this.getSuperType() != null && TypeUtility.isGenericType((IType)this.getSuperType()));
        this.m_genericTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    CodeTypeNewWizardPage.this.setStateChanging(true);
                    CodeTypeNewWizardPage.this.m_genericSignature = (String)event.proposal;
                }
                finally {
                    CodeTypeNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_nextCodeIdField.setGenericTypeField(this.m_genericTypeField);
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_nextCodeIdField.setLayoutData(new GridData(768));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_superTypeField.setLayoutData(new GridData(768));
        this.m_genericTypeField.setLayoutData(new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        CodeTypeNewOperation op = new CodeTypeNewOperation();
        op.setSharedBundle(this.getSharedBundle());
        op.setTypeName(this.getTypeName());
        op.setNlsEntry(this.getNlsName());
        IType superTypeProp = this.getSuperType();
        if (superTypeProp != null) {
            String sig = null;
            sig = this.getGenericSignature() != null ? Signature.createTypeSignature((String)(String.valueOf(superTypeProp.getFullyQualifiedName()) + "<" + Signature.toString((String)this.getGenericSignature()) + ">"), (boolean)true) : Signature.createTypeSignature((String)superTypeProp.getFullyQualifiedName(), (boolean)true);
            op.setSuperTypeSignature(sig);
        }
        if (this.getGenericSignature() != null) {
            op.setGenericTypeSignature(this.getGenericSignature());
        }
        op.setNextCodeId(this.getNextCodeIdSource());
        op.setFormatSource(true);
        op.validate();
        op.run(monitor, workingCopyManager);
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNextCodeIdField());
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
            multiStatus.add(this.getStatusGenericType());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    public IScoutBundle getSharedBundle() {
        return this.m_sharedBundle;
    }

    protected IStatus getStatusNextCodeIdField() throws JavaModelException {
        if (this.isControlCreated()) {
            return this.m_nextCodeIdField.getStatus();
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("CodeType")) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_fieldNull"));
        }
        if (TypeUtility.existsType((String)(String.valueOf(this.getSharedBundle().getPackageName(".services.code")) + "." + this.getTypeName()))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (Regex.REGEX_WELLFORMD_JAVAFIELD.matcher(this.getTypeName()).matches()) {
            return Status.OK_STATUS;
        }
        if (Regex.REGEX_JAVAFIELD.matcher(this.getTypeName()).matches()) {
            return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    protected IStatus getStatusSuperType() throws JavaModelException {
        if (this.getSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"TheSuperTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusGenericType() throws JavaModelException {
        if (TypeUtility.isGenericType((IType)this.getSuperType()) && this.getGenericSignature() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"GenericTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    public void setNextCodeId(String nextCodeId) {
        try {
            this.setStateChanging(true);
            this.m_nextCodeId = nextCodeId;
            if (this.isControlCreated()) {
                this.m_nextCodeIdField.setValue(nextCodeId);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getNextCodeId() {
        return this.m_nextCodeId;
    }

    public String getNextCodeIdSource() {
        return this.m_nextCodeIdSource;
    }

    public INlsEntry getNlsName() {
        return this.m_nlsName;
    }

    public void setNlsName(INlsEntry nlsName) {
        try {
            this.setStateChanging(true);
            this.m_nlsName = nlsName;
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            this.m_superType = superType;
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public void setGenericSignature(String genericSignature) {
        try {
            this.setStateChanging(true);
            this.m_genericSignature = genericSignature;
            if (this.isControlCreated()) {
                this.m_genericTypeField.acceptProposal(genericSignature);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getGenericSignature() {
        return this.m_genericSignature;
    }
}

