/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.form.fields.composerfield.attribute;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.form.field.composer.ComposerAttributeNewOperation;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.JavaElementAbstractTypeContentProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.Regex;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class AttributeNewWizardPage
extends AbstractWorkspaceWizardPage {
    final IType iComposerAttribute = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.composer.attribute.IComposerAttribute");
    final IType abstractComposerAttribute = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.composer.attribute.AbstractComposerAttribute");
    public static final String PROP_NLS_NAME = "nlsName";
    public static final String PROP_TYPE_NAME = "typeName";
    public static final String PROP_SUPER_TYPE = "superType";
    private ProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_superTypeField;
    private final IType m_declaringType;
    private IType m_createdAttribtue;

    public AttributeNewWizardPage(IType declaringType) {
        super(AttributeNewWizardPage.class.getName());
        this.setTitle(Texts.get((String)"NewAttribute"));
        this.setDescription(Texts.get((String)"CreateANewComposerFieldAttribute"));
        this.m_declaringType = declaringType;
        IType superType = this.getSuperType();
        if (superType == null) {
            superType = this.abstractComposerAttribute;
        }
        this.setSuperTypeInternal(superType);
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, ScoutTypeUtility.findNlsProject((IJavaElement)this.m_declaringType), Texts.get((String)"Name"));
        this.m_nlsNameField.acceptProposal(this.getNlsName());
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    AttributeNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = AttributeNewWizardPage.this.getNlsName();
                    INlsEntry newEntry = (INlsEntry)event.proposal;
                    AttributeNewWizardPage.this.setNlsNameInternal(newEntry);
                    if (newEntry != null && (oldEntry == null || oldEntry.getKey().equals(AttributeNewWizardPage.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((String)AttributeNewWizardPage.this.m_typeNameField.getModifiableText()))) {
                        AttributeNewWizardPage.this.m_typeNameField.setText(newEntry.getKey());
                    }
                }
                finally {
                    AttributeNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"TypeName"));
        this.m_typeNameField.setReadOnlySuffix("Attribute");
        this.m_typeNameField.setText(this.getTypeName());
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AttributeNewWizardPage.this.setTypeNameInternal(AttributeNewWizardPage.this.m_typeNameField.getText());
                AttributeNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_superTypeField = this.getFieldToolkit().createJavaElementProposalField(parent, Texts.get((String)"SuperType"), new JavaElementAbstractTypeContentProvider(this.iComposerAttribute, this.m_declaringType.getJavaProject(), this.abstractComposerAttribute));
        this.m_superTypeField.acceptProposal(this.getSuperType());
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                AttributeNewWizardPage.this.setSuperTypeInternal((IType)event.proposal);
                AttributeNewWizardPage.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_superTypeField.setLayoutData(new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        ComposerAttributeNewOperation operation = new ComposerAttributeNewOperation(this.m_declaringType);
        if (this.getNlsName() != null) {
            operation.setNlsEntry(this.getNlsName());
        }
        operation.setTypeName(this.getTypeName());
        IType superTypeProp = this.getSuperType();
        if (superTypeProp != null) {
            operation.setSuperTypeSignature(Signature.createTypeSignature((String)superTypeProp.getFullyQualifiedName(), (boolean)true));
        }
        IStructuredType structuredType = ScoutTypeUtility.createStructuredComposer((IType)this.m_declaringType);
        operation.setSibling(structuredType.getSiblingComposerAttribute(this.getTypeName()));
        operation.run(monitor, workingCopyManager);
        this.m_createdAttribtue = operation.getCreatedAttribute();
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("Attribute")) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_fieldNull"));
        }
        if (TypeUtility.exists((IJavaElement)this.m_declaringType.getType(this.getTypeName()))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (Regex.REGEX_WELLFORMD_JAVAFIELD.matcher(this.getTypeName()).matches()) {
            return Status.OK_STATUS;
        }
        if (Regex.REGEX_JAVAFIELD.matcher(this.getTypeName()).matches()) {
            return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    protected IStatus getStatusSuperType() throws JavaModelException {
        if (this.getSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"TheSuperTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    public IType getCreatedAttribute() {
        return this.m_createdAttribtue;
    }

    public INlsEntry getNlsName() {
        return (INlsEntry)this.getProperty(PROP_NLS_NAME);
    }

    public void setNlsName(INlsEntry nlsName) {
        try {
            this.setStateChanging(true);
            this.setNlsNameInternal(nlsName);
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setNlsNameInternal(INlsEntry nlsName) {
        this.setProperty(PROP_NLS_NAME, nlsName);
    }

    public String getTypeName() {
        return this.getPropertyString(PROP_TYPE_NAME);
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.setTypeNameInternal(typeName);
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setTypeNameInternal(String typeName) {
        this.setPropertyString(PROP_TYPE_NAME, typeName);
    }

    public IType getSuperType() {
        return (IType)this.getProperty(PROP_SUPER_TYPE);
    }

    public void setSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            this.setSuperTypeInternal(superType);
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setSuperTypeInternal(IType superType) {
        this.setProperty(PROP_SUPER_TYPE, superType);
    }
}

