/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.services;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.wizards.NewPackageCreationWizard;
import org.eclipse.jdt.ui.wizards.NewPackageWizardPage;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.PackageNewOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public class CustomServiceNewPackageWizard
extends NewPackageCreationWizard {
    private NewPackageWizardPage m_page1;
    private IJavaProject m_javaProject;
    private final IScoutBundle m_serverBundle;

    public CustomServiceNewPackageWizard(IScoutBundle serverBundle) throws JavaModelException {
        this.m_serverBundle = serverBundle;
        this.m_javaProject = this.getServerBundle().getJavaProject();
    }

    public void addPages() {
        super.addPages();
        try {
            String srcPath = "/" + this.m_javaProject.getElementName() + "/" + "src";
            this.m_page1 = (NewPackageWizardPage)this.getPages()[0];
            this.m_page1.setPackageFragmentRoot(this.m_javaProject.findPackageFragmentRoot((IPath)new Path(srcPath)), false);
            this.m_page1.setPackageText(this.getServerBundle().getPackageName(".services.custom"), true);
        }
        catch (Exception e) {
            ScoutSdkUi.logError(e);
            this.performCancel();
        }
    }

    public boolean performFinish() {
        String packageName = this.m_page1.getPackageText();
        PackageNewOperation packageNewOperation = new PackageNewOperation(this.m_javaProject, "src", packageName);
        OperationJob job = new OperationJob(new IOperation[]{packageNewOperation});
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            ScoutSdkUi.logWarning(e);
        }
        return true;
    }

    public IScoutBundle getServerBundle() {
        return this.m_serverBundle;
    }
}

