/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.services;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.service.ProcessServiceNewOperation;
import org.eclipse.scout.sdk.ui.fields.bundletree.DndEvent;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeDndListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.ui.wizard.BundleTreeWizardPage;
import org.eclipse.scout.sdk.ui.wizard.IStatusProvider;
import org.eclipse.scout.sdk.ui.wizard.services.ProcessServiceNewWizardPage;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutProject;

public class ProcessServiceNewWizard
extends AbstractWorkspaceWizard {
    public static final int TYPE_PERMISSION_CREATE = 104;
    public static final int TYPE_PERMISSION_READ = 105;
    public static final int TYPE_PERMISSION_UPDATE = 106;
    public static final int TYPE_SERVICE_INTERFACE = 107;
    public static final int TYPE_SERVICE_IMPLEMENTATION = 108;
    public static final int TYPE_SERVICE_REG_CLIENT = 109;
    public static final int TYPE_SERVICE_REG_SERVER = 110;
    final IType abstractService = TypeUtility.getType((String)"org.eclipse.scout.service.AbstractService");
    private BundleTreeWizardPage m_locationWizardPage;
    private ProcessServiceNewWizardPage m_serviceNewWizardPage;
    private ProcessServiceNewOperation m_operation = new ProcessServiceNewOperation();
    private ITreeNode m_locationWizardPageRoot;

    public ProcessServiceNewWizard(IScoutBundle serverBundle) {
        this.setWindowTitle(Texts.get((String)"NewProcessService"));
        P_StatusRevalidator statusProvider = new P_StatusRevalidator();
        this.m_serviceNewWizardPage = new ProcessServiceNewWizardPage();
        this.m_serviceNewWizardPage.setServerBundle(serverBundle);
        this.m_serviceNewWizardPage.addPropertyChangeListener(new P_LocationPropertyListener());
        this.addPage((IWizardPage)this.m_serviceNewWizardPage);
        this.m_locationWizardPageRoot = this.createTree(serverBundle);
        this.m_locationWizardPage = new BundleTreeWizardPage(Texts.get((String)"ProcessServiceLocation"), Texts.get((String)"OrganiseLocations"), this.m_locationWizardPageRoot, new P_InitialCheckerFilter());
        this.m_locationWizardPage.addStatusProvider(statusProvider);
        this.m_locationWizardPage.addDndListener(new P_TreeDndListener());
        this.addPage((IWizardPage)this.m_locationWizardPage);
        this.m_serviceNewWizardPage.setSuperType(this.abstractService);
    }

    private ITreeNode createTree(IScoutBundle serverBundle) {
        IScoutBundle sharedBundle = null;
        IScoutBundle clientBundle = null;
        IScoutProject scoutProject = serverBundle.getScoutProject();
        while ((sharedBundle == null || clientBundle == null) && scoutProject != null) {
            sharedBundle = scoutProject.getSharedBundle();
            clientBundle = scoutProject.getClientBundle();
            scoutProject = scoutProject.getParentProject();
        }
        ITreeNode rootNode = TreeUtility.createBundleTree(serverBundle.getScoutProject(), NodeFilters.getAcceptAll());
        if (clientBundle != null) {
            ITreeNode clientNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(clientBundle));
            TreeUtility.createNode(clientNode, 109, Texts.get((String)"ServiceProxyRegistration"), ScoutSdkUi.getImageDescriptor("public_co.gif"), 109L);
        }
        if (sharedBundle != null) {
            ITreeNode sharedNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(sharedBundle));
            TreeUtility.createNode(sharedNode, 104, Texts.get((String)"CreatePermission"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 104L);
            TreeUtility.createNode(sharedNode, 105, Texts.get((String)"ReadPermission"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 105L);
            TreeUtility.createNode(sharedNode, 106, Texts.get((String)"UpdatePermission"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 106L);
            TreeUtility.createNode(sharedNode, 107, Texts.get((String)"IService"), ScoutSdkUi.getImageDescriptor("innerinterface_obj.gif"), 107L);
        }
        ITreeNode serverNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(serverBundle));
        TreeUtility.createNode(serverNode, 108, Texts.get((String)"Service"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 108L);
        TreeUtility.createNode(serverNode, 110, Texts.get((String)"ServiceRegistration"), ScoutSdkUi.getImageDescriptor("public_co.gif"), 110L);
        return rootNode;
    }

    @Override
    protected boolean beforeFinish() throws CoreException {
        this.m_serviceNewWizardPage.fillProcessServiceNewOperation(this.m_operation);
        this.m_operation.setClientServiceRegistryBundles(this.m_locationWizardPage.getLocationBundles(109, true, true));
        this.m_operation.setPermissionCreateBundle(this.m_locationWizardPage.getLocationBundle(104, true, true));
        this.m_operation.setPermissionCreateName(this.m_locationWizardPage.getTextOfNode(104, true, true));
        this.m_operation.setPermissionReadBundle(this.m_locationWizardPage.getLocationBundle(105, true, true));
        this.m_operation.setPermissionReadName(this.m_locationWizardPage.getTextOfNode(105, true, true));
        this.m_operation.setPermissionUpdateBundle(this.m_locationWizardPage.getLocationBundle(106, true, true));
        this.m_operation.setPermissionUpdateName(this.m_locationWizardPage.getTextOfNode(106, true, true));
        this.m_operation.setServerServiceRegistryBundles(this.m_locationWizardPage.getLocationBundles(110, true, true));
        this.m_operation.setServiceImplementationBundle(this.m_locationWizardPage.getLocationBundle(108, true, true));
        this.m_operation.setServiceImplementationName(this.m_locationWizardPage.getTextOfNode(108, true, true));
        this.m_operation.setServiceInterfaceBundle(this.m_locationWizardPage.getLocationBundle(107, true, true));
        this.m_operation.setServiceInterfaceName(this.m_locationWizardPage.getTextOfNode(107, true, true));
        return true;
    }

    @Override
    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        try {
            this.m_operation.validate();
            this.m_operation.run(monitor, workingCopyManager);
            return true;
        }
        catch (IllegalArgumentException e) {
            ScoutSdkUi.logWarning("validation error of operation '" + this.m_operation.getOperationName() + "'. " + e.getMessage());
            return false;
        }
        catch (CoreException e) {
            ScoutSdkUi.logError("error during executing operation '" + this.m_operation.getOperationName() + "'.", e);
            return false;
        }
    }

    private class P_InitialCheckerFilter
    implements ITreeNodeFilter {
        private P_InitialCheckerFilter() {
        }

        @Override
        public boolean accept(ITreeNode node) {
            switch (node.getType()) {
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: {
                    return true;
                }
            }
            return false;
        }
    }

    private class P_LocationPropertyListener
    implements PropertyChangeListener {
        private P_LocationPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("typeName")) {
                String typeName = ProcessServiceNewWizard.this.m_serviceNewWizardPage.getTypeName();
                if (!StringUtility.isNullOrEmpty((String)typeName)) {
                    String prefix = typeName.replaceAll("ProcessService$", "");
                    TreeUtility.findNode(ProcessServiceNewWizard.this.m_locationWizardPageRoot, NodeFilters.getByType(104)).setText("Create" + prefix + "Permission");
                    TreeUtility.findNode(ProcessServiceNewWizard.this.m_locationWizardPageRoot, NodeFilters.getByType(105)).setText("Read" + prefix + "Permission");
                    TreeUtility.findNode(ProcessServiceNewWizard.this.m_locationWizardPageRoot, NodeFilters.getByType(106)).setText("Update" + prefix + "Permission");
                    TreeUtility.findNode(ProcessServiceNewWizard.this.m_locationWizardPageRoot, NodeFilters.getByType(108)).setText(String.valueOf(prefix) + "ProcessService");
                    TreeUtility.findNode(ProcessServiceNewWizard.this.m_locationWizardPageRoot, NodeFilters.getByType(107)).setText("I" + prefix + "ProcessService");
                    ProcessServiceNewWizard.this.m_locationWizardPage.refreshTree();
                }
                ProcessServiceNewWizard.this.m_locationWizardPage.pingStateChanging();
            }
        }
    }

    private class P_StatusRevalidator
    implements IStatusProvider {
        private P_StatusRevalidator() {
        }

        @Override
        public void validate(Object source, MultiStatus multiStatus) {
            multiStatus.add(this.getStatusTypeNames());
            multiStatus.add(this.getStatusService());
            multiStatus.add(this.getStatusServiceRegistrationClient());
            multiStatus.add(this.getStatusServiceRegistrationServer());
        }

        protected IStatus getStatusTypeNames() {
            String fqn;
            ITreeNode serviceInterfaceNode;
            String fqn2;
            ITreeNode serviceImplNode;
            IScoutBundle serviceImplementationBundle = ProcessServiceNewWizard.this.m_locationWizardPage.getLocationBundle(108, true, true);
            if (serviceImplementationBundle != null && (serviceImplNode = ProcessServiceNewWizard.this.m_locationWizardPage.getTreeNode(108, true, true)) != null && serviceImplementationBundle.findType(fqn2 = String.valueOf(serviceImplementationBundle.getPackageName(".services.process")) + "." + serviceImplNode.getText()) != null) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "'" + serviceImplNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
            }
            IScoutBundle serviceInterfaceBundle = ProcessServiceNewWizard.this.m_locationWizardPage.getLocationBundle(107, true, true);
            if (serviceInterfaceBundle != null && (serviceInterfaceNode = ProcessServiceNewWizard.this.m_locationWizardPage.getTreeNode(107, true, true)) != null && serviceInterfaceBundle.findType(fqn = String.valueOf(serviceInterfaceBundle.getPackageName(".services.process")) + "." + serviceInterfaceNode.getText()) != null) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "'" + serviceInterfaceNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
            }
            IStatus createStatus = this.getStatusPermission(104);
            if (createStatus != Status.OK_STATUS) {
                return createStatus;
            }
            IStatus readStatus = this.getStatusPermission(105);
            if (readStatus != Status.OK_STATUS) {
                return readStatus;
            }
            IStatus updateStatus = this.getStatusPermission(106);
            if (updateStatus != Status.OK_STATUS) {
                return updateStatus;
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusPermission(int permissionType) {
            String fqn;
            ITreeNode permissionNode;
            IScoutBundle permissionBundle = ProcessServiceNewWizard.this.m_locationWizardPage.getLocationBundle(permissionType, true, true);
            if (permissionBundle != null && (permissionNode = ProcessServiceNewWizard.this.m_locationWizardPage.getTreeNode(permissionType, true, true)) != null && permissionBundle.findType(fqn = String.valueOf(permissionBundle.getPackageName(".security")) + "." + permissionNode.getText()) != null) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "'" + permissionNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusService() {
            IScoutBundle serviceImplementationBundle = ProcessServiceNewWizard.this.m_locationWizardPage.getLocationBundle(108, true, true);
            if (serviceImplementationBundle != null) {
                IScoutBundle serviceInterfaceBundle = ProcessServiceNewWizard.this.m_locationWizardPage.getLocationBundle(107, true, true);
                if (serviceInterfaceBundle != null && !serviceImplementationBundle.isOnClasspath(serviceInterfaceBundle)) {
                    return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{ProcessServiceNewWizard.this.m_locationWizardPage.getTextOfNode(107), ProcessServiceNewWizard.this.m_locationWizardPage.getTextOfNode(108)}));
                }
                IScoutBundle permissionCreateBundle = ProcessServiceNewWizard.this.m_locationWizardPage.getLocationBundle(104, true, true);
                if (permissionCreateBundle != null && !serviceImplementationBundle.isOnClasspath(permissionCreateBundle)) {
                    return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{ProcessServiceNewWizard.this.m_locationWizardPage.getTextOfNode(104), ProcessServiceNewWizard.this.m_locationWizardPage.getTextOfNode(108)}));
                }
                IScoutBundle permissionReadBundle = ProcessServiceNewWizard.this.m_locationWizardPage.getLocationBundle(105, true, true);
                if (permissionReadBundle != null && !serviceImplementationBundle.isOnClasspath(permissionReadBundle)) {
                    return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{ProcessServiceNewWizard.this.m_locationWizardPage.getTextOfNode(105), ProcessServiceNewWizard.this.m_locationWizardPage.getTextOfNode(108)}));
                }
                IScoutBundle permissionUpdateBundle = ProcessServiceNewWizard.this.m_locationWizardPage.getLocationBundle(106, true, true);
                if (permissionUpdateBundle != null && !serviceImplementationBundle.isOnClasspath(permissionUpdateBundle)) {
                    return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{ProcessServiceNewWizard.this.m_locationWizardPage.getTextOfNode(106), ProcessServiceNewWizard.this.m_locationWizardPage.getTextOfNode(108)}));
                }
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusServiceRegistrationClient() {
            ITreeNode[] serviceRegistrationClientNodes;
            IScoutBundle serviceInterfaceBundle = ProcessServiceNewWizard.this.m_locationWizardPage.getLocationBundle(107, true, true);
            ITreeNode[] iTreeNodeArray = serviceRegistrationClientNodes = ProcessServiceNewWizard.this.m_locationWizardPage.getTreeNodes(109, true, true);
            int n = serviceRegistrationClientNodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode serviceRegNode = iTreeNodeArray[n2];
                Object data = serviceRegNode.getParent().getData();
                if (data instanceof IScoutBundle) {
                    IScoutBundle serviceRegistrationBundle = (IScoutBundle)data;
                    if (serviceInterfaceBundle != null && serviceRegistrationBundle != null && !serviceRegistrationBundle.isOnClasspath(serviceInterfaceBundle)) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotOnClasspathOfServiceY", (String[])new String[]{ProcessServiceNewWizard.this.m_locationWizardPage.getTextOfNode(107), serviceRegistrationBundle.getBundleName()}));
                    }
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusServiceRegistrationServer() {
            ITreeNode[] serviceRegistrationServerNodes;
            IScoutBundle serviceImplementationBundle = ProcessServiceNewWizard.this.m_locationWizardPage.getLocationBundle(108, true, true);
            ITreeNode[] iTreeNodeArray = serviceRegistrationServerNodes = ProcessServiceNewWizard.this.m_locationWizardPage.getTreeNodes(110, true, true);
            int n = serviceRegistrationServerNodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode serviceRegNode = iTreeNodeArray[n2];
                Object data = serviceRegNode.getParent().getData();
                if (data instanceof IScoutBundle) {
                    IScoutBundle serviceRegistrationBundle = (IScoutBundle)data;
                    if (serviceImplementationBundle != null && serviceRegistrationBundle != null && !serviceRegistrationBundle.isOnClasspath(serviceImplementationBundle)) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotOnClasspathOfServiceY", (String[])new String[]{ProcessServiceNewWizard.this.m_locationWizardPage.getTextOfNode(108), serviceRegistrationBundle.getBundleName()}));
                    }
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }
    }

    private class P_TreeDndListener
    implements ITreeDndListener {
        private P_TreeDndListener() {
        }

        @Override
        public boolean isDragableNode(ITreeNode node) {
            switch (node.getType()) {
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void validateTarget(DndEvent dndEvent) {
            if (dndEvent.targetParent == null) {
                dndEvent.doit = false;
                return;
            }
            if (dndEvent.operation == 1) {
                this.validateDropCopy(dndEvent);
            } else if (dndEvent.operation == 2) {
                this.validateDropMove(dndEvent);
            }
        }

        @Override
        public void dndPerformed(DndEvent dndEvent) {
            ProcessServiceNewWizard.this.m_serviceNewWizardPage.pingStateChanging();
        }

        private void validateDropCopy(DndEvent dndEvent) {
            switch (dndEvent.node.getType()) {
                case 109: {
                    dndEvent.doit = dndEvent.targetParent.getType() == 3;
                    break;
                }
                case 110: {
                    dndEvent.doit = dndEvent.targetParent.getType() == 5;
                    break;
                }
                default: {
                    dndEvent.doit = false;
                }
            }
        }

        private void validateDropMove(DndEvent dndEvent) {
            switch (dndEvent.node.getType()) {
                case 109: {
                    dndEvent.doit = dndEvent.targetParent.getType() == 3;
                    break;
                }
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    dndEvent.doit = dndEvent.targetParent.getType() == 4;
                    break;
                }
                case 108: 
                case 110: {
                    dndEvent.doit = dndEvent.targetParent.getType() == 5;
                    break;
                }
                default: {
                    dndEvent.doit = false;
                }
            }
        }
    }
}

