/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.tablecolumn;

import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.fields.table.FilteredTable;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ui.wizard.tablecolumn.DefaultTableColumnNewWizard;
import org.eclipse.scout.sdk.ui.wizard.tablecolumn.SmartTableColumnNewWizard;
import org.eclipse.scout.sdk.ui.wizard.tablecolumn.TableColumnNewWizard;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class TableColumnNewWizardPage1
extends AbstractWorkspaceWizardPage {
    final IType iColumn = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn");
    final IType iSmartColumn = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.basic.table.columns.ISmartColumn");
    private IType m_declaringType;
    private boolean m_showAllTemplates;
    private TableColumnNewWizard.CONTINUE_OPERATION m_nextOperation;
    private FilteredTable m_filteredTable;
    private Button m_showAllTemplatesField;
    private P_BCTypeTemplate m_selectedTemplate;
    private IWizardPage m_nextPage;

    public TableColumnNewWizardPage1(IType declaringType, TableColumnNewWizard.CONTINUE_OPERATION op) {
        super(TableColumnNewWizardPage1.class.getName());
        this.setTitle(Texts.get((String)"TableColumnTemplates"));
        this.setDescription(Texts.get((String)"ChooseATemplateForYourTableColumn"));
        this.m_declaringType = declaringType;
        this.m_nextOperation = op;
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_filteredTable = new FilteredTable(parent, 68100);
        this.m_filteredTable.getViewer().addFilter((ViewerFilter)new P_ModeFilter());
        this.m_filteredTable.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    TableColumnNewWizardPage1.this.m_selectedTemplate = (P_BCTypeTemplate)selection.getFirstElement();
                    TableColumnNewWizardPage1.this.validateNextPage();
                    TableColumnNewWizardPage1.this.pingStateChanging();
                }
            }
        });
        this.m_filteredTable.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object selectedItem = null;
                if (!event.getSelection().isEmpty()) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    selectedItem = selection.getFirstElement();
                    TableColumnNewWizardPage1.this.m_selectedTemplate = (P_BCTypeTemplate)selectedItem;
                    TableColumnNewWizardPage1.this.validateNextPage();
                    IWizardPage page = TableColumnNewWizardPage1.this.getNextPage();
                    if (page == null) {
                        return;
                    }
                    IWizardContainer container = TableColumnNewWizardPage1.this.getWizard().getContainer();
                    if (container != null) {
                        container.showPage(page);
                    }
                }
            }
        });
        HashMap<String, P_BCTypeTemplate> templates = new HashMap<String, P_BCTypeTemplate>();
        templates.put("org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractStringColumn", new P_BCTypeTemplate(Texts.get((String)"StringColumn"), TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractStringColumn")));
        templates.put("org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractBooleanColumn", new P_BCTypeTemplate(Texts.get((String)"BooleanColumn"), TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractBooleanColumn")));
        templates.put("org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractDateColumn", new P_BCTypeTemplate(Texts.get((String)"DateColumn"), TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractDateColumn")));
        templates.put("org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractDoubleColumn", new P_BCTypeTemplate(Texts.get((String)"DoubleColumn"), TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractDoubleColumn")));
        templates.put("org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractIntegerColumn", new P_BCTypeTemplate(Texts.get((String)"IntegerColumn"), TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractIntegerColumn")));
        templates.put("org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractLongColumn", new P_BCTypeTemplate(Texts.get((String)"LongColumn"), TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractLongColumn")));
        templates.put("org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractSmartColumn", new P_BCTypeTemplate(Texts.get((String)"SmartColumn"), TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractSmartColumn")));
        IPrimaryTypeTypeHierarchy columnHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)this.iColumn);
        IType[] iTypeArray = columnHierarchy.getAllClasses(TypeFilters.getAbstractOnClasspath((IJavaProject)this.m_declaringType.getJavaProject()));
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            if (!templates.containsKey(t.getFullyQualifiedName())) {
                templates.put(t.getFullyQualifiedName(), new P_BCTypeTemplate(null, t));
            }
            ++n2;
        }
        P_TableContentProvider provider = new P_TableContentProvider(templates.values().toArray(new P_BCTypeTemplate[templates.size()]));
        this.m_filteredTable.getViewer().setLabelProvider((IBaseLabelProvider)provider);
        this.m_filteredTable.getViewer().setContentProvider((IContentProvider)provider);
        this.m_filteredTable.getViewer().setInput((Object)provider);
        this.m_showAllTemplatesField = new Button(parent, 32);
        this.m_showAllTemplatesField.setSelection(false);
        this.m_showAllTemplatesField.setText(Texts.get((String)"ShowAllTemplates"));
        this.m_showAllTemplatesField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TableColumnNewWizardPage1.this.setStateChanging(true);
                    TableColumnNewWizardPage1.this.setShowAllTemplates(TableColumnNewWizardPage1.this.m_showAllTemplatesField.getSelection());
                }
                finally {
                    TableColumnNewWizardPage1.this.setStateChanging(false);
                }
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_filteredTable.setLayoutData(new GridData(1808));
    }

    protected void validateNextPage() {
        if (this.m_selectedTemplate == null) {
            this.m_nextPage = null;
        } else {
            ITypeHierarchy selectedSuperTypeHierarchy = null;
            try {
                selectedSuperTypeHierarchy = this.m_selectedTemplate.getType().newSupertypeHierarchy(null);
            }
            catch (JavaModelException e) {
                ScoutSdkUi.logError("could not build type hierarchy of '" + this.m_selectedTemplate.getType().getFullyQualifiedName() + "'.", e);
            }
            if (selectedSuperTypeHierarchy != null && selectedSuperTypeHierarchy.contains(this.iSmartColumn)) {
                SmartTableColumnNewWizard wizard = new SmartTableColumnNewWizard(this.m_nextOperation);
                wizard.initWizard(this.m_declaringType);
                wizard.setSuperType(this.m_selectedTemplate.getType());
                this.m_nextPage = wizard.getPages()[0];
            } else {
                DefaultTableColumnNewWizard wizard = new DefaultTableColumnNewWizard(this.m_nextOperation);
                wizard.initWizard(this.m_declaringType);
                wizard.setSuperType(this.m_selectedTemplate.getType());
                this.m_nextPage = wizard.getPages()[0];
            }
        }
    }

    public IWizardPage getNextPage() {
        return this.m_nextPage;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        if (this.m_selectedTemplate != null) {
            multiStatus.add(Status.OK_STATUS);
        } else {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"ATemplateMustBeSelected")));
        }
    }

    public void setSuperType(IType selectedType) {
        IStructuredContentProvider prov = (IStructuredContentProvider)this.m_filteredTable.getViewer().getContentProvider();
        Object[] objectArray = prov.getElements(null);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object row = objectArray[n2];
            if (((P_BCTypeTemplate)row).getType().equals(selectedType)) {
                this.m_filteredTable.getViewer().setSelection((ISelection)new StructuredSelection((Object)selectedType));
            }
            ++n2;
        }
        this.validateNextPage();
    }

    public boolean isShowAllTemplates() {
        return this.m_showAllTemplates;
    }

    public void setShowAllTemplates(boolean showAllTemplates) {
        try {
            this.setStateChanging(true);
            this.m_showAllTemplates = showAllTemplates;
            if (this.isControlCreated()) {
                this.m_showAllTemplatesField.setSelection(showAllTemplates);
                this.m_filteredTable.getViewer().refresh();
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getSelectedSuperType() {
        return this.m_selectedTemplate.getType();
    }

    private class P_BCTypeTemplate {
        private final IType m_type;
        private final String m_templateName;

        public P_BCTypeTemplate(String templateName, IType type) {
            this.m_templateName = templateName;
            this.m_type = type;
        }

        public IType getType() {
            return this.m_type;
        }

        public String getTemplateName() {
            return this.m_templateName;
        }
    }

    private class P_ModeFilter
    extends ViewerFilter {
        private P_ModeFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (TableColumnNewWizardPage1.this.m_showAllTemplates) {
                return true;
            }
            return ((P_BCTypeTemplate)element).getTemplateName() != null;
        }
    }

    private class P_TableContentProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        P_BCTypeTemplate[] m_templates;

        private P_TableContentProvider(P_BCTypeTemplate[] templates) {
            this.m_templates = templates;
        }

        public Object[] getElements(Object inputElement) {
            return this.m_templates;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ScoutSdkUi.getImage("formField.png");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (TableColumnNewWizardPage1.this.isShowAllTemplates()) {
                return ((P_BCTypeTemplate)element).getType().getElementName();
            }
            return ((P_BCTypeTemplate)element).getTemplateName();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

