/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.internal.typecache;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeUtility;

public class TypeHierarchy
implements org.eclipse.scout.sdk.util.typecache.ITypeHierarchy {
    private ITypeHierarchy m_hierarchy;
    private final IType m_type;

    TypeHierarchy(IType type) {
        this(type, null);
    }

    TypeHierarchy(IType type, ITypeHierarchy jdtHierarchy) {
        this.setJdtHierarchy(jdtHierarchy);
        this.m_type = type;
    }

    @Override
    public ITypeHierarchy getJdtHierarchy() {
        return this.m_hierarchy;
    }

    protected void setJdtHierarchy(ITypeHierarchy hierarchy) {
        this.m_hierarchy = hierarchy;
    }

    @Override
    public boolean contains(IType type) {
        return this.contains(type, null);
    }

    public boolean contains(IType type, IProgressMonitor monitor) {
        this.revalidate(monitor);
        return TypeUtility.exists((IJavaElement)type) && this.m_hierarchy.contains(type);
    }

    void revalidate(IProgressMonitor monitor) {
    }

    @Override
    public IType getType() {
        return this.m_type;
    }

    @Override
    public IType[] getAllClasses() {
        return this.getAllClasses(null);
    }

    @Override
    public IType[] getAllClasses(ITypeFilter filter) {
        return this.getAllClasses(filter, null);
    }

    @Override
    public IType[] getAllClasses(ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidate(null);
        IType[] classes = this.m_hierarchy.getAllClasses();
        HashSet<IType> unsortedResult = new HashSet<IType>();
        IType[] iTypeArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            IType candidate = iTypeArray[n2];
            if (TypeUtility.exists((IJavaElement)candidate) && (filter == null || filter.accept(candidate))) {
                unsortedResult.add(candidate);
            }
            ++n2;
        }
        if (comparator != null) {
            TreeSet<IType> sortedResult = new TreeSet<IType>(comparator);
            sortedResult.addAll(unsortedResult);
            return sortedResult.toArray(new IType[sortedResult.size()]);
        }
        return unsortedResult.toArray(new IType[unsortedResult.size()]);
    }

    @Override
    public IType[] getAllInterfaces() {
        return this.getAllInterfaces(null);
    }

    @Override
    public IType[] getAllInterfaces(ITypeFilter filter) {
        return this.getAllInterfaces(filter, null);
    }

    @Override
    public IType[] getAllInterfaces(ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidate(null);
        IType[] types = this.m_hierarchy.getAllInterfaces();
        HashSet<IType> unsortedResult = new HashSet<IType>();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType candidate = iTypeArray[n2];
            if (TypeUtility.exists((IJavaElement)candidate) && (filter == null || filter.accept(candidate))) {
                unsortedResult.add(candidate);
            }
            ++n2;
        }
        if (comparator != null) {
            TreeSet<IType> sortedResult = new TreeSet<IType>(comparator);
            sortedResult.addAll(unsortedResult);
            return sortedResult.toArray(new IType[sortedResult.size()]);
        }
        return unsortedResult.toArray(new IType[unsortedResult.size()]);
    }

    @Override
    public boolean isSubtype(IType type, IType potentialSubtype) {
        HashSet<IType> allSubTypes = new HashSet<IType>(Arrays.asList(this.getAllSubtypes(type)));
        allSubTypes.add(type);
        return allSubTypes.contains(potentialSubtype);
    }

    @Override
    public boolean containsInSubhierarchy(IType type, IType[] potentialSubtypes) {
        HashSet<IType> allSubTypes = new HashSet<IType>(Arrays.asList(this.getAllSubtypes(type)));
        allSubTypes.add(type);
        IType[] iTypeArray = potentialSubtypes;
        int n = potentialSubtypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType pt = iTypeArray[n2];
            if (allSubTypes.contains(pt)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public IType[] getAllSubtypes(IType type) {
        return this.getAllSubtypes(type, null);
    }

    @Override
    public IType[] getAllSubtypes(IType type, ITypeFilter filter) {
        return this.getAllSubtypes(type, filter, null);
    }

    @Override
    public IType[] getAllSubtypes(IType type, ITypeFilter filter, Comparator<IType> typeComparator) {
        this.revalidate(null);
        IType[] subtypes = this.m_hierarchy.getAllSubtypes(type);
        HashSet<IType> unsortedResult = new HashSet<IType>();
        IType[] iTypeArray = subtypes;
        int n = subtypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType candidate = iTypeArray[n2];
            if (TypeUtility.exists((IJavaElement)candidate) && (filter == null || filter.accept(candidate))) {
                unsortedResult.add(candidate);
            }
            ++n2;
        }
        if (typeComparator != null) {
            TreeSet<IType> sortedResult = new TreeSet<IType>(typeComparator);
            sortedResult.addAll(unsortedResult);
            return sortedResult.toArray(new IType[sortedResult.size()]);
        }
        return unsortedResult.toArray(new IType[unsortedResult.size()]);
    }

    @Override
    public IType[] getAllSuperclasses(IType type) {
        return this.getAllSuperclasses(type, null);
    }

    @Override
    public IType[] getAllSuperclasses(IType type, ITypeFilter filter) {
        return this.getAllSuperclasses(type, filter, null);
    }

    @Override
    public IType[] getAllSuperclasses(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidate(null);
        IType[] types = this.m_hierarchy.getAllSuperclasses(type);
        HashSet<IType> unsortedResult = new HashSet<IType>();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType candidate = iTypeArray[n2];
            if (TypeUtility.exists((IJavaElement)candidate) && (filter == null || filter.accept(candidate))) {
                unsortedResult.add(candidate);
            }
            ++n2;
        }
        if (comparator != null) {
            TreeSet<IType> sortedResult = new TreeSet<IType>(comparator);
            sortedResult.addAll(unsortedResult);
            return sortedResult.toArray(new IType[sortedResult.size()]);
        }
        return unsortedResult.toArray(new IType[unsortedResult.size()]);
    }

    @Override
    public IType[] getAllSuperInterfaces(IType type) {
        return this.getAllSuperInterfaces(type, null);
    }

    @Override
    public IType[] getAllSuperInterfaces(IType type, ITypeFilter filter) {
        return this.getAllSuperInterfaces(type, filter, null);
    }

    @Override
    public IType[] getAllSuperInterfaces(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidate(null);
        IType[] types = this.m_hierarchy.getAllSuperInterfaces(type);
        HashSet<IType> unsortedResult = new HashSet<IType>();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType candidate = iTypeArray[n2];
            if (TypeUtility.exists((IJavaElement)candidate) && (filter == null || filter.accept(candidate))) {
                unsortedResult.add(candidate);
            }
            ++n2;
        }
        if (comparator != null) {
            TreeSet<IType> sortedResult = new TreeSet<IType>(comparator);
            sortedResult.addAll(unsortedResult);
            return sortedResult.toArray(new IType[sortedResult.size()]);
        }
        return unsortedResult.toArray(new IType[unsortedResult.size()]);
    }

    @Override
    public IType[] getAllSupertypes(IType type) {
        return this.getAllSupertypes(type, null);
    }

    @Override
    public IType[] getAllSupertypes(IType type, ITypeFilter filter) {
        return this.getAllSupertypes(type, filter, null);
    }

    @Override
    public IType[] getAllSupertypes(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidate(null);
        IType[] types = this.m_hierarchy.getAllSupertypes(type);
        HashSet<IType> unsortedResult = new HashSet<IType>();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType candidate = iTypeArray[n2];
            if (TypeUtility.exists((IJavaElement)candidate) && (filter == null || filter.accept(candidate))) {
                unsortedResult.add(candidate);
            }
            ++n2;
        }
        if (comparator != null) {
            TreeSet<IType> sortedResult = new TreeSet<IType>(comparator);
            sortedResult.addAll(unsortedResult);
            return sortedResult.toArray(new IType[sortedResult.size()]);
        }
        return unsortedResult.toArray(new IType[unsortedResult.size()]);
    }

    @Override
    public IType[] getAllTypes() {
        return this.getAllTypes(null);
    }

    @Override
    public IType[] getAllTypes(ITypeFilter filter) {
        return this.getAllTypes(filter, null);
    }

    @Override
    public IType[] getAllTypes(ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidate(null);
        IType[] types = this.m_hierarchy.getAllTypes();
        HashSet<IType> unsortedResult = new HashSet<IType>();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType candidate = iTypeArray[n2];
            if (TypeUtility.exists((IJavaElement)candidate) && (filter == null || filter.accept(candidate))) {
                unsortedResult.add(candidate);
            }
            ++n2;
        }
        if (comparator != null) {
            TreeSet<IType> sortedResult = new TreeSet<IType>(comparator);
            sortedResult.addAll(unsortedResult);
            return sortedResult.toArray(new IType[sortedResult.size()]);
        }
        return unsortedResult.toArray(new IType[unsortedResult.size()]);
    }

    @Override
    public IType[] getSubclasses(IType type) {
        return this.getSubclasses(type, null);
    }

    @Override
    public IType[] getSubclasses(IType type, ITypeFilter filter) {
        return this.getSubclasses(type, filter, null);
    }

    @Override
    public IType[] getSubclasses(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidate(null);
        IType[] types = this.m_hierarchy.getSubclasses(type);
        HashSet<IType> unsortedResult = new HashSet<IType>();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType candidate = iTypeArray[n2];
            if (TypeUtility.exists((IJavaElement)candidate) && (filter == null || filter.accept(candidate))) {
                unsortedResult.add(candidate);
            }
            ++n2;
        }
        if (comparator != null) {
            TreeSet<IType> sortedResult = new TreeSet<IType>(comparator);
            sortedResult.addAll(unsortedResult);
            return sortedResult.toArray(new IType[sortedResult.size()]);
        }
        return unsortedResult.toArray(new IType[unsortedResult.size()]);
    }

    @Override
    public IType[] getSubtypes(IType type) {
        return this.getSubtypes(type, null);
    }

    @Override
    public IType[] getSubtypes(IType type, ITypeFilter filter) {
        return this.getSubtypes(type, filter, null);
    }

    @Override
    public IType[] getSubtypes(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidate(null);
        IType[] types = this.m_hierarchy.getSubtypes(type);
        HashSet<IType> unsortedResult = new HashSet<IType>();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType candidate = iTypeArray[n2];
            if (TypeUtility.exists((IJavaElement)candidate) && (filter == null || filter.accept(candidate))) {
                unsortedResult.add(candidate);
            }
            ++n2;
        }
        if (comparator != null) {
            TreeSet<IType> sortedResult = new TreeSet<IType>(comparator);
            sortedResult.addAll(unsortedResult);
            return sortedResult.toArray(new IType[sortedResult.size()]);
        }
        return unsortedResult.toArray(new IType[unsortedResult.size()]);
    }

    @Override
    public IType getSuperclass(IType type) {
        this.revalidate(null);
        IType superclass = this.m_hierarchy.getSuperclass(type);
        if (!TypeUtility.exists((IJavaElement)superclass)) {
            superclass = null;
        }
        return superclass;
    }

    @Override
    public IType[] getSuperInterfaces(IType type) {
        return this.getSuperInterfaces(type, null);
    }

    @Override
    public IType[] getSuperInterfaces(IType type, ITypeFilter filter) {
        return this.getSuperInterfaces(type, filter, null);
    }

    @Override
    public IType[] getSuperInterfaces(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidate(null);
        IType[] types = this.m_hierarchy.getSuperInterfaces(type);
        HashSet<IType> unsortedResult = new HashSet<IType>();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType candidate = iTypeArray[n2];
            if (TypeUtility.exists((IJavaElement)candidate) && (filter == null || filter.accept(candidate))) {
                unsortedResult.add(candidate);
            }
            ++n2;
        }
        if (comparator != null) {
            TreeSet<IType> sortedResult = new TreeSet<IType>(comparator);
            sortedResult.addAll(unsortedResult);
            return sortedResult.toArray(new IType[sortedResult.size()]);
        }
        return unsortedResult.toArray(new IType[unsortedResult.size()]);
    }

    @Override
    public IType[] getSupertypes(IType type) {
        return this.getSupertypes(type, null);
    }

    @Override
    public IType[] getSupertypes(IType type, ITypeFilter filter) {
        return this.getSupertypes(type, filter, null);
    }

    @Override
    public IType[] getSupertypes(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidate(null);
        IType[] types = this.m_hierarchy.getSupertypes(type);
        HashSet<IType> unsortedResult = new HashSet<IType>();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType candidate = iTypeArray[n2];
            if (TypeUtility.exists((IJavaElement)candidate) && (filter == null || filter.accept(candidate))) {
                unsortedResult.add(candidate);
            }
            ++n2;
        }
        if (comparator != null) {
            TreeSet<IType> sortedResult = new TreeSet<IType>(comparator);
            sortedResult.addAll(unsortedResult);
            return sortedResult.toArray(new IType[sortedResult.size()]);
        }
        return unsortedResult.toArray(new IType[unsortedResult.size()]);
    }
}

