/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.resources;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.util.resources.IResourceFilter;
import org.eclipse.scout.sdk.util.resources.ResourceUtility;

public class ResourceFilters {
    public static IResourceFilter getMultifilterAnd(final IResourceFilter ... filters) {
        return new IResourceFilter(){

            @Override
            public boolean accept(IResource candidate) {
                if (filters == null) {
                    return true;
                }
                IResourceFilter[] iResourceFilterArray = filters;
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceFilter f = iResourceFilterArray[n2];
                    if (!f.accept(candidate)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        };
    }

    public static IResourceFilter getMultifilterOr(final IResourceFilter ... filters) {
        return new IResourceFilter(){

            @Override
            public boolean accept(IResource candidate) {
                if (filters == null) {
                    return true;
                }
                IResourceFilter[] iResourceFilterArray = filters;
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceFilter f = iResourceFilterArray[n2];
                    if (f.accept(candidate)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        };
    }

    public static IResourceFilter getProductFilter() {
        return new IResourceFilter(){

            @Override
            public boolean accept(IResource resource) {
                return ResourceUtility.exists(resource) && resource.getType() == 1 && StringUtility.equalsIgnoreCase((String)((IFile)resource).getFileExtension(), (String)"product");
            }
        };
    }
}

