/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.resources;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.scout.sdk.util.resources.IResourceFilter;

public final class ResourceUtility {
    private ResourceUtility() {
    }

    public static IResource[] getAllResources(IResourceFilter filter) throws CoreException {
        return ResourceUtility.getAllResources((IResource)ResourcesPlugin.getWorkspace().getRoot(), filter);
    }

    public static IResource[] getAllResources(IResource startResource, IResourceFilter filter) throws CoreException {
        LinkedList<IResource> collector = new LinkedList<IResource>();
        ResourceUtility.collectResourcesRec(startResource, collector, filter);
        return collector.toArray(new IResource[collector.size()]);
    }

    private static void collectResourcesRec(IResource resource, Collection<IResource> collector, IResourceFilter filter) throws CoreException {
        if (ResourceUtility.exists(resource)) {
            if (filter.accept(resource)) {
                collector.add(resource);
            }
            if (resource instanceof IContainer) {
                IResource[] iResourceArray = ((IContainer)resource).members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource child = iResourceArray[n2];
                    ResourceUtility.collectResourcesRec(child, collector, filter);
                    ++n2;
                }
            }
        }
    }

    public static boolean exists(IResource resource) {
        return resource != null && resource.exists();
    }
}

