/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.jdt;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.osgi.framework.Bundle;

public final class JdtUtility {
    private JdtUtility() {
    }

    public static IJavaElement findJavaElement(IFile javaFile, ITextSelection selection) throws JavaModelException {
        IJavaElement javaElement = JavaCore.create((IFile)javaFile);
        javaElement = JdtUtility.findJavaElement(javaElement, selection.getOffset(), selection.getLength());
        return javaElement;
    }

    public static boolean hasAnnotation(IAnnotatable element, String fullyQuallifiedAnnotation) {
        return TypeUtility.exists((IJavaElement)JdtUtility.getAnnotation(element, fullyQuallifiedAnnotation));
    }

    public static Double getNumericAnnotationValue(IAnnotation annotation, String name) throws JavaModelException {
        if (TypeUtility.exists((IJavaElement)annotation)) {
            IMemberValuePair[] memberValues;
            IMemberValuePair[] iMemberValuePairArray = memberValues = annotation.getMemberValuePairs();
            int n = memberValues.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair p = iMemberValuePairArray[n2];
                if (name.equals(p.getMemberName())) {
                    switch (p.getValueKind()) {
                        case 6: {
                            return (double)((Double)p.getValue());
                        }
                        case 5: {
                            return ((Float)p.getValue()).doubleValue();
                        }
                        case 1: {
                            return ((Integer)p.getValue()).doubleValue();
                        }
                    }
                    break;
                }
                ++n2;
            }
        }
        return null;
    }

    public static IAnnotation getAnnotation(IAnnotatable element, String fullyQuallifiedAnnotation) {
        try {
            IAnnotation annotation = element.getAnnotation(fullyQuallifiedAnnotation);
            if (TypeUtility.exists((IJavaElement)annotation) && (annotation.getSource() == null || annotation.getSource().startsWith("@"))) {
                return annotation;
            }
            String simpleName = Signature.getSimpleName((String)fullyQuallifiedAnnotation);
            annotation = element.getAnnotation(simpleName);
            if (TypeUtility.exists((IJavaElement)annotation) && (annotation.getSource() == null || annotation.getSource().startsWith("@"))) {
                return annotation;
            }
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logError("could not get annotation '" + fullyQuallifiedAnnotation + "' of '" + element + "'", e);
        }
        return null;
    }

    public static String escapeStringJava(String s) {
        if (s == null) {
            return null;
        }
        return s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "");
    }

    public static String toStringLiteral(String s) {
        return "\"" + JdtUtility.escapeStringJava(s) + "\"";
    }

    public static IJavaElement findJavaElement(IJavaElement element, int offset, int lenght) throws JavaModelException {
        switch (element.getElementType()) {
            case 5: {
                IType[] icuTypes;
                ICompilationUnit icu = (ICompilationUnit)element;
                IType[] iTypeArray = icuTypes = icu.getTypes();
                int n = icuTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IType t = iTypeArray[n2];
                    if (t.getSourceRange().getOffset() < offset && t.getSourceRange().getOffset() + t.getSourceRange().getLength() > offset + lenght) {
                        return JdtUtility.findJavaElement((IJavaElement)t, offset, lenght);
                    }
                    ++n2;
                }
                if (icuTypes.length <= 0) break;
                return icuTypes[0];
            }
            case 7: {
                IType[] iTypeArray = ((IType)element).getTypes();
                int n = iTypeArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IType t = iTypeArray[n3];
                    if (t.getSourceRange().getOffset() < offset && t.getSourceRange().getOffset() + t.getSourceRange().getLength() > offset + lenght) {
                        return JdtUtility.findJavaElement((IJavaElement)t, offset, lenght);
                    }
                    ++n3;
                }
                iTypeArray = ((IType)element).getMethods();
                n = iTypeArray.length;
                n3 = 0;
                while (n3 < n) {
                    IType m = iTypeArray[n3];
                    if (m.getSourceRange().getOffset() < offset && m.getSourceRange().getOffset() + m.getSourceRange().getLength() > offset + lenght) {
                        return JdtUtility.findJavaElement((IJavaElement)m, offset, lenght);
                    }
                    ++n3;
                }
                break;
            }
        }
        return element;
    }

    public static IType findDeclaringType(IJavaElement element) {
        if (element == null) {
            return null;
        }
        if (element.getElementType() == 7) {
            return (IType)element;
        }
        return JdtUtility.findDeclaringType(element.getParent());
    }

    public static void waitForSilentWorkspace() {
        Job worker = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                return Status.OK_STATUS;
            }
        };
        worker.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        worker.schedule();
        try {
            worker.join();
        }
        catch (InterruptedException interruptedException) {}
        JdtUtility.waitForRefresh();
        JdtUtility.waitForBuild();
        JdtUtility.waitForIndexesReady();
    }

    public static void waitForBuild() {
        JdtUtility.waitForJobFamily(ResourcesPlugin.FAMILY_MANUAL_BUILD);
        JdtUtility.waitForJobFamily(ResourcesPlugin.FAMILY_AUTO_BUILD);
    }

    public static void waitForRefresh() {
        JdtUtility.waitForJobFamily(ResourcesPlugin.FAMILY_AUTO_REFRESH);
        JdtUtility.waitForJobFamily(ResourcesPlugin.FAMILY_MANUAL_REFRESH);
    }

    public static void waitForIndexesReady() {
        SearchEngine engine = new SearchEngine();
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        try {
            engine.searchAllTypeNames(null, 0, "!@$#!@".toCharArray(), 10, 5, scope, new TypeNameRequestor(){

                public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                }
            }, 3, null);
        }
        catch (CoreException coreException) {}
    }

    public static void waitForManualRefresh() {
        JdtUtility.waitForJobFamily(ResourcesPlugin.FAMILY_MANUAL_REFRESH);
    }

    public static void waitForJobFamily(Object family) {
        boolean wasInterrupted = false;
        do {
            try {
                Job.getJobManager().join(family, null);
                wasInterrupted = false;
            }
            catch (OperationCanceledException e) {
                e.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                wasInterrupted = true;
            }
        } while (wasInterrupted);
    }

    public static boolean areAllPluginsInstalled(String ... pluginIds) {
        String[] stringArray = pluginIds;
        int n = pluginIds.length;
        int n2 = 0;
        while (n2 < n) {
            String pluginId = stringArray[n2];
            Bundle b = Platform.getBundle((String)pluginId);
            if (b == null) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

