/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.signature;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.signature.IImportValidator;

public class CompilationUnitImportValidator
implements IImportValidator {
    private final ICompilationUnit m_icu;
    private final Map<String, String> m_icuImports;
    private HashMap<String, String> m_newImports;

    public CompilationUnitImportValidator(ICompilationUnit icu) {
        this.m_icu = icu;
        HashMap<String, String> usedImps = new HashMap<String, String>();
        try {
            IImportDeclaration[] iImportDeclarationArray = this.m_icu.getImports();
            int n = iImportDeclarationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IImportDeclaration imp = iImportDeclarationArray[n2];
                String fqImp = imp.getElementName();
                String packageName = Signature.getQualifier((String)fqImp);
                String simpleName = Signature.getSimpleName((String)fqImp);
                usedImps.put(simpleName, packageName);
                ++n2;
            }
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logWarning("could not collect imports of compilation unit '" + icu.getElementName() + "'!", e);
        }
        this.m_icuImports = Collections.unmodifiableMap(usedImps);
        this.m_newImports = new HashMap();
    }

    @Override
    public void addImport(String fqn) {
        String packageName = Signature.getQualifier((String)fqn);
        String simpleName = Signature.getSimpleName((String)fqn);
        this.m_newImports.put(simpleName, packageName);
    }

    private String findUsedPackageName(String simpleName) {
        if (this.m_icuImports.containsKey(simpleName)) {
            return this.m_icuImports.get(simpleName);
        }
        return this.m_newImports.get(simpleName);
    }

    @Override
    public String getTypeName(String singleTypeSignature) {
        String prefix = "";
        if (singleTypeSignature.matches("^\\+.*$")) {
            prefix = "? extends ";
            singleTypeSignature = singleTypeSignature.replaceAll("^\\+", "");
        }
        String pckName = Signature.getSignatureQualifier((String)singleTypeSignature);
        String simpleName = Signature.getSignatureSimpleName((String)singleTypeSignature);
        String plainSimpleName = Signature.getSignatureSimpleName((String)singleTypeSignature.replaceAll("^[\\[\\+]*", ""));
        if (!StringUtility.isNullOrEmpty((String)pckName)) {
            String usedPackageName = this.findUsedPackageName(plainSimpleName);
            if (usedPackageName != null) {
                if (!usedPackageName.equals(pckName)) {
                    return String.valueOf(prefix) + pckName + "." + simpleName;
                }
                return String.valueOf(prefix) + simpleName;
            }
            this.m_newImports.put(plainSimpleName, pckName);
            return String.valueOf(prefix) + simpleName;
        }
        return simpleName;
    }

    @Override
    public String[] getImportsToCreate() {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, String> e : this.m_newImports.entrySet()) {
            if (e.getValue().equals("java.lang")) continue;
            list.add(String.valueOf(e.getValue()) + "." + e.getKey());
        }
        return list.toArray(new String[list.size()]);
    }
}

