/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.type;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;

public class TypeFilters {
    public static ITypeFilter invertFilter(final ITypeFilter filter) {
        return new ITypeFilter(){

            @Override
            public boolean accept(IType type) {
                return !filter.accept(type);
            }
        };
    }

    public static ITypeFilter getSubtypeFilter(final IType type) {
        return new ITypeFilter(){

            @Override
            public boolean accept(IType candidate) {
                try {
                    org.eclipse.jdt.core.ITypeHierarchy hierarchy = candidate.newSupertypeHierarchy(null);
                    return hierarchy.contains(type);
                }
                catch (JavaModelException e) {
                    SdkUtilActivator.logWarning("could not create super hierarchy of '" + candidate.getElementName() + "'.", e);
                    return false;
                }
            }
        };
    }

    public static ITypeFilter getSubtypeFilter(final IType type, final ITypeHierarchy hierarchy) {
        return new ITypeFilter(){

            @Override
            public boolean accept(IType candidate) {
                return hierarchy.isSubtype(type, candidate);
            }
        };
    }

    public static ITypeFilter getElementNameFilter(final String typeName) {
        return new ITypeFilter(){

            @Override
            public boolean accept(IType type) {
                return type.getElementName().equals(typeName);
            }
        };
    }

    public static ITypeFilter getRegexSimpleNameFilter(final String regex) {
        return new ITypeFilter(){

            @Override
            public boolean accept(IType type) {
                return type.getElementName().matches(regex);
            }
        };
    }

    public static ITypeFilter getCompilationUnitFilter(final ICompilationUnit icu) {
        return new ITypeFilter(){

            @Override
            public boolean accept(IType type) {
                if (!type.isBinary()) {
                    return icu.equals(type.getCompilationUnit());
                }
                return false;
            }
        };
    }

    public static ITypeFilter getInnterTypeFilter(final IType type) {
        return new ITypeFilter(){

            @Override
            public boolean accept(IType t) {
                if (t != null) {
                    if (t.equals(type)) {
                        return true;
                    }
                    return this.accept(t.getDeclaringType());
                }
                return false;
            }
        };
    }

    public static ITypeFilter getPackageFilter(final IPackageFragment packageFragment) {
        return new ITypeFilter(){

            @Override
            public boolean accept(IType type) {
                return type.getPackageFragment().equals(packageFragment);
            }
        };
    }

    public static ITypeFilter getTypesInProjects(IJavaProject[] projects) {
        final HashSet<IJavaProject> finalProjects = new HashSet<IJavaProject>(Arrays.asList(projects));
        return new ITypeFilter(){

            @Override
            public boolean accept(IType candidate) {
                if (!TypeUtility.exists((IJavaElement)candidate) || candidate.isBinary()) {
                    return false;
                }
                return finalProjects.contains(candidate.getJavaProject()) && TypeFilters.isClass(candidate);
            }
        };
    }

    public static ITypeFilter getClassesInProject(final IJavaProject project) {
        return new ITypeFilter(){

            @Override
            public boolean accept(IType candidate) {
                if (candidate == null || !candidate.exists() || candidate.isBinary()) {
                    return false;
                }
                return candidate.getJavaProject().equals(project) && TypeFilters.isClass(candidate);
            }
        };
    }

    public static ITypeFilter getTypesOnClasspath(final IJavaProject project) {
        return new ITypeFilter(){

            @Override
            public boolean accept(IType candidate) {
                if (!TypeUtility.exists((IJavaElement)candidate)) {
                    return false;
                }
                return TypeUtility.isOnClasspath((IMember)candidate, project);
            }
        };
    }

    public static ITypeFilter getInWorkspaceFilter() {
        return new ITypeFilter(){

            @Override
            public boolean accept(IType type) {
                return !type.isBinary() && !type.isReadOnly();
            }
        };
    }

    public static ITypeFilter getToplevelTypeFilter() {
        return new ITypeFilter(){

            @Override
            public boolean accept(IType type) {
                return TypeUtility.exists((IJavaElement)type) && !TypeUtility.exists((IJavaElement)type.getDeclaringType());
            }
        };
    }

    public static ITypeFilter getInnerClasses(final IType declaringType) {
        return new ITypeFilter(){

            @Override
            public boolean accept(IType candidate) {
                if (candidate == null || !candidate.exists() || candidate.isBinary()) {
                    return false;
                }
                IType candidateDeclaringType = candidate.getDeclaringType();
                return candidateDeclaringType != null && candidateDeclaringType.equals(declaringType) && TypeFilters.isClass(candidate);
            }
        };
    }

    public static ITypeFilter getInHierarchyFilter(final ITypeHierarchy hierarchy) {
        return new ITypeFilter(){

            @Override
            public boolean accept(IType type) {
                return hierarchy.contains(type);
            }
        };
    }

    public static ITypeFilter getAbstractOnClasspath(final IJavaProject project) {
        return new ITypeFilter(){

            @Override
            public boolean accept(IType type) {
                try {
                    int flags = type.getFlags();
                    return !Flags.isInterface((int)flags) && Flags.isAbstract((int)flags) && !Flags.isDeprecated((int)flags) && TypeUtility.isOnClasspath((IMember)type, project);
                }
                catch (JavaModelException e) {
                    SdkUtilActivator.logError("could not filter type '" + type.getFullyQualifiedName() + "'.", e);
                    return false;
                }
            }
        };
    }

    public static ITypeFilter getFlagsFilter(final int flags) {
        return new ITypeFilter(){

            @Override
            public boolean accept(IType type) {
                try {
                    int typeFlags = type.getFlags();
                    return (typeFlags & flags) == flags;
                }
                catch (JavaModelException e) {
                    SdkUtilActivator.logError("could not filter type '" + type.getFullyQualifiedName() + "'.", e);
                    return false;
                }
            }
        };
    }

    public static ITypeFilter getClassFilter() {
        return new ITypeFilter(){

            @Override
            public boolean accept(IType candidate) {
                return TypeFilters.isClass(candidate);
            }
        };
    }

    public static ITypeFilter getExistingFilter() {
        return new ITypeFilter(){

            @Override
            public boolean accept(IType type) {
                return type != null && type.exists();
            }
        };
    }

    public static ITypeFilter getNotInTypes(IType ... excludedTypes) {
        HashSet<IType> excludedSet = new HashSet<IType>();
        if (excludedTypes != null) {
            excludedSet.addAll(Arrays.asList(excludedTypes));
        }
        return TypeFilters.getNotInTypes(excludedSet);
    }

    public static ITypeFilter getNotInTypes(final Set<IType> excludedTypes) {
        return new ITypeFilter(){

            @Override
            public boolean accept(IType type) {
                if (excludedTypes == null) {
                    return true;
                }
                return !excludedTypes.contains(type);
            }
        };
    }

    public static ITypeFilter getInterfaceFilter() {
        return new ITypeFilter(){

            @Override
            public boolean accept(IType candidate) {
                try {
                    int flags = candidate.getFlags();
                    return Flags.isInterface((int)flags) && !Flags.isDeprecated((int)flags);
                }
                catch (JavaModelException e) {
                    SdkUtilActivator.logWarning("could not evalutate flags of type '" + candidate.getFullyQualifiedName() + "'.", e);
                    return false;
                }
            }
        };
    }

    protected static boolean isClass(IType type) {
        try {
            int flags = type.getFlags();
            return !Flags.isAbstract((int)flags) && !Flags.isInterface((int)flags) && !Flags.isDeprecated((int)flags);
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logWarning("could not evalutate flags of type '" + type.getFullyQualifiedName() + "'.", e);
            return false;
        }
    }

    public static ITypeFilter getMultiTypeFilterOr(final ITypeFilter ... filters) {
        return new ITypeFilter(){

            @Override
            public boolean accept(IType candidate) {
                if (filters == null) {
                    return true;
                }
                ITypeFilter[] iTypeFilterArray = filters;
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeFilter f = iTypeFilterArray[n2];
                    if (f.accept(candidate)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        };
    }

    public static ITypeFilter getMultiTypeFilter(final ITypeFilter ... filters) {
        return new ITypeFilter(){

            @Override
            public boolean accept(IType candidate) {
                if (filters == null) {
                    return true;
                }
                ITypeFilter[] iTypeFilterArray = filters;
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeFilter f = iTypeFilterArray[n2];
                    if (!f.accept(candidate)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        };
    }
}

