/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.ui.internal.ImageRegistry;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.log.SdkLogManager;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsIcons;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.IMarkerCommand;
import org.eclipse.scout.sdk.ws.jaxws.util.listener.IPageReloadNotification;
import org.eclipse.scout.sdk.ws.jaxws.worker.MarkerQueueManager;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class JaxWsSdk
extends AbstractUIPlugin
implements JaxWsIcons {
    public static final String PLUGIN_ID = "org.eclipse.scout.sdk.ws.jaxws";
    private static final String IMAGE_PATH = "resources/icons/";
    private static JaxWsSdk m_plugin;
    private static SdkLogManager logManager;
    private Map<String, IMarkerCommand> m_markerCommands = new ConcurrentHashMap<String, IMarkerCommand>();
    private MarkerQueueManager m_markerQueueManager;
    private Object m_pageRegistryLock;
    private Map<Class<? extends IPage>, Set<IPageReloadNotification>> m_pageRegistry = new HashMap<Class<? extends IPage>, Set<IPageReloadNotification>>();

    public JaxWsSdk() {
        this.m_pageRegistryLock = new Object();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        m_plugin = this;
        logManager = new SdkLogManager((Plugin)this);
        this.m_markerQueueManager = new MarkerQueueManager();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.m_markerQueueManager != null) {
            this.m_markerQueueManager.cancelWorker();
            this.m_markerQueueManager = null;
        }
        logManager = null;
        super.stop(context);
    }

    public static JaxWsSdk getDefault() {
        return m_plugin;
    }

    public static void logInfo(Throwable t) {
        logManager.logInfo(t);
    }

    public static void logInfo(String message) {
        logManager.logInfo(message);
    }

    public static void logInfo(String message, Throwable t) {
        logManager.logInfo(message, t);
    }

    public static void logWarning(String message) {
        logManager.logWarning(message);
    }

    public static void logWarning(Throwable t) {
        logManager.logWarning(t);
    }

    public static void logWarning(String message, Throwable t) {
        logManager.logWarning(message, t);
    }

    public static void logError(Throwable t) {
        logManager.logError(t);
    }

    public static void logError(String message) {
        logManager.logError(message);
    }

    public static void logError(String message, Throwable t) {
        logManager.logError(message, t);
    }

    public IMarkerCommand getMarkerCommand(String markerSourceId) {
        return this.m_markerCommands.get(markerSourceId);
    }

    public IMarkerCommand addMarkerCommand(String markerSourceId, IMarkerCommand markerCommand) {
        return this.m_markerCommands.put(markerSourceId, markerCommand);
    }

    public void removeMarkerCommand(String markerSourceId) {
        this.m_markerCommands.remove(markerSourceId);
    }

    public void removeMarkerCommands(String markerGroupUUID) {
        for (String markerSourceId : this.m_markerCommands.keySet()) {
            if (!markerSourceId.startsWith(markerGroupUUID)) continue;
            this.m_markerCommands.remove(markerSourceId);
        }
    }

    public boolean containsMarkerCommands(String markerGroupUUID) {
        Set<String> markerSourceIds = this.m_markerCommands.keySet();
        for (String markerSourceId : markerSourceIds) {
            if (!markerSourceId.startsWith(markerGroupUUID)) continue;
            return true;
        }
        return false;
    }

    public MarkerQueueManager getMarkerQueueManager() {
        return this.m_markerQueueManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPageReload(Class<? extends IPage> pageClazz, final String markerGroupUUID, final int dataMask) {
        IPageReloadNotification[] pages;
        Object object = this.m_pageRegistryLock;
        synchronized (object) {
            Set<IPageReloadNotification> pageSet = this.m_pageRegistry.get(pageClazz);
            if (pageSet == null || pageSet.size() == 0) {
                return;
            }
            pages = pageSet.toArray(new IPageReloadNotification[pageSet.size()]);
        }
        Job job = new Job("Reload page content"){

            protected IStatus run(IProgressMonitor monitor) {
                IPageReloadNotification[] iPageReloadNotificationArray = pages;
                int n = pages.length;
                int n2 = 0;
                while (n2 < n) {
                    IPageReloadNotification page = iPageReloadNotificationArray[n2];
                    try {
                        if (CompareUtility.equals((Object)markerGroupUUID, (Object)page.getMarkerGroupUUID())) {
                            page.reloadPage(dataMask);
                        }
                    }
                    catch (Exception e) {
                        JaxWsSdk.logError("failed to notify listener", e);
                    }
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPage(Class<? extends IPage> pageClazz, IPageReloadNotification page) {
        Object object = this.m_pageRegistryLock;
        synchronized (object) {
            Set<IPageReloadNotification> pages = this.m_pageRegistry.get(pageClazz);
            if (pages == null) {
                pages = new HashSet<IPageReloadNotification>();
                this.m_pageRegistry.put(pageClazz, pages);
            }
            pages.add(page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPage(Class<? extends IPage> pageClazz, IPageReloadNotification page) {
        Object object = this.m_pageRegistryLock;
        synchronized (object) {
            Set<IPageReloadNotification> pages = this.m_pageRegistry.get(pageClazz);
            if (pages == null) {
                return;
            }
            pages.remove(page);
        }
    }

    protected ImageRegistry createImageRegistry() {
        if (Display.getCurrent() != null) {
            return new ImageRegistry(Display.getCurrent());
        }
        if (PlatformUI.isWorkbenchRunning()) {
            return new ImageRegistry(PlatformUI.getWorkbench().getDisplay());
        }
        throw new SWTError(22);
    }

    protected void initializeImageRegistry(org.eclipse.jface.resource.ImageRegistry reg) {
    }

    public ImageRegistry getImageRegistry() {
        return (ImageRegistry)super.getImageRegistry();
    }

    public static Image getImage(CompositeImageDescriptor imageDescriptor) {
        return JaxWsSdk.getDefault().getImageImpl(imageDescriptor);
    }

    private Image getImageImpl(CompositeImageDescriptor imageDescriptor) {
        return this.getImageRegistry().get((ImageDescriptor)imageDescriptor);
    }

    public static Image getImage(String name) {
        return JaxWsSdk.getDefault().getImageImpl(name);
    }

    private Image getImageImpl(String name) {
        Image image = this.getImageRegistry().get(name);
        if (image == null) {
            this.loadImage(name);
            image = this.getImageRegistry().get(name);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        return JaxWsSdk.getDefault().getImageDescriptorImpl(name);
    }

    private ImageDescriptor getImageDescriptorImpl(String name) {
        ImageDescriptor imageDesc = this.getImageRegistry().getDescriptor(name);
        if (imageDesc == null) {
            this.loadImage(name);
            imageDesc = this.getImageRegistry().getDescriptor(name);
        }
        return imageDesc;
    }

    private void loadImage(String name) {
        ImageDescriptor desc = null;
        desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)(IMAGE_PATH + name));
        if (desc == null) {
            desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)(IMAGE_PATH + name + ".gif"));
        }
        if (desc == null) {
            desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)(IMAGE_PATH + name + ".png"));
        }
        if (desc == null) {
            desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)(IMAGE_PATH + name + ".jpg"));
        }
        if (desc == null) {
            JaxWsSdk.logWarning("could not find image for plugin: 'org.eclipse.scout.sdk.ws.jaxws' under: 'resources/icons/" + name + "'.");
        } else {
            this.getImageRegistry().put(name, desc);
        }
    }
}

