/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.marker.commands;

import javax.jws.WebService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.AbstractExecutableMarkerCommand;
import org.eclipse.scout.sdk.ws.jaxws.operation.AnnotationUpdateOperation;
import org.eclipse.scout.sdk.ws.jaxws.swt.dialog.TypeBrowseDialog;

public class MissingEndpointCodeFirstCommand
extends AbstractExecutableMarkerCommand {
    private IType m_implType;
    private IType m_annotationType;
    private String m_property;
    private IType m_portTypeInterfaceType;

    public MissingEndpointCodeFirstCommand(IType implType) {
        super("Missing or invalid " + WebService.class.getSimpleName() + " annotation declaration");
        this.m_implType = implType;
        this.m_annotationType = TypeUtility.getType((String)WebService.class.getName());
        this.m_property = "endpointInterface";
        this.setSolutionDescription("By using this task, the annotation declaration is updated.");
    }

    @Override
    public boolean prepareForUi() throws CoreException {
        TypeBrowseDialog dialog = new TypeBrowseDialog(ScoutSdkUi.getShell(), Texts.get("PortTypeInterface"), Texts.get("PleaseChoosePortTypeInterface1"));
        dialog.setTypeStyle(4);
        if (dialog.open() == 0) {
            this.m_portTypeInterfaceType = dialog.getType();
            return true;
        }
        return false;
    }

    @Override
    public void execute(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        AnnotationUpdateOperation op = new AnnotationUpdateOperation();
        op.setDeclaringType(this.m_implType);
        op.setAnnotationType(this.m_annotationType);
        op.addStringProperty(this.m_property, this.m_portTypeInterfaceType.getFullyQualifiedName());
        new OperationJob(new IOperation[]{op}).schedule();
    }

    public IType getPortTypeInterfaceType() {
        return this.m_portTypeInterfaceType;
    }
}

