/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.operation;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.commons.xmlparser.ScoutXmlDocument;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.ElementBean;

public class WsProviderCodeFirstDeleteOperation
implements IOperation {
    public static final int ID_REGISTRATION = 1;
    public static final int ID_IMPL_TYPE = 2;
    private IScoutBundle m_bundle;
    private SunJaxWsBean m_sunJaxWsBean;
    private List<ElementBean> m_elements;

    public void validate() throws IllegalArgumentException {
        if (this.m_bundle == null) {
            throw new IllegalArgumentException("No bundle set");
        }
        if (this.m_sunJaxWsBean == null) {
            throw new IllegalArgumentException("No sunJaxWsBean set");
        }
        if (this.m_elements == null) {
            throw new IllegalArgumentException("No elements set");
        }
    }

    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        for (ElementBean element : this.m_elements) {
            switch (element.getId()) {
                case 1: {
                    this.deleteSunJaxWsXmlEntry(monitor);
                    break;
                }
                case 2: {
                    this.deleteType((IType)element.getJavaElement(), monitor);
                }
            }
        }
    }

    private void deleteSunJaxWsXmlEntry(IProgressMonitor monitor) throws CoreException {
        String alias = this.m_sunJaxWsBean.getAlias();
        ScoutXmlDocument xmlDocument = this.m_sunJaxWsBean.getXml().getDocument();
        xmlDocument.getRoot().removeChild(this.m_sunJaxWsBean.getXml());
        ResourceFactory.getSunJaxWsResource(this.m_bundle).storeXml(xmlDocument, 8, monitor, alias);
    }

    private void deleteType(IType type, IProgressMonitor monitor) throws JavaModelException {
        try {
            type.getCompilationUnit().delete(true, monitor);
        }
        catch (Exception e) {
            JaxWsSdk.logError("could not delete type", e);
        }
    }

    public String getOperationName() {
        return WsProviderCodeFirstDeleteOperation.class.getName();
    }

    public IScoutBundle getBundle() {
        return this.m_bundle;
    }

    public void setBundle(IScoutBundle bundle) {
        this.m_bundle = bundle;
    }

    public SunJaxWsBean getSunJaxWsBean() {
        return this.m_sunJaxWsBean;
    }

    public void setSunJaxWsBean(SunJaxWsBean sunJaxWsBean) {
        this.m_sunJaxWsBean = sunJaxWsBean;
    }

    public List<ElementBean> getElements() {
        return this.m_elements;
    }

    public void setElements(List<ElementBean> elements) {
        this.m_elements = elements;
    }
}

