/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.operation;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.core.LaunchConfiguration;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.util.log.ScoutStatus;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.listener.IOperationFinishedListener;

public class WsStubGenerationOperation
implements IOperation {
    private IScoutBundle m_bundle;
    private String m_alias;
    private String m_wsdlFileName;
    private Map<String, List<String>> m_properties;
    private String m_packageName;
    private IFolder m_wsdlFolder;
    private Set<IOperationFinishedListener> m_operationFinishedListeners = new HashSet<IOperationFinishedListener>();

    public void addOperationFinishedListener(IOperationFinishedListener listener) {
        this.m_operationFinishedListeners.add(listener);
    }

    public void removeOperationFinishedListener(IOperationFinishedListener listener) {
        this.m_operationFinishedListeners.remove(listener);
    }

    public void validate() throws IllegalArgumentException {
        if (this.m_bundle == null) {
            throw new IllegalArgumentException("bundle not set");
        }
        if (this.m_alias == null) {
            throw new IllegalArgumentException("alias not set");
        }
        if (this.m_wsdlFolder == null || !this.m_wsdlFolder.exists()) {
            throw new IllegalArgumentException("wsdl folder not set");
        }
        if (this.m_wsdlFileName == null) {
            throw new IllegalArgumentException("wsdlFileName not set");
        }
    }

    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        JaxWsSdk.getDefault().getMarkerQueueManager().suspend();
        try {
            Throwable exception;
            String jarFilePath;
            IFile jarFile;
            block23: {
                JaxWsSdkUtility.getFolder(this.m_bundle, "ws-stub", true);
                String launcherName = String.valueOf(this.m_alias) + " (JAX-WS stub generation)";
                JaxWsSdkUtility.prepareFolderAccess(this.getWsdlFolder(), true);
                jarFile = JaxWsSdkUtility.getStubJarFile(this.m_bundle, this.m_properties, this.m_wsdlFileName);
                if (jarFile.exists()) {
                    try {
                        jarFile.delete(true, monitor);
                        JaxWsSdkUtility.registerJarLib(this.m_bundle, jarFile, true, monitor);
                    }
                    catch (Exception e) {
                        JaxWsSdk.logError("failed to delete jar file", e);
                        this.notifyListeners(false, new Exception("Failed to delete stub JAR-file '" + jarFile.getProjectRelativePath().toPortableString() + "'. The file might be locked because the server is running.", e));
                        JaxWsSdk.getDefault().getMarkerQueueManager().resume();
                        return;
                    }
                }
                String args = null;
                jarFilePath = JaxWsSdkUtility.normalizePath(jarFile.getProjectRelativePath().toPortableString(), JaxWsSdkUtility.SeparatorType.None);
                args = StringUtility.join((String)"\n", (String[])new String[]{args, jarFilePath});
                args = StringUtility.join((String)"\n", (String[])new String[]{args, this.getWsdlFolder().getProjectRelativePath().append(this.m_wsdlFileName).toPortableString()});
                args = StringUtility.join((String)"\n", (String[])new String[]{args, "1"});
                if (this.m_properties != null && this.m_properties.size() > 0) {
                    for (Map.Entry<String, List<String>> property : this.m_properties.entrySet()) {
                        String propName = property.getKey();
                        if (!StringUtility.hasText((String)propName) || propName.equals("jar")) continue;
                        List<String> propValues = property.getValue();
                        if (propValues == null || propValues.size() == 0) {
                            String directive = propName;
                            args = StringUtility.join((String)"\n", (String[])new String[]{args, directive});
                            continue;
                        }
                        for (String value : propValues) {
                            if (propName.equals("b") && StringUtility.hasText((String)value) && value.matches(".*\\s.*") && !value.startsWith("\\")) {
                                value = "\"" + value + "\"";
                            }
                            String directive = StringUtility.join((String)"=", (String[])new String[]{propName, value});
                            args = StringUtility.join((String)"\n", (String[])new String[]{args, directive});
                        }
                    }
                }
                exception = null;
                try {
                    try {
                        this.launchJavaApplicationSync(launcherName, this.m_bundle.getProject().getName(), TypeUtility.getType((String)"org.eclipse.scout.jaxws.tool.JaxWsStubGenerator").getFullyQualifiedName(), args, monitor);
                    }
                    catch (Throwable e) {
                        exception = e;
                        JaxWsSdkUtility.refreshLocal((IResource)JaxWsSdkUtility.getFolder(this.m_bundle, "ws-stub", false), 2);
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    JaxWsSdkUtility.refreshLocal((IResource)JaxWsSdkUtility.getFolder(this.m_bundle, "ws-stub", false), 2);
                    throw throwable;
                }
                JaxWsSdkUtility.refreshLocal((IResource)JaxWsSdkUtility.getFolder(this.m_bundle, "ws-stub", false), 2);
            }
            if (exception == null) {
                jarFile = JaxWsSdkUtility.getStubJarFile(this.m_bundle, this.m_properties, this.m_wsdlFileName);
                if (JaxWsSdkUtility.exists((IResource)jarFile)) {
                    if (!JaxWsSdkUtility.registerJarLib(this.m_bundle, jarFile, false, monitor)) {
                        exception = new Exception("Stub generation was successfull but registration of JAR file '" + jarFilePath + "' failed in .classpath / MANIFEST.MF / build.properties");
                    }
                } else {
                    exception = new CoreException((IStatus)new ScoutStatus("Failed to generate webservice artefacts. Probably a corrupt WSDL file, non-standardized WSDL file or a binding file problem."));
                }
            }
            if (exception == null) {
                this.notifyListeners(true, null);
            } else {
                this.notifyListeners(false, exception);
            }
        }
        finally {
            JaxWsSdk.getDefault().getMarkerQueueManager().resume();
        }
    }

    public String getOperationName() {
        return WsStubGenerationOperation.class.getName();
    }

    private void launchJavaApplicationSync(String launchName, String projectName, String javaMainTypeName, String argumentList, IProgressMonitor monitor) throws Exception {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType("org.eclipse.jdt.launching.localJavaApplication");
        ILaunchConfigurationWorkingCopy wc = type.newInstance(null, launchName);
        wc.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", true);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, projectName);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, javaMainTypeName);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, argumentList);
        wc.setAttribute(LaunchConfiguration.ATTR_MAPPED_RESOURCE_TYPES, Arrays.asList(Integer.toString(4)));
        wc.setAttribute(LaunchConfiguration.ATTR_MAPPED_RESOURCE_PATHS, Arrays.asList("/" + projectName));
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, this.getClasspathEntries());
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, false);
        wc.setAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
        ILaunchConfiguration lc = wc.doSave();
        boolean debugMode = JaxWsSdk.getDefault().getPreferenceStore().getBoolean("jaxws.stub.generation.debug_mode");
        String mode = debugMode ? "debug" : "run";
        String continueWithCompileErros = DebugUIPlugin.getDefault().getPreferenceStore().getString("org.eclipse.debug.ui.cancel_launch_with_compile_errors");
        boolean changedDebugPref = false;
        try {
            if (!CompareUtility.equals((Object)"always", (Object)continueWithCompileErros)) {
                DebugUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.debug.ui.cancel_launch_with_compile_errors", "always");
                changedDebugPref = true;
            }
            ILaunch launch = lc.launch(mode, monitor, true, true);
            while (!launch.isTerminated()) {
                if (monitor.isCanceled()) {
                    launch.terminate();
                    break;
                }
                Thread.sleep(1000L);
            }
            boolean keepLaunchConfiguration = JaxWsSdk.getDefault().getPreferenceStore().getBoolean("jaxws.stub.generation.launch_config_keep");
            if (!keepLaunchConfiguration) {
                lc.delete();
            }
            IProcess[] iProcessArray = launch.getProcesses();
            int n = iProcessArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProcess process = iProcessArray[n2];
                if (process.getExitValue() != 0) {
                    new CoreException((IStatus)new ScoutStatus("Stub generation failed"));
                }
                ++n2;
            }
        }
        finally {
            if (changedDebugPref) {
                DebugUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.debug.ui.cancel_launch_with_compile_errors", continueWithCompileErros);
            }
        }
    }

    private void notifyListeners(boolean success, Throwable exception) {
        IOperationFinishedListener[] iOperationFinishedListenerArray = this.m_operationFinishedListeners.toArray(new IOperationFinishedListener[this.m_operationFinishedListeners.size()]);
        int n = iOperationFinishedListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOperationFinishedListener listener = iOperationFinishedListenerArray[n2];
            try {
                listener.operationFinished(success, exception);
            }
            catch (Exception e) {
                JaxWsSdk.logError("failed to notify listener", e);
            }
            ++n2;
        }
    }

    private boolean isSuccess(IProcess[] processes) throws DebugException {
        IProcess[] iProcessArray = processes;
        int n = processes.length;
        int n2 = 0;
        while (n2 < n) {
            IProcess process = iProcessArray[n2];
            if (process.getExitValue() != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private List<String> getClasspathEntries() throws Exception {
        LinkedList<String> mementoList = new LinkedList<String>();
        IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = JavaRuntime.computeUnresolvedRuntimeClasspath((IJavaProject)this.m_bundle.getJavaProject());
        int n = iRuntimeClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntimeClasspathEntry classpathEntry = iRuntimeClasspathEntryArray[n2];
            mementoList.add(classpathEntry.getMemento());
            ++n2;
        }
        IType wsImportType = TypeUtility.getType((String)"com.sun.tools.internal.ws.WsImport");
        if (wsImportType == null || !wsImportType.exists() || !TypeUtility.isOnClasspath((IMember)wsImportType, (IJavaProject)this.m_bundle.getJavaProject())) {
            File toolsJarFile = this.locateToolsJar();
            if (toolsJarFile == null || !toolsJarFile.exists() || !toolsJarFile.isFile()) {
                throw new CoreException((IStatus)new ScoutStatus("Could not locate the Java library 'tools.jar'. Please ensure to have the environment variable JAVA_HOME set and the JAR /lib/tools.jar exists. Alternatively, add the JAR 'tools.jar' to the system libraries of the installed JRE in Eclipse Preferences 'Java | Installed JREs'."));
            }
            mementoList.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(toolsJarFile.getAbsolutePath())).getMemento());
        }
        return mementoList;
    }

    private File locateToolsJar() {
        String[] defaultToolsLocation = new String[]{"lib", "tools.jar"};
        File file = new File(System.getProperty("java.home"));
        if (file.getName().equalsIgnoreCase("jre")) {
            file = file.getParentFile();
        }
        String[] stringArray = defaultToolsLocation;
        int n = defaultToolsLocation.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            file = new File(file, name);
            ++n2;
        }
        return file;
    }

    public IScoutBundle getBundle() {
        return this.m_bundle;
    }

    public void setBundle(IScoutBundle bundle) {
        this.m_bundle = bundle;
    }

    public String getAlias() {
        return this.m_alias;
    }

    public void setAlias(String alias) {
        this.m_alias = alias;
    }

    public String getWsdlFileName() {
        return this.m_wsdlFileName;
    }

    public IFolder getWsdlFolder() {
        return this.m_wsdlFolder;
    }

    public void setWsdlFolder(IFolder wsdlFolder) {
        this.m_wsdlFolder = wsdlFolder;
    }

    public void setWsdlFileName(String wsdlFileName) {
        this.m_wsdlFileName = wsdlFileName;
    }

    public void setProperties(Map<String, List<String>> properties) {
        this.m_properties = properties;
    }
}

