/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.action;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.jdt.ui.actions.OpenNewClassWizardAction;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.util.typecache.TypeCacheAccessor;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.AbstractLinkAction;
import org.eclipse.swt.widgets.Shell;

public abstract class TypeNewAction
extends AbstractLinkAction {
    private IScoutBundle m_bundle;
    private String m_packageFragment;
    private boolean m_allowModifyPackageFragment;
    private String m_superTypeSignature;
    private boolean m_allowModifySuperType;
    private List<String> m_interfaceTypeSignatures;
    private boolean m_allowModifyInterfaces;
    private String m_typeName;
    private IType m_createdType;

    public TypeNewAction(String label) {
        super(Texts.get("Action_newTypeX", label), ScoutSdkUi.getImageDescriptor((String)"add.png"));
        this.setLinkText(Texts.get("here"));
        this.setLeadingText(Texts.get("CreateNewXByClicking", label));
    }

    public Object execute(Shell shell, IPage[] selection, ExecutionEvent event) throws ExecutionException {
        this.m_createdType = this.openNewTypeDialog();
        return null;
    }

    public void init(IScoutBundle bundle) {
        this.m_bundle = bundle;
    }

    protected IType openNewTypeDialog() {
        NewClassWizardPage page = new NewClassWizardPage();
        page.setDescription(this.getLabel());
        page.setEnclosingTypeSelection(false, false);
        page.setMethodStubSelection(false, true, true, true);
        IPackageFragment packageFragment = null;
        packageFragment = this.m_bundle.getPackageFragment(this.m_packageFragment);
        if (packageFragment != null) {
            page.setPackageFragmentRoot((IPackageFragmentRoot)packageFragment.getParent(), this.m_allowModifyPackageFragment);
            page.setPackageFragment(packageFragment, this.m_allowModifyPackageFragment);
        } else {
            String rootPackageName = this.m_bundle.getRootPackageName();
            page.setPackageFragmentRoot((IPackageFragmentRoot)this.m_bundle.getPackageFragment(rootPackageName).getParent(), true);
        }
        if (this.m_superTypeSignature != null) {
            page.setSuperClass(this.stripSignatureToFQN(this.m_superTypeSignature, false), this.m_allowModifySuperType);
        }
        if (this.m_interfaceTypeSignatures != null && this.m_interfaceTypeSignatures.size() > 0) {
            LinkedList<String> interfaceTypeNames = new LinkedList<String>();
            for (String signature : this.m_interfaceTypeSignatures) {
                interfaceTypeNames.add(this.stripSignatureToFQN(signature, false));
            }
            page.setSuperInterfaces(interfaceTypeNames, this.m_allowModifyInterfaces);
        }
        if (this.m_typeName != null) {
            page.setTypeName(Signature.getSimpleName((String)this.m_typeName), true);
        }
        OpenNewClassWizardAction action = new OpenNewClassWizardAction();
        action.setConfiguredWizardPage(page);
        action.run();
        this.m_createdType = page.getCreatedType();
        if (TypeUtility.exists((IJavaElement)this.m_createdType)) {
            IWorkingCopyManager level = TypeCacheAccessor.createWorkingCopyManger();
            try {
                level.register(this.m_createdType.getCompilationUnit(), (IProgressMonitor)new NullProgressMonitor());
                TypeUtility.getType((String)this.m_createdType.getFullyQualifiedName());
                level.reconcile(this.m_createdType.getCompilationUnit(), (IProgressMonitor)new NullProgressMonitor());
                TypeUtility.getPrimaryTypeHierarchy((IType)TypeUtility.getType((String)"org.eclipse.scout.jaxws.session.IServerSessionFactory")).invalidate();
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            level.unregisterAll((IProgressMonitor)new NullProgressMonitor());
            return this.m_createdType;
        }
        return null;
    }

    private String stripSignatureToFQN(String signature, boolean eraseGenericTypes) {
        if (signature == null) {
            return null;
        }
        String typeSignature = SignatureUtil.stripSignatureToFQN((String)signature);
        if (!eraseGenericTypes) {
            String typeArguments = null;
            String[] stringArray = Signature.getTypeArguments((String)signature);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String typeArgument = stringArray[n2];
                typeArguments = StringUtility.join((String)",", (String[])new String[]{typeArguments, SignatureUtil.stripSignatureToFQN((String)typeArgument)});
                ++n2;
            }
            if (typeArguments != null) {
                typeSignature = String.valueOf(typeSignature) + "<" + typeArguments + ">";
            }
        }
        return typeSignature;
    }

    public IScoutBundle getBundle() {
        return this.m_bundle;
    }

    public void setBundle(IScoutBundle bundle) {
        this.m_bundle = bundle;
    }

    public void setSuperTypeSignature(String superTypeSignature, boolean allowModify) {
        this.m_superTypeSignature = superTypeSignature;
        this.m_allowModifySuperType = allowModify;
    }

    public void setInterfaceTypeSignatures(List<String> interfaceTypeSignatures, boolean allowModify) {
        this.m_interfaceTypeSignatures = interfaceTypeSignatures;
        this.m_allowModifyInterfaces = allowModify;
    }

    public void setPackageFragment(String packageFragment, boolean allowModify) {
        this.m_packageFragment = packageFragment;
        this.m_allowModifyPackageFragment = allowModify;
    }

    public IType getCreatedType() {
        return this.m_createdType;
    }

    public void setTypeName(String typeName) {
        this.m_typeName = typeName;
    }
}

