/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.dialog;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class SelectionDialog<T>
extends TitleAreaDialog {
    protected static final String IStructuredSelection = null;
    private T m_element;
    private TableViewer m_viewer;
    private String m_dialogTitle;
    private String m_dialogMessage;
    private Collection<T> m_elements;

    public SelectionDialog(Shell shell, String dialogTitle, String dialogMessage) {
        super(shell);
        this.m_dialogTitle = dialogTitle;
        this.m_dialogMessage = dialogMessage;
        this.m_elements = new LinkedList<T>();
        SelectionDialog.setDialogHelpAvailable((boolean)false);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected final void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.m_dialogTitle);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setTitle(this.m_dialogTitle);
        this.setMessage(this.m_dialogMessage, 1);
        this.getOkButton().setEnabled(false);
        return control;
    }

    public void setElements(Collection<T> elements) {
        this.m_elements = elements;
    }

    public T getElement() {
        return this.m_element;
    }

    public Button getOkButton() {
        return this.getButton(0);
    }

    protected Control createDialogArea(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        this.m_viewer = new TableViewer(new Table(tableComposite, 67584));
        this.m_viewer.setUseHashlookup(true);
        this.m_viewer.getTable().setHeaderVisible(true);
        this.m_viewer.getTable().setLinesVisible(false);
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)SelectionDialog.this.m_viewer.getSelection();
                SelectionDialog.this.m_element = selection.getFirstElement();
                SelectionDialog.this.getOkButton().setEnabled(true);
            }
        });
        this.m_viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)SelectionDialog.this.m_viewer.getSelection();
                SelectionDialog.this.m_element = selection.getFirstElement();
                SelectionDialog.this.getOkButton().setEnabled(true);
                SelectionDialog.this.close();
            }
        });
        TableViewerColumn nameColumn = new TableViewerColumn(this.m_viewer, 16384, 0);
        nameColumn.setLabelProvider((CellLabelProvider)new P_LabelProvider());
        nameColumn.getColumn().setResizable(true);
        nameColumn.getColumn().setText(this.getConfiguredNameColumnText());
        TableViewerColumn descriptionColumn = null;
        if (this.getConfiguredIsDescriptionColumnVisible()) {
            descriptionColumn = new TableViewerColumn(this.m_viewer, 16384, 1);
            descriptionColumn.setLabelProvider((CellLabelProvider)new P_LabelProvider());
            descriptionColumn.getColumn().setResizable(true);
            descriptionColumn.getColumn().setText(this.getConfiguredDescriptionColumnText());
        }
        this.m_viewer.setContentProvider((IContentProvider)new P_ContentProvider());
        this.m_viewer.setInput((Object)this.m_elements.toArray());
        parent.setLayout((Layout)new GridLayout());
        tableComposite.setLayoutData((Object)new GridData(1808));
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableLayout);
        if (descriptionColumn == null) {
            tableLayout.setColumnData((Widget)nameColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, false));
        } else {
            tableLayout.setColumnData((Widget)nameColumn.getColumn(), (ColumnLayoutData)new ColumnPixelData(120, true));
            tableLayout.setColumnData((Widget)descriptionColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, true));
        }
        return tableComposite;
    }

    protected void execDecorateElement(T element, ViewerCell cell) {
        cell.setText(element.toString());
    }

    protected boolean getConfiguredIsDescriptionColumnVisible() {
        return false;
    }

    protected String getConfiguredNameColumnText() {
        return Texts.get("Name");
    }

    protected String getConfiguredDescriptionColumnText() {
        return Texts.get("Description");
    }

    public class P_ContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class P_LabelProvider
    extends CellLabelProvider {
        private P_LabelProvider() {
        }

        public void update(ViewerCell cell) {
            SelectionDialog.this.execDecorateElement(cell.getElement(), cell);
        }
    }
}

