/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.part;

import javax.xml.ws.Service;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.scout.sdk.ui.view.properties.part.ISection;
import org.eclipse.scout.sdk.ui.view.properties.part.singlepage.AbstractSinglePageSectionBasedViewPart;
import org.eclipse.scout.sdk.ui.view.properties.presenter.AbstractPresenter;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.CleanupPhantomJarFileAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.FileOpenAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServicesTablePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.ActionPresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.InformationPresenter;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;

public class WebServicesTablePagePropertyViewPart
extends AbstractSinglePageSectionBasedViewPart {
    public static final String SECTION_ID_LINKS = "section.jaxws.links";
    public static final String SECTION_ID_INFORMATION = "section.jaxws.information";
    private IScoutBundle m_bundle;

    protected void init() {
        this.m_bundle = this.getPage().getScoutResource();
    }

    protected void createSections() {
        this.getForm().setRedraw(false);
        try {
            AbstractPresenter presenter;
            this.createSection(SECTION_ID_LINKS, Texts.get("ConsiderLinks"));
            IFile buildJaxWsFile = ResourceFactory.getBuildJaxWsResource(this.m_bundle).getFile();
            if (JaxWsSdkUtility.exists((IResource)buildJaxWsFile)) {
                FileOpenAction a = new FileOpenAction();
                a.init(buildJaxWsFile, buildJaxWsFile.getName(), JaxWsSdk.getImageDescriptor("build-jaxws.png"), FileOpenAction.FileExtensionType.Xml);
                a.setToolTip(Texts.get("JaxWsBuildDescriptor"));
                presenter = new ActionPresenter(this.getSection(SECTION_ID_LINKS).getSectionClient(), a, this.getFormToolkit());
                this.applyLayoutData(presenter);
            }
            CleanupPhantomJarFileAction b = new CleanupPhantomJarFileAction();
            b.init(this.m_bundle);
            presenter = new ActionPresenter(this.getSection(SECTION_ID_LINKS).getSectionClient(), b, this.getFormToolkit());
            this.applyLayoutData(presenter);
            if (TypeUtility.getTypes((String)Service.class.getName()).length > 1) {
                ISection section = this.createSection(SECTION_ID_INFORMATION, Texts.get("Information"), null, false);
                presenter = new InformationPresenter(section.getSectionClient(), "Multiple JAX-WS RI implementations detected which might cause problems at design and runtime. Please consider that the installed Scout JAX-WS integration supports JAX-WS RI 2.1.6 bundled with Java SE 6.", JaxWsSdk.getImageDescriptor("ov_javadev48.gif"), new Point(48, 100), this.getFormToolkit());
                this.applyLayoutData(presenter);
            }
        }
        finally {
            this.getForm().setRedraw(true);
        }
    }

    public WebServicesTablePage getPage() {
        return (WebServicesTablePage)super.getPage();
    }

    private void applyLayoutData(AbstractPresenter presenter) {
        GridData layoutData = new GridData(768);
        presenter.getContainer().setLayoutData((Object)layoutData);
    }
}

