/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter;

import java.util.Arrays;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.SimpleLabelProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.SimpleProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.StaticContentProvider;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.AbstractPropertyPresenter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ProposalPresenter<T extends SimpleProposal>
extends AbstractPropertyPresenter<T> {
    protected ProposalTextField m_proposalField;
    protected SimpleProposal[] m_proposals;
    private IProposalAdapterListener m_proposalListener;

    public ProposalPresenter(Composite parent, PropertyViewFormToolkit toolkit) {
        super(parent, toolkit, true);
    }

    public ProposalPresenter(Composite parent, PropertyViewFormToolkit toolkit, boolean initialize) {
        super(parent, toolkit, initialize);
    }

    @Override
    protected Control createContent(Composite parent) {
        this.m_proposalField = this.getToolkit().createProposalField(parent, "", ProposalTextField.STYLE_NO_LABEL);
        this.initializeProposalField(this.getProposals());
        this.m_proposalListener = new P_ProposalListener();
        this.m_proposalField.addProposalAdapterListener(this.m_proposalListener);
        return this.m_proposalField;
    }

    public void setProposals(SimpleProposal[] proposals) {
        this.m_proposals = proposals;
        this.initializeProposalField(proposals);
    }

    private void initializeProposalField(SimpleProposal[] proposals) {
        this.setStateChanging(true);
        try {
            if (this.isControlCreated()) {
                StaticContentProvider provider = new StaticContentProvider((Object[])this.m_proposals, (ILabelProvider)new SimpleLabelProvider());
                this.m_proposalField.setContentProvider((IContentProvider)provider);
                if (!this.isStateChanging()) {
                    this.setInput((SimpleProposal)this.getValue());
                }
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public SimpleProposal[] getProposals() {
        return this.m_proposals;
    }

    @Override
    protected void setInputInternal(T input) {
        this.m_proposalField.removeProposalAdapterListener(this.m_proposalListener);
        try {
            if (input != null && this.m_proposals != null && Arrays.asList(this.m_proposals).contains(input)) {
                this.m_proposalField.acceptProposal(input);
            } else {
                this.m_proposalField.acceptProposal(null);
            }
        }
        finally {
            this.m_proposalField.addProposalAdapterListener(this.m_proposalListener);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.m_proposalField.setEnabled(enabled);
    }

    private final class P_ProposalListener
    implements IProposalAdapterListener {
        private P_ProposalListener() {
        }

        public void proposalAccepted(ContentProposalEvent event) {
            SimpleProposal proposal = (SimpleProposal)event.proposal;
            if (proposal != null || ProposalPresenter.this.isAcceptNullValue()) {
                ProposalPresenter.this.setValueFromUI(proposal);
            } else {
                ProposalPresenter.this.setInfo(2, Texts.get("InvalidValue"));
            }
        }
    }
}

