/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.xmlparser.ScoutXmlDocument;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.HandlerChainFilterWizardPage;

public class HandlerChainFilterWizard
extends AbstractWorkspaceWizard {
    private HandlerChainFilterWizardPage m_wizardPage;
    private IScoutBundle m_bundle;
    private SunJaxWsBean m_sunJaxWsBean;
    private ScoutXmlDocument.ScoutXmlElement m_xmlHandlerChain;
    private HandlerChainFilterWizardPage.FilterTypeEnum m_filterTypeEnum;
    private String m_namespacePrefix;
    private String m_namespace;
    private String m_pattern;

    public HandlerChainFilterWizard() {
        this.setWindowTitle(Texts.get("HandlerChainFilter"));
    }

    public void init(IScoutBundle bundle, SunJaxWsBean sunJaxWsBean, ScoutXmlDocument.ScoutXmlElement xmlHandlerChain) {
        this.m_bundle = bundle;
        this.m_sunJaxWsBean = sunJaxWsBean;
        this.m_xmlHandlerChain = xmlHandlerChain;
        ScoutXmlDocument.ScoutXmlElement xmlFilterProtocol = this.m_xmlHandlerChain.getChild(this.toQualifiedName("protocol-bindings"));
        ScoutXmlDocument.ScoutXmlElement xmlFilterService = this.m_xmlHandlerChain.getChild(this.toQualifiedName("service-name-pattern"));
        ScoutXmlDocument.ScoutXmlElement xmlFilterPort = this.m_xmlHandlerChain.getChild(this.toQualifiedName("port-name-pattern"));
        if (xmlFilterProtocol != null) {
            this.m_filterTypeEnum = HandlerChainFilterWizardPage.FilterTypeEnum.ProtocolFilter;
            this.m_pattern = xmlFilterProtocol.getText();
        } else if (xmlFilterService != null || xmlFilterPort != null) {
            ScoutXmlDocument.ScoutXmlElement xmlFilter;
            if (xmlFilterService != null) {
                xmlFilter = xmlFilterService;
                this.m_filterTypeEnum = HandlerChainFilterWizardPage.FilterTypeEnum.ServiceFilter;
            } else {
                xmlFilter = xmlFilterPort;
                this.m_filterTypeEnum = HandlerChainFilterWizardPage.FilterTypeEnum.PortFilter;
            }
            this.m_pattern = xmlFilter.getText();
            Map namespaces = xmlFilter.getNamespaces();
            if (namespaces != null && namespaces.size() > 0) {
                Map.Entry ns = namespaces.entrySet().iterator().next();
                this.m_namespacePrefix = (String)ns.getKey();
                this.m_namespace = (String)ns.getValue();
            }
        } else {
            this.m_filterTypeEnum = HandlerChainFilterWizardPage.FilterTypeEnum.NoFilter;
        }
    }

    public void addPages() {
        this.m_wizardPage = new HandlerChainFilterWizardPage(this.m_bundle);
        this.m_wizardPage.setFilterType(this.m_filterTypeEnum);
        this.m_wizardPage.setNamespacePrefix(this.m_namespacePrefix);
        this.m_wizardPage.setNamespace(this.m_namespace);
        this.m_wizardPage.setPattern(this.m_pattern);
        this.addPage((IWizardPage)this.m_wizardPage);
    }

    protected boolean beforeFinish() throws CoreException {
        this.m_filterTypeEnum = this.m_wizardPage.getFilterType();
        this.m_namespacePrefix = this.m_wizardPage.getNamespacePrefix();
        this.m_namespace = this.m_wizardPage.getNamespace();
        this.m_pattern = this.m_wizardPage.getPattern();
        return true;
    }

    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        while (this.m_xmlHandlerChain.hasChild(this.toQualifiedName("protocol-bindings"))) {
            this.m_xmlHandlerChain.removeChild(this.toQualifiedName("protocol-bindings"));
        }
        while (this.m_xmlHandlerChain.hasChild(this.toQualifiedName("service-name-pattern"))) {
            this.m_xmlHandlerChain.removeChild(this.toQualifiedName("service-name-pattern"));
        }
        while (this.m_xmlHandlerChain.hasChild(this.toQualifiedName("port-name-pattern"))) {
            this.m_xmlHandlerChain.removeChild(this.toQualifiedName("port-name-pattern"));
        }
        switch (this.m_filterTypeEnum) {
            case ProtocolFilter: {
                ScoutXmlDocument.ScoutXmlElement protocolFilter = this.m_xmlHandlerChain.addChild();
                this.m_xmlHandlerChain.removeChild(protocolFilter);
                this.m_xmlHandlerChain.addChild(protocolFilter, 0);
                protocolFilter.setName(this.toQualifiedName("protocol-bindings"));
                protocolFilter.addText(this.m_pattern);
                break;
            }
            case ServiceFilter: {
                ScoutXmlDocument.ScoutXmlElement serviceFilter = this.m_xmlHandlerChain.addChild();
                this.m_xmlHandlerChain.removeChild(serviceFilter);
                this.m_xmlHandlerChain.addChild(serviceFilter, 0);
                serviceFilter.setName(this.toQualifiedName("service-name-pattern"));
                serviceFilter.addText(this.m_pattern);
                serviceFilter.setNamespace(this.m_namespacePrefix, this.m_namespace);
                break;
            }
            case PortFilter: {
                ScoutXmlDocument.ScoutXmlElement portFilter = this.m_xmlHandlerChain.addChild();
                this.m_xmlHandlerChain.removeChild(portFilter);
                this.m_xmlHandlerChain.addChild(portFilter, 0);
                portFilter.setName(this.toQualifiedName("port-name-pattern"));
                portFilter.addText(this.m_pattern);
                portFilter.setNamespace(this.m_namespacePrefix, this.m_namespace);
            }
        }
        ResourceFactory.getSunJaxWsResource(this.m_bundle).storeXmlAsync(this.m_xmlHandlerChain.getDocument(), 512, this.m_sunJaxWsBean.getAlias());
        return true;
    }

    private String toQualifiedName(String name) {
        return this.m_sunJaxWsBean.toQualifiedName(name);
    }
}

