/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.soap.SOAPHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.BasicPropertySupport;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.tooltip.JavadocTooltip;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;

public class HandlerNewWizardPage
extends AbstractWorkspaceWizardPage {
    public static final String PROP_TYPE_NAME = "typeName";
    public static final String PROP_PACKAGE_NAME = "packageName";
    public static final String PROP_TRANSACTIONAL = "transactional";
    public static final String PROP_SESSION_TYPE = "sessionFactory";
    public static final String PROP_SUPER_TYPE = "superType";
    private BasicPropertySupport m_propertySupport;
    private IScoutBundle m_bundle;
    private StyledTextField m_typeNameField;
    private StyledTextField m_superTypeField;
    private StyledTextField m_packageField;
    private Button m_packageBrowseButton;
    private Button m_superTypeBrowseButton;
    private JavadocTooltip m_tooltipSuperType;
    private Button m_transactionalButton;
    private StyledTextField m_sessionFactoryField;
    private Text m_descriptionSessionFactory;
    private Button m_sessionFactoryBrowseButton;
    private JavadocTooltip m_tooltipSessionFactory;

    public HandlerNewWizardPage(IScoutBundle bundle) {
        super(HandlerNewWizardPage.class.getName());
        this.setTitle(Texts.get("CreateHandler"));
        this.setDescription(Texts.get("ByClickingFinishHandlerIsCreated"));
        this.m_bundle = bundle;
        this.m_propertySupport = new BasicPropertySupport((Object)this);
        this.setPackageName(JaxWsSdkUtility.getRecommendedHandlerPackageName(this.m_bundle));
        this.setTransactional(true);
        try {
            String defaultSessionFactory = (String)TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebService").getMethod(PROP_SESSION_TYPE, new String[0]).getDefaultValue().getValue();
            this.setSessionFactoryType(TypeUtility.getType((String)defaultSessionFactory));
        }
        catch (JavaModelException e) {
            JaxWsSdk.logError(e);
        }
        this.setSuperType(TypeUtility.getType((String)SOAPHandler.class.getName()));
    }

    protected void createContent(Composite parent) {
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get("Name"));
        this.m_typeNameField.setReadOnlySuffix("Handler");
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HandlerNewWizardPage.this.setTypeNameInternal(HandlerNewWizardPage.this.m_typeNameField.getText());
                HandlerNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_superTypeField = this.getFieldToolkit().createStyledTextField(parent, Texts.get("SuperType"));
        if (TypeUtility.exists((IJavaElement)this.getSuperType())) {
            this.m_superTypeField.setText(this.getSuperType().getElementName());
        }
        this.m_superTypeField.setEditable(false);
        this.m_tooltipSuperType = new JavadocTooltip((Control)this.m_superTypeField.getTextComponent());
        this.updateJavaDoc(this.m_tooltipSuperType, this.getSuperType());
        this.m_superTypeBrowseButton = new Button(parent, 0x800008);
        this.m_superTypeBrowseButton.setText(Texts.get("Browse"));
        this.m_superTypeBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IJavaSearchScope searchScope = HandlerNewWizardPage.this.createSuperTypeSearchScope();
                    SelectionDialog dialog = JavaUI.createTypeDialog((Shell)ScoutSdkUi.getShell(), null, (IJavaSearchScope)searchScope, (int)6, (boolean)false, (String)"*.*");
                    dialog.setTitle(Texts.get("SuperType"));
                    dialog.setMessage(Texts.get("ChooseXY", Texts.get("SuperType")));
                    dialog.setBlockOnOpen(true);
                    if (dialog.open() == 0 && dialog.getResult() != null) {
                        IType type = (IType)dialog.getResult()[0];
                        HandlerNewWizardPage.this.setSuperType(type);
                    }
                }
                catch (JavaModelException exception) {
                    JaxWsSdk.logError(exception);
                }
            }
        });
        this.m_packageField = this.getFieldToolkit().createStyledTextField(parent, Texts.get("Package"));
        this.m_packageField.setText(this.getPackageName());
        this.m_packageField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HandlerNewWizardPage.this.setPackageNameInternal(HandlerNewWizardPage.this.m_packageField.getText());
                HandlerNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_packageBrowseButton = new Button(parent, 0x800008);
        this.m_packageBrowseButton.setText(Texts.get("Browse"));
        this.m_packageBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPackageFragment[] packageFragment = HandlerNewWizardPage.this.openBrowsePackagesDialog();
                if (packageFragment != null && packageFragment.length > 0) {
                    HandlerNewWizardPage.this.setPackageName(packageFragment[0].getElementName());
                }
            }
        });
        this.m_transactionalButton = new Button(parent, 32);
        this.m_transactionalButton.setText(Texts.get("RunHandlerInScoutTransaction"));
        this.m_transactionalButton.setSelection(this.isTransactional());
        this.m_transactionalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HandlerNewWizardPage.this.setTransactionalInternal(HandlerNewWizardPage.this.m_transactionalButton.getSelection());
                HandlerNewWizardPage.this.m_sessionFactoryBrowseButton.setEnabled(HandlerNewWizardPage.this.isTransactional());
                HandlerNewWizardPage.this.m_sessionFactoryField.setEnabled(HandlerNewWizardPage.this.isTransactional());
            }
        });
        this.m_descriptionSessionFactory = new Text(parent, 74);
        this.m_descriptionSessionFactory.setForeground(ScoutSdkUi.getDisplay().getSystemColor(16));
        this.m_descriptionSessionFactory.setText(Texts.get("DescriptionHandlerSession"));
        this.m_sessionFactoryField = this.getFieldToolkit().createStyledTextField(parent, Texts.get("SessionFactory"));
        if (TypeUtility.exists((IJavaElement)this.getSuperType())) {
            this.m_sessionFactoryField.setText(this.getSessionFactoryType().getElementName());
        }
        this.m_sessionFactoryField.setEditable(false);
        this.m_tooltipSessionFactory = new JavadocTooltip((Control)this.m_sessionFactoryField.getTextComponent());
        this.updateJavaDoc(this.m_tooltipSessionFactory, this.getSessionFactoryType());
        this.m_sessionFactoryBrowseButton = new Button(parent, 0x800008);
        this.m_sessionFactoryBrowseButton.setText(Texts.get("Browse"));
        this.m_sessionFactoryBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IJavaSearchScope searchScope = HandlerNewWizardPage.this.createSubClassesSearchScope(TypeUtility.getType((String)"org.eclipse.scout.jaxws.session.IServerSessionFactory"));
                    SelectionDialog dialog = JavaUI.createTypeDialog((Shell)ScoutSdkUi.getShell(), null, (IJavaSearchScope)searchScope, (int)2, (boolean)false, (String)"*.*");
                    dialog.setTitle(Texts.get("SessionFactory"));
                    dialog.setMessage(Texts.get("ChooseXY", Texts.get("SessionFactory")));
                    dialog.setBlockOnOpen(true);
                    if (dialog.open() == 0 && dialog.getResult() != null) {
                        IType type = (IType)dialog.getResult()[0];
                        HandlerNewWizardPage.this.setSessionFactoryType(type);
                    }
                }
                catch (JavaModelException exception) {
                    JaxWsSdk.logError(exception);
                }
            }
        });
        parent.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.m_typeNameField.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_typeNameField, 5, 1024);
        formData.left = new FormAttachment(0, 50);
        formData.right = new FormAttachment(100, -75);
        this.m_packageField.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_packageField, 0, 128);
        formData.left = new FormAttachment(100, -70);
        formData.right = new FormAttachment(100, 0);
        this.m_packageBrowseButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_packageBrowseButton, 5, 1024);
        formData.left = new FormAttachment(0, 50);
        formData.right = new FormAttachment(100, -75);
        this.m_superTypeField.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_superTypeField, -2, 128);
        formData.left = new FormAttachment(100, -70);
        formData.right = new FormAttachment(100, 0);
        this.m_superTypeBrowseButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_superTypeBrowseButton, 25, 1024);
        formData.left = new FormAttachment(40, 5);
        formData.right = new FormAttachment(100, 0);
        this.m_transactionalButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_transactionalButton, 5, 1024);
        formData.left = new FormAttachment(40, 2);
        formData.right = new FormAttachment(100, 0);
        this.m_descriptionSessionFactory.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_descriptionSessionFactory, 5, 1024);
        formData.left = new FormAttachment(0, 50);
        formData.right = new FormAttachment(100, -75);
        this.m_sessionFactoryField.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_sessionFactoryField, -2, 128);
        formData.left = new FormAttachment(100, -70);
        formData.right = new FormAttachment(100, 0);
        this.m_sessionFactoryBrowseButton.setLayoutData((Object)formData);
    }

    protected void validatePage(MultiStatus multiStatus) {
        this.validateType(multiStatus);
        if (this.isTransactional() && !TypeUtility.exists((IJavaElement)this.getSessionFactoryType())) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("XMustNotBeEmpty", Texts.get("SessionFactory"))));
        }
    }

    protected void validateType(MultiStatus multiStatus) {
        if (StringUtility.isNullOrEmpty((String)this.getPackageName())) {
            multiStatus.add((IStatus)new Status(2, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("UsageOfDefaultPackageDiscouraged")));
        } else {
            multiStatus.add(JavaConventionsUtil.validatePackageName((String)this.getPackageName(), (IJavaElement)this.m_bundle.getJavaProject()));
            String recommendedPackageName = JaxWsSdkUtility.getRecommendedHandlerPackageName(this.m_bundle);
            if (!this.getPackageName().equals(recommendedPackageName)) {
                multiStatus.add((IStatus)new Status(2, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("ByConventionXShouldByY", Texts.get("Package"), recommendedPackageName)));
            }
        }
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("Handler")) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("XMustNotBeEmpty", Texts.get("Name"))));
        } else {
            multiStatus.add(JavaConventionsUtil.validateJavaTypeName((String)this.getTypeName(), (IJavaElement)this.m_bundle.getJavaProject()));
            if (Character.isLowerCase(this.getTypeName().charAt(0))) {
                multiStatus.add((IStatus)new Status(2, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("LowerCaseTypeName")));
            }
        }
        if (multiStatus.getSeverity() < 4) {
            try {
                String fqn = StringUtility.join((String)".", (String[])new String[]{this.getPackageName(), this.getTypeName()});
                if (TypeUtility.existsType((String)fqn)) {
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("TypeAlreadyExsits", fqn)));
                }
            }
            catch (Exception exception) {
                multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("InvalidJavaType", this.getTypeName())));
            }
        }
    }

    public void setTransactional(boolean transactional) {
        try {
            this.setStateChanging(true);
            this.setTransactionalInternal(transactional);
            if (this.isControlCreated()) {
                this.m_transactionalButton.setSelection(transactional);
                this.m_sessionFactoryBrowseButton.setEnabled(this.isTransactional());
                this.m_sessionFactoryField.setEnabled(this.isTransactional());
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setTransactionalInternal(boolean transactional) {
        this.m_propertySupport.setPropertyBool(PROP_TRANSACTIONAL, transactional);
    }

    public boolean isTransactional() {
        return this.m_propertySupport.getPropertyBool(PROP_TRANSACTIONAL);
    }

    private void updateJavaDoc(JavadocTooltip javadocTooltip, IType type) {
        try {
            javadocTooltip.setMember(null);
            if (TypeUtility.exists((IJavaElement)type)) {
                javadocTooltip.setMember((IMember)type);
            }
        }
        catch (Exception e) {
            JaxWsSdk.logWarning("Could not render tooltip", e);
        }
    }

    public void setSessionFactoryType(IType sessionFactoryType) {
        try {
            this.setStateChanging(true);
            this.setSessionFactoryTypeInternal(sessionFactoryType);
            if (this.isControlCreated()) {
                if (sessionFactoryType != null) {
                    this.m_sessionFactoryField.setText(sessionFactoryType.getElementName());
                } else {
                    this.m_sessionFactoryField.setText("");
                }
                this.updateJavaDoc(this.m_tooltipSessionFactory, this.getSessionFactoryType());
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setSessionFactoryTypeInternal(IType sessionFactoryType) {
        this.m_propertySupport.setProperty(PROP_SESSION_TYPE, (Object)sessionFactoryType);
    }

    public IType getSessionFactoryType() {
        return (IType)this.m_propertySupport.getProperty(PROP_SESSION_TYPE);
    }

    public void setSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            this.setSuperTypeInternal(superType);
            if (this.isControlCreated()) {
                if (superType != null) {
                    this.m_superTypeField.setText(superType.getElementName());
                } else {
                    this.m_superTypeField.setText("");
                }
                this.updateJavaDoc(this.m_tooltipSuperType, this.getSuperType());
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setSuperTypeInternal(IType superType) {
        this.m_propertySupport.setProperty(PROP_SUPER_TYPE, (Object)superType);
    }

    public IType getSuperType() {
        return (IType)this.m_propertySupport.getProperty(PROP_SUPER_TYPE);
    }

    public void setTypeName(String typeName) {
        try {
            typeName = JaxWsSdkUtility.toStartWithUpperCase(typeName);
            this.setStateChanging(true);
            this.setTypeNameInternal(typeName);
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setTypeNameInternal(String typeName) {
        this.m_propertySupport.setProperty(PROP_TYPE_NAME, (Object)typeName);
    }

    public String getTypeName() {
        return this.m_propertySupport.getPropertyString(PROP_TYPE_NAME);
    }

    public void setPackageName(String packageName) {
        try {
            this.setStateChanging(true);
            this.setPackageNameInternal(packageName);
            if (this.isControlCreated()) {
                this.m_packageField.setText(packageName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setPackageNameInternal(String packageName) {
        this.m_propertySupport.setPropertyString(PROP_PACKAGE_NAME, packageName);
    }

    public String getPackageName() {
        return this.m_propertySupport.getPropertyString(PROP_PACKAGE_NAME);
    }

    private IJavaSearchScope createSubClassesSearchScope(IType superType) {
        IType[] subTypes = JaxWsSdkUtility.getJdtSubTypes(this.m_bundle, superType.getFullyQualifiedName(), false, false, true, false);
        return SearchEngine.createJavaSearchScope((IJavaElement[])subTypes);
    }

    private IJavaSearchScope createSuperTypeSearchScope() {
        ArrayList<IType> types = new ArrayList<IType>();
        types.add(TypeUtility.getType((String)SOAPHandler.class.getName()));
        types.add(TypeUtility.getType((String)LogicalHandler.class.getName()));
        types.addAll(Arrays.asList(JaxWsSdkUtility.getJdtSubTypes(this.m_bundle, LogicalHandler.class.getName(), true, true, false, false)));
        types.addAll(Arrays.asList(JaxWsSdkUtility.getJdtSubTypes(this.m_bundle, SOAPHandler.class.getName(), true, true, false, false)));
        IType authHandlerProv = TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.provider.IAuthenticationHandler");
        IType authHandlerCons = TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.consumer.IAuthenticationHandler");
        IType[] providerAuthHandlers = JaxWsSdkUtility.getJdtSubTypes(this.m_bundle, authHandlerProv.getFullyQualifiedName(), true, true, false, false);
        types.removeAll(Arrays.asList(providerAuthHandlers));
        types.remove(TypeUtility.getType((String)authHandlerProv.getFullyQualifiedName()));
        IType[] consumerAuthHandlers = JaxWsSdkUtility.getJdtSubTypes(this.m_bundle, authHandlerCons.getFullyQualifiedName(), true, true, false, false);
        types.removeAll(Arrays.asList(consumerAuthHandlers));
        types.remove(TypeUtility.getType((String)authHandlerCons.getFullyQualifiedName()));
        Iterator iterator = types.iterator();
        while (iterator.hasNext()) {
            IType candidate = (IType)iterator.next();
            if (!Signature.getQualifier((String)candidate.getFullyQualifiedName()).contains("internal")) continue;
            iterator.remove();
        }
        JaxWsSdkUtility.sortTypesByName(types, true);
        return SearchEngine.createJavaSearchScope((IJavaElement[])((IJavaElement[])types.toArray(new IType[types.size()])));
    }

    private IPackageFragment[] openBrowsePackagesDialog() {
        IPackageFragment[] packageFragments = null;
        BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
        SelectionDialog dialog = JavaUI.createPackageDialog((Shell)ScoutSdkUi.getShell(), (IRunnableContext)context, (IJavaSearchScope)this.m_bundle.getSearchScope(), (boolean)false, (boolean)true, null);
        dialog.setTitle(Texts.get("Package"));
        dialog.setMessage(Texts.get("ChoosePackageForHandler"));
        if (dialog.open() == 0 && dialog.getResult() != null) {
            packageFragments = Arrays.asList(dialog.getResult()).toArray(new IPackageFragment[0]);
        }
        if (packageFragments != null) {
            return packageFragments;
        }
        return null;
    }
}

