/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page;

import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.beans.BasicPropertySupport;
import org.eclipse.scout.commons.xmlparser.ScoutXmlDocument;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.tooltip.JavadocTooltip;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.resource.XmlResource;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;

public class WsConsumerImplClassWizardPage
extends AbstractWorkspaceWizardPage {
    public static final String PROP_PACKAGE = "package";
    public static final String PROP_TYPE_NAME = "name";
    public static final String PROP_ANNOTATE_IMPL = "createScoutWsAnnotation";
    public static final String PROP_AUTHENTICATION_HANDLER = "authenticationHandler";
    private BasicPropertySupport m_propertySupport;
    private IScoutBundle m_bundle;
    private Button m_createImplClassButton;
    private StyledTextField m_packageField;
    private Button m_packageBrowseButton;
    private StyledTextField m_typeNameField;
    private Button m_annotateImplButton;
    private Text m_descriptionScoutAnnotation;
    private Composite m_containerAnnotation;
    private StyledTextField m_authenticationHandlerField;
    private Button m_authenticationFactoryBrowseButton;
    private Set<String> m_illegalTypeNames;
    private JavadocTooltip m_tooltipAuthenticationFactory;

    public WsConsumerImplClassWizardPage(IScoutBundle bundle) {
        super(WsConsumerImplClassWizardPage.class.getName());
        this.setTitle(Texts.get("ConfigureImplementingClass"));
        this.setDescription(Texts.get("ConfigureImplementingClass"));
        this.m_propertySupport = new BasicPropertySupport((Object)this);
        this.m_bundle = bundle;
        this.m_illegalTypeNames = this.getIllegalTypeNames();
        this.applyDefaults();
    }

    private void applyDefaults() {
        this.setAnnotateImplClass(true);
        this.setAuthenticationHandler(TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.consumer.IAuthenticationHandler$NONE").getFullyQualifiedName());
        this.setPackageName(JaxWsSdkUtility.getRecommendedConsumerImplPackageName(this.m_bundle));
    }

    public void postActivate() {
        this.setAuthenticationHandler(this.getAuthenticationHandler());
    }

    protected void createContent(Composite parent) {
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get("Name"));
        this.m_typeNameField.setReadOnlySuffix("WebServiceClient");
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WsConsumerImplClassWizardPage.this.setTypeNameInternal(WsConsumerImplClassWizardPage.this.m_typeNameField.getText());
                WsConsumerImplClassWizardPage.this.pingStateChanging();
            }
        });
        this.m_packageField = this.getFieldToolkit().createStyledTextField(parent, Texts.get("Package"));
        this.m_packageField.setText(this.getPackageName());
        this.m_packageField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WsConsumerImplClassWizardPage.this.setPackageNameInternal(WsConsumerImplClassWizardPage.this.m_packageField.getText());
                WsConsumerImplClassWizardPage.this.pingStateChanging();
            }
        });
        this.m_packageBrowseButton = new Button(parent, 0x800008);
        this.m_packageBrowseButton.setText(Texts.get("Browse"));
        this.m_packageBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPackageFragment[] packageFragment = WsConsumerImplClassWizardPage.this.openBrowsePackagesDialog();
                if (packageFragment != null && packageFragment.length > 0) {
                    WsConsumerImplClassWizardPage.this.setPackageName(packageFragment[0].getElementName());
                }
            }
        });
        this.m_annotateImplButton = new Button(parent, 32);
        this.m_annotateImplButton.setText(Texts.get("AnnotateImplClass", TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebServiceClient").getElementName()));
        this.m_annotateImplButton.setSelection(this.isAnnotateImplClass());
        this.m_annotateImplButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WsConsumerImplClassWizardPage.this.setAnnotateImplClass(WsConsumerImplClassWizardPage.this.m_annotateImplButton.getSelection());
            }
        });
        this.m_containerAnnotation = new Composite(parent, 0);
        this.m_descriptionScoutAnnotation = new Text(this.m_containerAnnotation, 74);
        this.m_descriptionScoutAnnotation.setForeground(ScoutSdkUi.getDisplay().getSystemColor(16));
        this.m_descriptionScoutAnnotation.setText(Texts.get("DescriptionScoutWebServiceClientAnnotation", TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebServiceClient").getElementName()));
        this.m_authenticationHandlerField = this.getFieldToolkit().createStyledTextField(this.m_containerAnnotation, Texts.get("AuthenticationMechanism"));
        this.m_authenticationHandlerField.setText(this.getAuthenticationHandler());
        this.m_authenticationHandlerField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WsConsumerImplClassWizardPage.this.setAuthenticationHandlerInternal(WsConsumerImplClassWizardPage.this.m_authenticationHandlerField.getText());
                WsConsumerImplClassWizardPage.this.pingStateChanging();
            }
        });
        this.m_tooltipAuthenticationFactory = new JavadocTooltip((Control)this.m_authenticationHandlerField.getTextComponent());
        this.m_authenticationFactoryBrowseButton = new Button(this.m_containerAnnotation, 0x800008);
        this.m_authenticationFactoryBrowseButton.setText(Texts.get("Browse"));
        this.m_authenticationFactoryBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IJavaSearchScope searchScope = WsConsumerImplClassWizardPage.this.createSubClassesSearchScope(TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.consumer.IAuthenticationHandler"));
                    SelectionDialog dialog = JavaUI.createTypeDialog((Shell)ScoutSdkUi.getShell(), null, (IJavaSearchScope)searchScope, (int)2, (boolean)false, (String)"*.*");
                    dialog.setTitle(Texts.get("AuthenticationMechanism"));
                    dialog.setMessage(Texts.get("ChooseXY", Texts.get("AuthenticationMechanism")));
                    dialog.setBlockOnOpen(true);
                    if (dialog.open() == 0 && dialog.getResult() != null) {
                        IType type = (IType)dialog.getResult()[0];
                        WsConsumerImplClassWizardPage.this.setAuthenticationHandler(type.getFullyQualifiedName());
                    }
                }
                catch (JavaModelException exception) {
                    JaxWsSdk.logError(exception);
                }
            }
        });
        parent.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.m_typeNameField.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_typeNameField, 5, 1024);
        formData.left = new FormAttachment(0, 50);
        formData.right = new FormAttachment(100, -75);
        this.m_packageField.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_packageField, 0, 128);
        formData.left = new FormAttachment(100, -70);
        formData.right = new FormAttachment(100, 0);
        this.m_packageBrowseButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_packageField, 20, 1024);
        formData.left = new FormAttachment(40, 5);
        formData.right = new FormAttachment(100, 0);
        this.m_annotateImplButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_annotateImplButton, 5, 1024);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.m_containerAnnotation.setLayoutData((Object)formData);
        this.m_containerAnnotation.setLayout((Layout)new FormLayout());
        formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(40, 2);
        formData.right = new FormAttachment(100, 0);
        this.m_descriptionScoutAnnotation.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_descriptionScoutAnnotation, 10, 1024);
        formData.left = new FormAttachment(0, 50);
        formData.right = new FormAttachment(100, -75);
        this.m_authenticationHandlerField.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_authenticationHandlerField, 0, 128);
        formData.left = new FormAttachment(100, -70);
        formData.right = new FormAttachment(100, 0);
        this.m_authenticationFactoryBrowseButton.setLayoutData((Object)formData);
    }

    protected void validatePage(MultiStatus multiStatus) {
        if (this.m_bundle == null) {
            return;
        }
        this.validateType(multiStatus);
        if (this.isAnnotateImplClass()) {
            this.validateFactoryType(multiStatus, Texts.get("AuthenticationFactory"), this.getAuthenticationHandler(), TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.consumer.IAuthenticationHandler"));
        }
    }

    protected void validateType(MultiStatus multiStatus) {
        if (StringUtility.isNullOrEmpty((String)this.getPackageName())) {
            multiStatus.add((IStatus)new Status(2, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("UsageOfDefaultPackageDiscouraged")));
        } else {
            multiStatus.add(JavaConventionsUtil.validatePackageName((String)this.getPackageName(), (IJavaElement)this.m_bundle.getJavaProject()));
            String recommendedPackageName = JaxWsSdkUtility.getRecommendedConsumerImplPackageName(this.m_bundle);
            if (!this.getPackageName().equals(recommendedPackageName)) {
                multiStatus.add((IStatus)new Status(2, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("ByConventionXShouldByY", Texts.get("Package"), recommendedPackageName)));
            }
        }
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("WebServiceClient")) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("MissingNameForImplementingClass")));
        } else {
            multiStatus.add(JavaConventionsUtil.validateJavaTypeName((String)this.getTypeName(), (IJavaElement)this.m_bundle.getJavaProject()));
            if (Character.isLowerCase(this.getTypeName().charAt(0))) {
                multiStatus.add((IStatus)new Status(2, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("LowerCaseTypeName")));
            }
        }
        if (multiStatus.getSeverity() < 4) {
            String fullyQualifiedName = StringUtility.join((String)".", (String[])new String[]{this.getPackageName(), this.getTypeName()});
            try {
                if (TypeUtility.existsType((String)fullyQualifiedName)) {
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("TypeAlreadyExsits", fullyQualifiedName)));
                } else if (this.m_illegalTypeNames.contains(this.getTypeName())) {
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("AliasXAlreadyExists", this.getTypeName())));
                }
            }
            catch (Exception exception) {
                multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("InvalidJavaType", fullyQualifiedName)));
            }
        }
    }

    protected void validateFactoryType(MultiStatus multiStatus, String label, String qualifiedName, IType interfaceType) {
        if (StringUtility.isNullOrEmpty((String)qualifiedName)) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("NoClassSpecified", label)));
            return;
        }
        String packageName = Signature.getQualifier((String)qualifiedName);
        String className = StringUtility.isNullOrEmpty((String)packageName) ? qualifiedName : Signature.getSimpleName((String)qualifiedName);
        if (StringUtility.isNullOrEmpty((String)packageName)) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("UsageOfDefaultPackageNotAllowed")));
            return;
        }
        multiStatus.add(JavaConventionsUtil.validatePackageName((String)packageName, (IJavaElement)this.m_bundle.getJavaProject()));
        try {
            String fqn = StringUtility.join((String)".", (String[])new String[]{packageName, className});
            if (TypeUtility.existsType((String)fqn)) {
                IType type = TypeUtility.getType((String)fqn);
                if (!type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor()).contains(interfaceType)) {
                    type.getJavadocRange().getOffset();
                    type.getJavadocRange().getLength();
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("XMustBeOfTheTypeY", label, interfaceType.getFullyQualifiedName())));
                }
            } else {
                String recommendedPackageName = JaxWsSdkUtility.getRecommendedConsumerSecurityPackageName(this.m_bundle);
                if (!packageName.equals(recommendedPackageName)) {
                    multiStatus.add((IStatus)new Status(2, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("ByConventionXShouldByY", Texts.get(PROP_PACKAGE), recommendedPackageName)));
                }
            }
        }
        catch (Exception exception) {}
    }

    public void setTypeName(String typeName) {
        try {
            typeName = JaxWsSdkUtility.toStartWithUpperCase(typeName);
            this.setStateChanging(true);
            this.setTypeNameInternal(typeName);
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setTypeNameInternal(String typeName) {
        this.m_propertySupport.setProperty(PROP_TYPE_NAME, (Object)typeName);
    }

    public String getTypeName() {
        return this.m_propertySupport.getPropertyString(PROP_TYPE_NAME);
    }

    public void setPackageName(String packageName) {
        try {
            this.setStateChanging(true);
            this.setPackageNameInternal(packageName);
            if (this.isControlCreated()) {
                this.m_packageField.setText(packageName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setPackageNameInternal(String packageName) {
        this.m_propertySupport.setPropertyString(PROP_PACKAGE, packageName);
    }

    public String getPackageName() {
        return this.m_propertySupport.getPropertyString(PROP_PACKAGE);
    }

    public void setAnnotateImplClass(boolean annotateImplClass) {
        try {
            this.setStateChanging(true);
            this.setAnnotateImplClassInternal(annotateImplClass);
            if (this.isControlCreated()) {
                this.m_annotateImplButton.setSelection(annotateImplClass);
                JaxWsSdkUtility.setView(this.m_containerAnnotation, annotateImplClass);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setAnnotateImplClassInternal(boolean annotateImplClass) {
        this.m_propertySupport.setProperty(PROP_ANNOTATE_IMPL, (Object)annotateImplClass);
    }

    public boolean isAnnotateImplClass() {
        return this.m_propertySupport.getPropertyBool(PROP_ANNOTATE_IMPL);
    }

    public void setAuthenticationHandler(String authenticationHandler) {
        try {
            this.setStateChanging(true);
            this.setAuthenticationHandlerInternal(authenticationHandler);
            if (this.isControlCreated()) {
                this.m_authenticationHandlerField.setText(authenticationHandler);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setAuthenticationHandlerInternal(String authenticationHandler) {
        this.m_propertySupport.setPropertyString(PROP_AUTHENTICATION_HANDLER, authenticationHandler);
        if (this.isControlCreated()) {
            this.m_tooltipAuthenticationFactory.setMember(null);
            if (TypeUtility.existsType((String)authenticationHandler)) {
                IType type = TypeUtility.getType((String)authenticationHandler);
                try {
                    if (type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor()).contains(TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.consumer.IAuthenticationHandler"))) {
                        this.m_tooltipAuthenticationFactory.setMember((IMember)type);
                    }
                }
                catch (Exception e) {
                    JaxWsSdk.logWarning("Could not render tooltip", e);
                }
            }
        }
    }

    public String getAuthenticationHandler() {
        return this.m_propertySupport.getPropertyString(PROP_AUTHENTICATION_HANDLER);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.addPropertyChangeListener(listener);
        super.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.removePropertyChangeListener(listener);
        super.removePropertyChangeListener(listener);
    }

    private IPackageFragment[] openBrowsePackagesDialog() {
        IPackageFragment[] packageFragments = null;
        BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
        SelectionDialog dialog = JavaUI.createPackageDialog((Shell)ScoutSdkUi.getShell(), (IRunnableContext)context, (IJavaSearchScope)this.m_bundle.getSearchScope(), (boolean)false, (boolean)true, null);
        dialog.setTitle(Texts.get("Package"));
        dialog.setMessage(Texts.get("ChoosePackageForWsConsumer"));
        if (dialog.open() == 0 && dialog.getResult() != null) {
            packageFragments = Arrays.asList(dialog.getResult()).toArray(new IPackageFragment[0]);
        }
        if (packageFragments != null) {
            return packageFragments;
        }
        return null;
    }

    private Set<String> getIllegalTypeNames() {
        HashSet<String> illegalTypeNames = new HashSet<String>();
        XmlResource buildJaxWsResource = ResourceFactory.getBuildJaxWsResource(this.m_bundle);
        ScoutXmlDocument xmlDocument = buildJaxWsResource.loadXml();
        if (!buildJaxWsResource.existsFile()) {
            return illegalTypeNames;
        }
        if (xmlDocument.getRoot().hasChild("consumer")) {
            ScoutXmlDocument.ScoutXmlElement[] xmlElements;
            ScoutXmlDocument.ScoutXmlElement[] scoutXmlElementArray = xmlElements = (ScoutXmlDocument.ScoutXmlElement[])TypeCastUtility.castValue((Object)xmlDocument.getRoot().getChildren("consumer"), ScoutXmlDocument.ScoutXmlElement[].class);
            int n = xmlElements.length;
            int n2 = 0;
            while (n2 < n) {
                ScoutXmlDocument.ScoutXmlElement xmlElement = scoutXmlElementArray[n2];
                illegalTypeNames.add(xmlElement.getAttribute(PROP_TYPE_NAME));
                ++n2;
            }
        }
        return illegalTypeNames;
    }

    private IJavaSearchScope createSubClassesSearchScope(IType superType) {
        IType[] subTypes = JaxWsSdkUtility.getJdtSubTypes(this.m_bundle, superType.getFullyQualifiedName(), false, false, true, false);
        return SearchEngine.createJavaSearchScope((IJavaElement[])subTypes);
    }
}

