/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.util;

import com.sun.xml.internal.bind.api.impl.NameConverter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jws.WebService;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceClient;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.search.TypeDeclarationMatch;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.OrganizeImportsOperation;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.FolderSelectionDialog;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.xmlparser.ScoutXmlDocument;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.part.ISection;
import org.eclipse.scout.sdk.util.ResourcesUtility;
import org.eclipse.scout.sdk.util.pde.PluginModelHelper;
import org.eclipse.scout.sdk.util.signature.CompilationUnitImportValidator;
import org.eclipse.scout.sdk.util.signature.IImportValidator;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.operation.OverrideUnimplementedMethodsOperation;
import org.eclipse.scout.sdk.ws.jaxws.resource.XmlResource;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.part.AnnotationProperty;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class JaxWsSdkUtility {
    private JaxWsSdkUtility() {
    }

    public static boolean isValidJavaIdentifier(String identifier) {
        if (StringUtility.isNullOrEmpty((String)identifier)) {
            return false;
        }
        char[] chars = identifier.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (i == 0 ? !Character.isJavaIdentifierStart(chars[i]) : !Character.isJavaIdentifierPart(chars[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean exists(IResource resource) {
        JaxWsSdkUtility.refreshLocal(resource, 1);
        return resource != null && resource.exists() && resource.isSynchronized(1);
    }

    public static void refreshLocal(IResource resource, int depth) {
        try {
            if (resource != null && !resource.isSynchronized(depth)) {
                resource.refreshLocal(depth, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException coreException) {
            JaxWsSdk.logWarning("The 'resource '" + resource.getFullPath().toPortableString() + "' could not be synchronized with the filesystem.");
        }
    }

    public static IFile toFile(IScoutBundle bundle, File file) {
        if (bundle == null || file == null) {
            return null;
        }
        IPath path = new Path(file.getAbsolutePath()).makeRelativeTo(bundle.getProject().getLocation());
        return JaxWsSdkUtility.getFile(bundle, path.toPortableString(), false);
    }

    public static File toFile(IFile file) {
        if (file == null) {
            return null;
        }
        return new File(file.getLocationURI());
    }

    public static IFile getFile(IScoutBundle scoutBundle, String path, boolean autoCreate) {
        return JaxWsSdkUtility.getFile(scoutBundle, null, path, autoCreate);
    }

    public static IFile getFile(IScoutBundle scoutBundle, String projectRelativePath, String fileName, boolean autoCreate) {
        Path path;
        if (fileName == null) {
            return null;
        }
        if (StringUtility.isNullOrEmpty((String)projectRelativePath)) {
            path = new Path(fileName);
        } else {
            projectRelativePath = JaxWsSdkUtility.normalizePath(projectRelativePath, SeparatorType.BothType);
            path = new Path(String.valueOf(projectRelativePath) + fileName);
        }
        IFile file = scoutBundle.getProject().getFile((IPath)path);
        JaxWsSdkUtility.prepareFileAccess(file, autoCreate);
        return file;
    }

    public static void prepareFileAccess(IFile file, boolean autoCreate) {
        IFolder folder;
        JaxWsSdkUtility.refreshLocal((IResource)file, 0);
        if (!JaxWsSdkUtility.exists((IResource)file) && autoCreate) {
            try {
                if (file.getParent() instanceof IFolder) {
                    ResourcesUtility.mkdirs((IContainer)file.getParent(), (IProgressMonitor)new NullProgressMonitor());
                }
                ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[0]);
                file.create((InputStream)inputStream, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                throw new RuntimeException("An unexpected error occured while creating empty file", e);
            }
        }
        if (autoCreate && file.getParent() instanceof IFolder && !(folder = (IFolder)file.getParent()).getProjectRelativePath().toPortableString().contains("build")) {
            try {
                PluginModelHelper h = new PluginModelHelper(file.getProject());
                h.BuildProperties.addBinaryBuildEntry((IResource)folder);
                h.save();
            }
            catch (CoreException e) {
                JaxWsSdk.logError("failed to register folder in build.properties", e);
            }
        }
    }

    public static IFolder getFolder(IScoutBundle scoutBundle, String projectRelativePath, boolean autoCreate) {
        if (StringUtility.isNullOrEmpty((String)projectRelativePath)) {
            return null;
        }
        Path path = new Path(JaxWsSdkUtility.normalizePath(projectRelativePath, SeparatorType.BothType));
        IFolder folder = scoutBundle.getProject().getFolder((IPath)path);
        JaxWsSdkUtility.prepareFolderAccess(folder, autoCreate);
        return folder;
    }

    public static void prepareFolderAccess(IFolder folder, boolean autoCreate) {
        JaxWsSdkUtility.refreshLocal((IResource)folder, 2);
        if (!folder.exists() && autoCreate) {
            try {
                ResourcesUtility.mkdirs((IContainer)folder, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                throw new RuntimeException("An unexpected error occured while creating the report design file", e);
            }
        }
        if (autoCreate && !folder.getProjectRelativePath().toPortableString().contains("build")) {
            try {
                PluginModelHelper h = new PluginModelHelper(folder.getProject());
                h.BuildProperties.addBinaryBuildEntry((IResource)folder);
                h.save();
            }
            catch (CoreException e) {
                JaxWsSdk.logError("failed to register folder in build.properties", e);
            }
        }
    }

    public static void createImportDirective(IType declaringType, IType typeForImportDirective) {
        try {
            String resolveTypeName = JaxWsSdkUtility.resolveTypeName(declaringType, typeForImportDirective);
            if (resolveTypeName == null) {
                return;
            }
            if (typeForImportDirective.getFullyQualifiedName().equals(resolveTypeName)) {
                return;
            }
            declaringType.getCompilationUnit().createImport(typeForImportDirective.getFullyQualifiedName().replaceAll("\\$", "."), null, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception exception) {}
    }

    public static String getFullyQualifiedNameFromSignature(IType declaringType, String signature) {
        return JaxWsSdkUtility.getFullyQualifiedNameFromName(declaringType, StringUtility.join((String)".", (String[])new String[]{Signature.getSignatureQualifier((String)signature), Signature.getSignatureSimpleName((String)signature)}));
    }

    public static String getFullyQualifiedNameFromName(IType declaringType, String name) {
        try {
            String[][] fullyQualifiedSignature = declaringType.resolveType(name);
            if (fullyQualifiedSignature != null && fullyQualifiedSignature.length > 0) {
                if (!StringUtility.isNullOrEmpty((String)fullyQualifiedSignature[0][0])) {
                    return String.valueOf(fullyQualifiedSignature[0][0]) + "." + fullyQualifiedSignature[0][1];
                }
                return fullyQualifiedSignature[0][1];
            }
        }
        catch (Exception e) {
            JaxWsSdk.logError(e);
        }
        return null;
    }

    public static String getFullyQualifiedSignature(IType declaringType, String signature) {
        return Signature.createTypeSignature((String)JaxWsSdkUtility.getFullyQualifiedNameFromSignature(declaringType, signature), (boolean)true);
    }

    public static void organizeImports(IType type) {
        try {
            CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)type.getJavaProject());
            CompilationUnit astRoot = SharedASTProvider.getAST((ITypeRoot)type.getCompilationUnit(), (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_ACTIVE_ONLY, null);
            OrganizeImportsOperation.IChooseImportQuery chooseImportQuery = new OrganizeImportsOperation.IChooseImportQuery(){

                public TypeNameMatch[] chooseImports(TypeNameMatch[][] openChoices, ISourceRange[] ranges) {
                    return new TypeNameMatch[0];
                }
            };
            OrganizeImportsOperation op = new OrganizeImportsOperation(type.getCompilationUnit(), astRoot, settings.importIgnoreLowercase, !type.getCompilationUnit().isWorkingCopy(), true, chooseImportQuery);
            op.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Throwable e) {
            JaxWsSdk.logError(e);
        }
    }

    public static String getFileNameWithoutExtension(IFile file) {
        if (file.getFileExtension() != null) {
            return file.getName().substring(0, file.getName().length() - file.getFileExtension().length() - 1);
        }
        return file.getName();
    }

    public static String toStartWithLowerCase(String property) {
        if (!StringUtility.hasText((String)property)) {
            return null;
        }
        if (property.length() == 1) {
            return property.toLowerCase();
        }
        return String.valueOf(property.substring(0, 1).toLowerCase()) + property.substring(1);
    }

    public static String toStartWithUpperCase(String property) {
        if (!StringUtility.hasText((String)property)) {
            return null;
        }
        if (property.length() == 1) {
            return property.toUpperCase();
        }
        return String.valueOf(property.substring(0, 1).toUpperCase()) + property.substring(1);
    }

    public static String normalizePath(String path, SeparatorType separatorType) {
        if (path == null) {
            return null;
        }
        if (separatorType == SeparatorType.BothType || separatorType == SeparatorType.LeadingType) {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
        } else if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (separatorType == SeparatorType.BothType || separatorType == SeparatorType.TrailingType) {
            if (!path.endsWith("/")) {
                path = String.valueOf(path) + "/";
            }
        } else if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static void doLayout(Composite composite) {
        if (composite != null && !composite.isDisposed()) {
            if (composite.getLayoutData() instanceof GridData) {
                ((GridData)composite.getLayoutData()).heightHint = composite.getChildren().length == 0 ? 0 : -1;
            }
            composite.layout(true, true);
        }
    }

    public static void doLayoutSection(ISection section) {
        if (section.isExpanded()) {
            section.setExpanded(false);
            section.setExpanded(true);
        }
    }

    public static void disposeChildControls(Composite composite) {
        if (composite != null && !composite.isDisposed()) {
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.dispose();
                ++n2;
            }
        }
    }

    public static void setView(Composite composite, boolean enabled) {
        if (composite != null && !composite.isDisposed()) {
            composite.setEnabled(enabled);
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child instanceof Composite) {
                    JaxWsSdkUtility.setView((Composite)child, enabled);
                } else {
                    child.setEnabled(enabled);
                }
                ++n2;
            }
        }
    }

    public static Set<IResource> createResourceSet(IResource ... resources) {
        HashSet<IResource> resourceSet = new HashSet<IResource>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource != null) {
                resourceSet.add(resource);
            }
            ++n2;
        }
        return resourceSet;
    }

    public static PortType getPortType(Definition wsdlDefinition, QName serviceQName, String portName) {
        if (wsdlDefinition == null || serviceQName == null || portName == null) {
            return null;
        }
        portName = QName.valueOf(portName).getLocalPart();
        javax.wsdl.Service service = wsdlDefinition.getService(serviceQName);
        if (service == null) {
            return null;
        }
        Port port = service.getPort(portName);
        if (port == null) {
            return null;
        }
        Binding binding = port.getBinding();
        if (binding == null) {
            return null;
        }
        return port.getBinding().getPortType();
    }

    public static IType resolvePortTypeInterfaceType(QName portTypeQName, IFile jarFile) {
        if (portTypeQName == null) {
            return null;
        }
        IType[] types = JaxWsSdkUtility.resolvePortTypeInterfaceTypes(portTypeQName, jarFile);
        if (types.length == 0) {
            return null;
        }
        if (types.length > 1) {
            JaxWsSdk.logWarning("Multiple PortType interface types found for port type '" + portTypeQName + "'");
        }
        return types[0];
    }

    public static IType[] resolvePortTypeInterfaceTypes(final QName portTypeQName, IFile jarFile) {
        if (jarFile == null) {
            return new IType[0];
        }
        final HashSet types = new HashSet();
        try {
            new SearchEngine().search(SearchPattern.createPattern((String)"*", (int)6, (int)0, (int)2), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, (IJavaSearchScope)new JarFileSearchScope(jarFile), new SearchRequestor(){

                public final void acceptSearchMatch(SearchMatch match) throws CoreException {
                    IMemberValuePair[] properties;
                    if (!(match instanceof TypeDeclarationMatch)) {
                        return;
                    }
                    IType candidate = (IType)match.getElement();
                    if (!TypeUtility.exists((IJavaElement)candidate) || !candidate.isBinary()) {
                        return;
                    }
                    IAnnotation annotation = JaxWsSdkUtility.getAnnotation(candidate, WebService.class.getName(), false);
                    if (!TypeUtility.exists((IJavaElement)annotation)) {
                        return;
                    }
                    if (portTypeQName == null) {
                        types.add(candidate);
                        return;
                    }
                    IMemberValuePair[] iMemberValuePairArray = properties = annotation.getMemberValuePairs();
                    int n = properties.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMemberValuePair property = iMemberValuePairArray[n2];
                        if (property.getMemberName().equals("name") && property.getValue().equals(portTypeQName.getLocalPart())) {
                            types.add(candidate);
                            return;
                        }
                        ++n2;
                    }
                }
            }, null);
        }
        catch (Exception e) {
            JaxWsSdk.logError("Failed to resolve portType interface type", e);
        }
        return types.toArray(new IType[types.size()]);
    }

    public static IType resolveServiceType(QName serviceQName, IFile jarFile) {
        if (serviceQName == null) {
            return null;
        }
        IType[] types = JaxWsSdkUtility.resolveServiceTypes(serviceQName, jarFile);
        if (types.length == 0) {
            return null;
        }
        if (types.length > 1) {
            JaxWsSdk.logWarning("Multiple service types found for service '" + serviceQName + "'");
        }
        return types[0];
    }

    public static IType[] resolveServiceTypes(final QName serviceQName, IFile jarFile) {
        final HashSet types = new HashSet();
        try {
            new SearchEngine().search(SearchPattern.createPattern((String)"*", (int)0, (int)0, (int)2), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, (IJavaSearchScope)new JarFileSearchScope(jarFile), new SearchRequestor(){

                public final void acceptSearchMatch(SearchMatch match) throws CoreException {
                    IMemberValuePair[] properties;
                    if (!(match instanceof TypeDeclarationMatch)) {
                        return;
                    }
                    IType candidate = (IType)match.getElement();
                    if (!TypeUtility.exists((IJavaElement)candidate) || !candidate.isBinary()) {
                        return;
                    }
                    if (!candidate.isClass() || Flags.isAbstract((int)candidate.getFlags())) {
                        return;
                    }
                    if (!JaxWsSdkUtility.isJdtSubType(Service.class.getName(), candidate)) {
                        return;
                    }
                    IAnnotation annotation = JaxWsSdkUtility.getAnnotation(candidate, WebServiceClient.class.getName(), false);
                    if (!TypeUtility.exists((IJavaElement)annotation)) {
                        return;
                    }
                    if (serviceQName == null) {
                        types.add(candidate);
                        return;
                    }
                    IMemberValuePair[] iMemberValuePairArray = properties = annotation.getMemberValuePairs();
                    int n = properties.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMemberValuePair property = iMemberValuePairArray[n2];
                        if (property.getMemberName().equals("name") && property.getValue().equals(serviceQName.getLocalPart())) {
                            types.add(candidate);
                            return;
                        }
                        ++n2;
                    }
                }
            }, null);
        }
        catch (Exception e) {
            JaxWsSdk.logError("Failed to resolve portType interface type", e);
        }
        return types.toArray(new IType[types.size()]);
    }

    public static boolean isProviderAuthenticationSet(String fqn) {
        if (!StringUtility.hasText((String)fqn)) {
            return false;
        }
        fqn = fqn.replaceAll("\\$", "\\.");
        String noneAuthFqn = TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.provider.IAuthenticationHandler$NONE").getFullyQualifiedName().replaceAll("\\$", "\\.");
        return TypeUtility.existsType((String)fqn) && !fqn.equals(noneAuthFqn);
    }

    public static IType extractGenericSuperType(IType type, int index) {
        String[] typeArguments;
        block8: {
            String superTypeSignature;
            block7: {
                block6: {
                    try {
                        if (TypeUtility.exists((IJavaElement)type)) break block6;
                        return null;
                    }
                    catch (JavaModelException e) {
                        JaxWsSdk.logError("could not extract generic super type", e);
                        return null;
                    }
                }
                superTypeSignature = type.getSuperclassTypeSignature();
                if (superTypeSignature != null) break block7;
                return null;
            }
            typeArguments = Signature.getTypeArguments((String)superTypeSignature);
            if (typeArguments.length != 0 && index < typeArguments.length) break block8;
            return null;
        }
        String signature = typeArguments[index];
        String fullyQualifiedName = JaxWsSdkUtility.getFullyQualifiedNameFromSignature(type, signature);
        if (TypeUtility.existsType((String)fullyQualifiedName)) {
            return TypeUtility.getType((String)fullyQualifiedName);
        }
        return null;
    }

    public static QName extractServiceQNameFromWsClient(IType webserviceClientType) {
        IType serviceType = JaxWsSdkUtility.extractGenericSuperType(webserviceClientType, 0);
        if (!TypeUtility.exists((IJavaElement)serviceType)) {
            return null;
        }
        if (!JaxWsSdkUtility.isJdtSubType(Service.class.getName(), serviceType)) {
            return null;
        }
        IAnnotation annotation = JaxWsSdkUtility.getAnnotation(serviceType, WebServiceClient.class.getName(), false);
        return JaxWsSdkUtility.extractQNameFromAnnotation(annotation);
    }

    public static QName extractPortTypeQNameFromWsClient(IType webserviceClientType) {
        IType portTypeInterfaceType = JaxWsSdkUtility.extractGenericSuperType(webserviceClientType, 1);
        if (!TypeUtility.exists((IJavaElement)portTypeInterfaceType)) {
            return null;
        }
        IAnnotation annotation = JaxWsSdkUtility.getAnnotation(portTypeInterfaceType, WebService.class.getName(), false);
        return JaxWsSdkUtility.extractQNameFromAnnotation(annotation);
    }

    private static QName extractQNameFromAnnotation(IAnnotation annotation) {
        if (annotation == null || !annotation.exists()) {
            return null;
        }
        String localPart = null;
        String namespaceURI = null;
        try {
            IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
            int n = iMemberValuePairArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair pair = iMemberValuePairArray[n2];
                if (pair.getMemberName().equals("name")) {
                    localPart = (String)pair.getValue();
                } else if (pair.getMemberName().equals("targetNamespace")) {
                    namespaceURI = (String)pair.getValue();
                }
                if (namespaceURI != null && localPart != null) break;
                ++n2;
            }
            QName qname = null;
            if (namespaceURI != null && localPart != null) {
                qname = new QName(namespaceURI, localPart);
            } else if (localPart != null) {
                qname = new QName(localPart);
            }
            if (qname != null) {
                return qname;
            }
        }
        catch (Exception e) {
            JaxWsSdk.logError("could not extract QName from annotation '" + annotation.getElementName() + "'", e);
        }
        return null;
    }

    public static boolean hasPackageElements(IScoutBundle bundle, String sourceFolder, String packageName) {
        IPackageFragmentRoot root;
        block4: {
            if (!JaxWsSdkUtility.isValidSourceFolder(bundle, sourceFolder) || packageName == null) {
                return false;
            }
            try {
                IPath rootPath = bundle.getProject().getFullPath().append(sourceFolder);
                root = bundle.getJavaProject().findPackageFragmentRoot(rootPath);
                if (root != null && root.exists()) break block4;
                return false;
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        IPackageFragment packageFragment = root.getPackageFragment(StringUtility.nvl((Object)packageName, (String)""));
        return packageFragment != null && packageFragment.exists() && (packageFragment.hasChildren() || packageFragment.hasSubpackages());
    }

    public static IPackageFragment toPackageFragment(IScoutBundle bundle, String sourceFolder, String packageName) {
        IPackageFragmentRoot root;
        block6: {
            block5: {
                if (JaxWsSdkUtility.isValidSourceFolder(bundle, sourceFolder)) break block5;
                return null;
            }
            IPath rootPath = bundle.getProject().getFullPath().append(sourceFolder);
            root = bundle.getJavaProject().findPackageFragmentRoot(rootPath);
            if (root != null && root.exists()) break block6;
            return null;
        }
        try {
            IPackageFragment packageFragment = root.getPackageFragment(StringUtility.nvl((Object)packageName, (String)""));
            if (packageFragment != null && packageFragment.exists()) {
                return packageFragment;
            }
        }
        catch (JavaModelException e) {
            JaxWsSdk.logError("could not obtain package fragment", e);
        }
        return null;
    }

    public static void clearPackage(IScoutBundle bundle, String sourceFolder, String packageName) {
        try {
            IPackageFragment packageFragment = JaxWsSdkUtility.toPackageFragment(bundle, sourceFolder, packageName);
            if (packageFragment != null && packageFragment.exists()) {
                packageFragment.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (JavaModelException e) {
            JaxWsSdk.logError("could not clear package", e);
        }
    }

    public static void createSourceFolder(IScoutBundle bundle, String sourceFolder) throws JavaModelException {
        IClasspathEntry[] entries;
        LinkedList<IClasspathEntry> list = new LinkedList<IClasspathEntry>();
        IClasspathEntry[] iClasspathEntryArray = entries = bundle.getJavaProject().getRawClasspath();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && JaxWsSdkUtility.getFolder(bundle, sourceFolder, false).getFullPath().equals((Object)entry.getPath())) {
                return;
            }
            list.add(entry);
            ++n2;
        }
        IFolder srcFolder = JaxWsSdkUtility.getFolder(bundle, "/" + sourceFolder, true);
        IClasspathEntry newEntry = JavaCore.newSourceEntry((IPath)srcFolder.getFullPath());
        list.add(newEntry);
        bundle.getJavaProject().setRawClasspath(list.toArray(new IClasspathEntry[0]), bundle.getJavaProject().getOutputLocation(), (IProgressMonitor)new NullProgressMonitor());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidSourceFolder(IScoutBundle bundle, String sourceFolder) {
        if (sourceFolder == null) {
            return false;
        }
        try {
            IClasspathEntry[] iClasspathEntryArray = bundle.getJavaProject().getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
                if (classpathEntry.getEntryKind() == 3 && sourceFolder.equals(classpathEntry.getPath().lastSegment())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            JaxWsSdk.logError("Failed to validate source folder.", e);
        }
        return false;
    }

    public static String getPlainPortTypeName(String portTypeName) {
        if (portTypeName == null) {
            return null;
        }
        while (true) {
            if (portTypeName.toLowerCase().endsWith("porttype")) {
                portTypeName = portTypeName.substring(0, portTypeName.length() - "porttype".length());
                continue;
            }
            if (portTypeName.toLowerCase().endsWith("webservice")) {
                portTypeName = portTypeName.substring(0, portTypeName.length() - "webservice".length());
                continue;
            }
            if (!portTypeName.toLowerCase().endsWith("service")) break;
            portTypeName = portTypeName.substring(0, portTypeName.length() - "service".length());
        }
        return portTypeName;
    }

    public static String getRecommendedProviderImplPackageName(IScoutBundle bundle) {
        return StringUtility.join((String)".", (String[])new String[]{bundle.getBundleName(), "services", "ws", "provider"});
    }

    public static String getRecommendedHandlerPackageName(IScoutBundle bundle) {
        return StringUtility.join((String)".", (String[])new String[]{bundle.getBundleName(), "services", "ws", "handler"});
    }

    public static String getRecommendedConsumerImplPackageName(IScoutBundle bundle) {
        return StringUtility.join((String)".", (String[])new String[]{bundle.getBundleName(), "services", "ws", "consumer"});
    }

    public static String getRecommendedProviderSecurityPackageName(IScoutBundle bundle) {
        return StringUtility.join((String)".", (String[])new String[]{bundle.getBundleName(), "services", "ws", "provider", "security"});
    }

    public static String getRecommendedConsumerSecurityPackageName(IScoutBundle bundle) {
        return StringUtility.join((String)".", (String[])new String[]{bundle.getBundleName(), "services", "ws", "consumer", "security"});
    }

    public static String getRecommendedSessionPackageName(IScoutBundle bundle) {
        return StringUtility.join((String)".", (String[])new String[]{bundle.getBundleName(), "services", "ws", "session"});
    }

    public static String getRecommendedTargetNamespace(IScoutBundle bundle, String serviceName) {
        String[] segments = bundle.getBundleName().split("\\.");
        String projectSuffex = null;
        int i = segments.length - 1;
        while (i >= 0) {
            String segment = segments[i];
            if (!(segment.toLowerCase().equals("server") || segment.toLowerCase().equals("online") || segment.toLowerCase().equals("offline"))) {
                projectSuffex = StringUtility.join((String)".", (String[])new String[]{projectSuffex, segments[i]});
            }
            --i;
        }
        return "http://ws.services." + projectSuffex + "/" + serviceName + "/";
    }

    public static String resolveStubPackageName(Map<String, List<String>> buildProperties, Definition wsdlDefinition) {
        String globalPackageName = JaxWsSdkUtility.getBuildProperty(buildProperties, "p");
        if (!StringUtility.isNullOrEmpty((String)globalPackageName)) {
            return globalPackageName;
        }
        if (wsdlDefinition == null) {
            return null;
        }
        globalPackageName = JaxWsSdkUtility.getWsdlBindingPackageName(wsdlDefinition);
        if (!StringUtility.isNullOrEmpty((String)globalPackageName)) {
            return globalPackageName;
        }
        String targetNamespace = wsdlDefinition.getTargetNamespace();
        return JaxWsSdkUtility.targetNamespaceToPackageName(targetNamespace);
    }

    private static String getWsdlBindingPackageName(Definition definition) {
        if (definition == null) {
            return null;
        }
        for (Object e : definition.getExtensibilityElements()) {
            Element element;
            NodeList nodes;
            UnknownExtensibilityElement uee;
            if (!(e instanceof UnknownExtensibilityElement) || !(uee = (UnknownExtensibilityElement)e).getElementType().equals(new QName("http://java.sun.com/xml/ns/jaxws", "bindings")) || (nodes = (element = uee.getElement()).getElementsByTagNameNS("http://java.sun.com/xml/ns/jaxws", "package")).getLength() <= 0) continue;
            Element globalPackageBindingElement = (Element)nodes.item(0);
            return globalPackageBindingElement.getAttribute("name");
        }
        return null;
    }

    public static String targetNamespaceToPackageName(String targetNamespace) {
        if (targetNamespace == null) {
            return null;
        }
        NameConverter nameConverter = NameConverter.standard;
        try {
            return nameConverter.toPackageName(targetNamespace);
        }
        catch (Exception exception) {
            JaxWsSdk.logError("failed to convert targetNamespace into package name");
            return null;
        }
    }

    public static Binding getBinding(Definition wsdlDefinition, QName serviceQName, String portName) {
        if (wsdlDefinition == null || serviceQName == null || portName == null) {
            return null;
        }
        portName = QName.valueOf(portName).getLocalPart();
        javax.wsdl.Service service = wsdlDefinition.getService(serviceQName);
        if (service == null) {
            return null;
        }
        Port port = service.getPort(portName);
        if (port == null) {
            return null;
        }
        return port.getBinding();
    }

    public static IAnnotation getAnnotation(IType declaringType, String fqnAnnotationName, boolean recursively) {
        block6: {
            if (TypeUtility.exists((IJavaElement)declaringType)) break block6;
            return null;
        }
        try {
            IAnnotation[] annotations;
            IAnnotation[] iAnnotationArray = annotations = declaringType.getAnnotations();
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotation annotation = iAnnotationArray[n2];
                if (declaringType.isBinary() ? annotation.getElementName().equals(fqnAnnotationName) : annotation.getElementName().equals(fqnAnnotationName) || annotation.getElementName().equals(Signature.getSimpleName((String)fqnAnnotationName))) {
                    return annotation;
                }
                ++n2;
            }
            if (recursively) {
                IType superType = declaringType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor()).getSuperclass(declaringType);
                return JaxWsSdkUtility.getAnnotation(superType, fqnAnnotationName, recursively);
            }
        }
        catch (JavaModelException e) {
            JaxWsSdk.logError("failed to resolve annotations", e);
        }
        return null;
    }

    public static boolean isAnnotationOnDeclaringType(IType declaringType, IAnnotation annotation) {
        if (annotation == null || declaringType == null) {
            return false;
        }
        IJavaElement parent = annotation.getParent();
        if (parent.getElementType() != 7) {
            return false;
        }
        IType candidateType = (IType)parent;
        return candidateType.getFullyQualifiedName().equals(declaringType.getFullyQualifiedName());
    }

    public static Map<String, List<String>> getDefaultBuildProperties() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("Xdebug", null);
        map.put("keep", null);
        map.put("verbose", null);
        LinkedList<String> values = new LinkedList<String>();
        values.add("2.0");
        map.put("target", values);
        return map;
    }

    public static IFile[] getBindingFiles(IScoutBundle bundle, Map<String, List<String>> buildProperties) {
        if (buildProperties == null || buildProperties.size() == 0) {
            return new IFile[0];
        }
        LinkedList<IFile> bindingFiles = new LinkedList<IFile>();
        for (Map.Entry<String, List<String>> property : buildProperties.entrySet()) {
            if (property.getKey() == null || !property.getKey().equals("b") || property.getValue() == null || property.getValue().size() == 0) continue;
            for (String bindingFileRaw : property.getValue()) {
                IFile bindingFile = JaxWsSdkUtility.getFile(bundle, bindingFileRaw, false);
                bindingFiles.add(bindingFile);
            }
        }
        return bindingFiles.toArray(new IFile[bindingFiles.size()]);
    }

    public static void addBuildProperty(Map<String, List<String>> buildProperties, String propertyName, String propertyValue) {
        if (!buildProperties.containsKey(propertyName)) {
            buildProperties.put(propertyName, new LinkedList());
        }
        buildProperties.get(propertyName).add(propertyValue);
    }

    public static String getBuildProperty(Map<String, List<String>> buildProperties, String propertyName) {
        if (buildProperties == null || buildProperties.size() == 0) {
            return null;
        }
        for (Map.Entry<String, List<String>> property : buildProperties.entrySet()) {
            List<String> values;
            if (!CompareUtility.equals((Object)property.getKey(), (Object)propertyName) || (values = property.getValue()) == null || values.size() <= 0) continue;
            return values.get(0);
        }
        return null;
    }

    public static String toMarkerGroupUUID(String markerGroupUUID, int index) {
        return StringUtility.join((String)"_", (String[])new String[]{markerGroupUUID, String.valueOf(index)});
    }

    public static String createUniqueBindingFileNamePath(IScoutBundle bundle, String alias, String schemaTargetNamespace) {
        String bindingFileName;
        String filename = StringUtility.join((String)"-", (String[])new String[]{alias, schemaTargetNamespace, "bindings"});
        filename = JaxWsSdkUtility.toValidFileName(filename);
        String candiate = bindingFileName = String.valueOf(JaxWsSdkUtility.normalizePath("/WEB-INF/build", SeparatorType.TrailingType)) + filename;
        IFile file = JaxWsSdkUtility.getFile(bundle, String.valueOf(candiate) + ".xml", false);
        int i = 0;
        while (file != null && file.exists()) {
            candiate = String.valueOf(bindingFileName) + " (" + ++i + ")";
            file = JaxWsSdkUtility.getFile(bundle, String.valueOf(candiate) + ".xml", false);
        }
        return String.valueOf(candiate) + ".xml";
    }

    public static Color getColorLightGray() {
        Color color = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().get("lightGray");
        if (color == null) {
            PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().put("lightGray", new RGB(245, 245, 245));
            color = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().get("lightGray");
        }
        return color;
    }

    public static AnnotationProperty parseAnnotationTypeValue(IType declaringType, IAnnotation annotation, String property) {
        AnnotationProperty propertyValue = new AnnotationProperty();
        if (!TypeUtility.exists((IJavaElement)declaringType)) {
            return propertyValue;
        }
        if (!TypeUtility.exists((IJavaElement)annotation)) {
            return propertyValue;
        }
        try {
            IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
            int n = iMemberValuePairArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair pair = iMemberValuePairArray[n2];
                if (pair.getMemberName().equals(property)) {
                    String propertySignature = Signature.createTypeSignature((String)((String)pair.getValue()), (boolean)true);
                    String fullyQualifiedName = JaxWsSdkUtility.getFullyQualifiedNameFromSignature(declaringType, propertySignature);
                    propertyValue.setInherited(false);
                    propertyValue.setFullyQualifiedName(fullyQualifiedName);
                    return propertyValue;
                }
                ++n2;
            }
            propertyValue.setInherited(true);
            String fqnAnnotationType = JaxWsSdkUtility.getFullyQualifiedNameFromName(declaringType, annotation.getElementName());
            IType type = TypeUtility.getType((String)fqnAnnotationType);
            if (TypeUtility.exists((IJavaElement)type)) {
                propertyValue.setFullyQualifiedName((String)type.getMethod(property, new String[0]).getDefaultValue().getValue());
            }
            return propertyValue;
        }
        catch (JavaModelException e) {
            JaxWsSdk.logError("failed to parse annotation property value", e);
            return propertyValue;
        }
    }

    public static IType[] getJdtSubTypes(IScoutBundle bundle, String fqnSuperType, boolean includeInterfaces, boolean includeAbstractTypes, boolean includeFinalTypes, boolean sameProject) {
        LinkedList<IType> types = new LinkedList<IType>();
        try {
            IType[] superTypes;
            IType[] iTypeArray = superTypes = TypeUtility.getTypes((String)fqnSuperType);
            int n = superTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IType[] candidates;
                IType superType = iTypeArray[n2];
                ITypeHierarchy hierarchy = superType.newTypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                IType[] iTypeArray2 = candidates = hierarchy.getAllSubtypes(superType);
                int n3 = candidates.length;
                int n4 = 0;
                while (n4 < n3) {
                    IType candidate = iTypeArray2[n4];
                    if (!(!TypeUtility.exists((IJavaElement)candidate) || !includeInterfaces && Flags.isInterface((int)candidate.getFlags()) || !includeAbstractTypes && Flags.isAbstract((int)candidate.getFlags()) || !includeFinalTypes && Flags.isFinal((int)candidate.getFlags()) || sameProject && !bundle.getJavaProject().equals(candidate.getJavaProject()) || !TypeUtility.isOnClasspath((IMember)candidate, (IJavaProject)bundle.getJavaProject()))) {
                        types.add(candidate);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            JaxWsSdk.logError("failed to get subclasses of '" + fqnSuperType + "'", e);
        }
        JaxWsSdkUtility.sortTypesByName(types, true);
        return types.toArray(new IType[types.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isJdtSubType(String fqnSuperType, IType candidateToCheck) {
        if (candidateToCheck == null) {
            return false;
        }
        IType[] superTypes = TypeUtility.getTypes((String)fqnSuperType);
        try {
            ITypeHierarchy superTypeHierarchy = candidateToCheck.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            IType[] iTypeArray = superTypes;
            int n = superTypes.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IType superType = iTypeArray[n2];
                if (superTypeHierarchy.contains(superType)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            JaxWsSdk.logError(e);
        }
        return false;
    }

    public static String resolveTypeName(IType declaringType, IType typeToBeResolved) throws JavaModelException {
        String typeSignature = Signature.createTypeSignature((String)typeToBeResolved.getFullyQualifiedName(), (boolean)true);
        CompilationUnitImportValidator validator = new CompilationUnitImportValidator(declaringType.getCompilationUnit());
        return SignatureUtility.getTypeReference((String)typeSignature, (IType)declaringType, (IImportValidator)validator);
    }

    public static String toValidFileName(String name) {
        return name.replaceAll("[\\\\/\\:\\*\\?\\<\\>\"]", "");
    }

    public static boolean containsGlobalBindingSection(IScoutBundle bundle, Map<String, List<String>> propertiers, boolean checkForMultipleOccurences) {
        IFile[] bindingFiles = JaxWsSdkUtility.getBindingFiles(bundle, propertiers);
        LinkedList<XmlResource> bindingFileResources = new LinkedList<XmlResource>();
        IFile[] iFileArray = bindingFiles;
        int n = bindingFiles.length;
        int n2 = 0;
        while (n2 < n) {
            IFile bindingFile = iFileArray[n2];
            XmlResource xmlResource = new XmlResource(bundle);
            xmlResource.setFile(bindingFile);
            bindingFileResources.add(xmlResource);
            ++n2;
        }
        return JaxWsSdkUtility.containsGlobalBindingSection(bindingFileResources.toArray(new XmlResource[bindingFileResources.size()]), checkForMultipleOccurences);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean containsGlobalBindingSection(XmlResource[] bindingFileResources, boolean checkForMultipleOccurences) {
        int count = 0;
        try {
            XmlResource[] xmlResourceArray = bindingFileResources;
            int n = bindingFileResources.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                XmlResource bindingFileResource = xmlResourceArray[n2];
                ScoutXmlDocument xmlBindingFile = bindingFileResource.loadXml();
                List candidates = xmlBindingFile.getRoot().getDescendants("*:globalBindings");
                for (ScoutXmlDocument.ScoutXmlElement candidate : candidates) {
                    String prefix;
                    String namespace = candidate.getNamespace(prefix = candidate.getNamePrefix());
                    if (!namespace.equals("http://java.sun.com/xml/ns/jaxb")) continue;
                    if (!checkForMultipleOccurences) return true;
                    if (++count <= 1) break;
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    private static String getStubJarFilePath(String jarFileName) {
        if (jarFileName == null) {
            return null;
        }
        jarFileName = new Path(jarFileName).removeFileExtension().lastSegment();
        jarFileName = JaxWsSdkUtility.toValidFileName(jarFileName);
        String folder = JaxWsSdkUtility.normalizePath("ws-stub", SeparatorType.BothType);
        return StringUtility.join((String)"/", (String[])new String[]{folder, String.valueOf(jarFileName) + ".jar"});
    }

    public static IFile getStubJarFile(IScoutBundle bundle, BuildJaxWsBean buildJaxWsBean, String wsdlFileName) {
        Map<String, List<String>> buildProperties = null;
        if (buildJaxWsBean != null) {
            buildProperties = buildJaxWsBean.getPropertiers();
        }
        return JaxWsSdkUtility.getStubJarFile(bundle, buildProperties, wsdlFileName);
    }

    public static IFile getStubJarFile(IScoutBundle bundle, Map<String, List<String>> buildProperties, String wsdlFileName) {
        String customJarFileName;
        String jarFileName = null;
        if (buildProperties != null && StringUtility.hasText((String)(customJarFileName = JaxWsSdkUtility.getBuildProperty(buildProperties, "jar")))) {
            jarFileName = new Path(customJarFileName).removeFileExtension().lastSegment();
        }
        if (jarFileName == null && wsdlFileName != null) {
            jarFileName = new Path(wsdlFileName).removeFileExtension().lastSegment();
        }
        if (jarFileName == null) {
            JaxWsSdk.logWarning("Failed to derive stub JAR file name. Ensure WSDL file to exist or specify the build property 'jar' with the JAR file name as its value");
            return null;
        }
        String path = JaxWsSdkUtility.getStubJarFilePath(jarFileName);
        return JaxWsSdkUtility.getFile(bundle, path, false);
    }

    public static IScoutBundle getRootBundle(IScoutBundle serverBundle) {
        if (serverBundle.getType() != 5) {
            return null;
        }
        IScoutBundle bundle = serverBundle;
        while (bundle.getScoutProject().getParentProject() != null) {
            IScoutBundle candidate = bundle.getScoutProject().getParentProject().getServerBundle();
            if (candidate == null || !serverBundle.isOnClasspath(candidate)) break;
            bundle = bundle.getScoutProject().getParentProject().getServerBundle();
        }
        return bundle;
    }

    public static boolean registerJarLib(IScoutBundle bundle, IFile jarFile, boolean remove, IProgressMonitor monitor) {
        boolean success = true;
        JaxWsSdkUtility.refreshLocal((IResource)jarFile, 1);
        String jarFilePath = JaxWsSdkUtility.normalizePath(jarFile.getProjectRelativePath().toPortableString(), SeparatorType.None);
        IJavaProject javaProject = bundle.getJavaProject();
        IProject project = bundle.getProject();
        try {
            ArrayList<IClasspathEntry> cpeList = new ArrayList<IClasspathEntry>();
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry cpe = iClasspathEntryArray[n2];
                if (cpe.getEntryKind() == 1) {
                    if (!cpe.getPath().equals((Object)project.getFullPath().append(jarFilePath))) {
                        cpeList.add(cpe);
                    }
                } else {
                    cpeList.add(cpe);
                }
                ++n2;
            }
            if (!remove) {
                cpeList.add(JavaCore.newLibraryEntry((IPath)project.getFullPath().append(jarFilePath), null, null, (boolean)true));
            }
            javaProject.setRawClasspath(cpeList.toArray(new IClasspathEntry[cpeList.size()]), monitor);
        }
        catch (Exception e) {
            JaxWsSdk.logError("could not update Java class path in .classpath file", e);
        }
        PluginModelHelper h = new PluginModelHelper(project);
        try {
            if (remove) {
                h.Manifest.removeClasspathEntry((IResource)jarFile);
            } else {
                h.Manifest.addClasspathEntry((IResource)jarFile);
            }
            h.Manifest.addClasspathDefaultEntry();
        }
        catch (Exception e) {
            JaxWsSdk.logError("could not update Bundle-ClassPath in MANIFEST.MF", e);
            success = false;
        }
        try {
            h.BuildProperties.removeBinaryBuildEntry((IResource)jarFile);
            if (!remove) {
                h.BuildProperties.addBinaryBuildEntry((IResource)JaxWsSdkUtility.getParentFolder(bundle, jarFile));
            }
        }
        catch (Exception e) {
            JaxWsSdk.logError("could not update bin.includes in build.properties", e);
            success = false;
        }
        h.save();
        return success;
    }

    public static void overrideUnimplementedMethodsAsync(IType type) {
        OverrideUnimplementedMethodsOperation op = new OverrideUnimplementedMethodsOperation();
        op.setType(type);
        new OperationJob(new IOperation[]{op}).schedule();
    }

    public static <T> void removeDuplicateEntries(List<T> list) {
        HashSet<T> elementsVisited = new HashSet<T>();
        Iterator<T> iterator = list.iterator();
        while (iterator.hasNext()) {
            T element = iterator.next();
            if (elementsVisited.contains(element)) {
                iterator.remove();
            }
            elementsVisited.add(element);
        }
    }

    public static void sortTypesByName(List<IType> list, boolean removeDuplicates) {
        if (removeDuplicates) {
            JaxWsSdkUtility.removeDuplicateEntries(list);
        }
        Collections.sort(list, new Comparator<IType>(){

            @Override
            public int compare(IType type1, IType type2) {
                return CompareUtility.compareTo((Comparable)((Object)type1.getElementName()), (Comparable)((Object)type2.getElementName()));
            }
        });
    }

    public static IFolder getParentFolder(IScoutBundle bundle, IFile file) {
        if (file == null) {
            return null;
        }
        IPath parentFolderPath = file.getProjectRelativePath().removeLastSegments(1);
        if (parentFolderPath.segmentCount() == 0) {
            return null;
        }
        return JaxWsSdkUtility.getFolder(bundle, parentFolderPath.toPortableString(), false);
    }

    public static IFolder openProjectFolderDialog(IScoutBundle bundle, ViewerFilter filter, String title, String description, IFolder rootFolder, IFolder initialFolder) {
        if (!JaxWsSdkUtility.exists((IResource)rootFolder)) {
            rootFolder = JaxWsSdkUtility.getFolder(bundle, rootFolder.getProjectRelativePath().toPortableString(), true);
        }
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
        FolderSelectionDialog dialog = new FolderSelectionDialog(ScoutSdkUi.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setTitle(title);
        dialog.setMessage(description);
        dialog.addFilter(filter);
        dialog.setHelpAvailable(false);
        dialog.setAllowMultiple(false);
        if (initialFolder != null) {
            dialog.setInitialSelection((Object)initialFolder);
        }
        String parentFolderPath = rootFolder.getProjectRelativePath().removeLastSegments(1).toPortableString();
        dialog.setInput((Object)JaxWsSdkUtility.getFolder(bundle, parentFolderPath, true));
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        if (dialog.open() == 0) {
            return (IFolder)dialog.getFirstResult();
        }
        return null;
    }

    private static class JarFileSearchScope
    implements IJavaSearchScope {
        private IFile m_jarFile;

        public JarFileSearchScope(IFile jarFile) {
            this.m_jarFile = jarFile;
        }

        public boolean encloses(String resourcePath) {
            return true;
        }

        public boolean encloses(IJavaElement element) {
            return element.getElementType() == 7;
        }

        public IPath[] enclosingProjectsAndJars() {
            return new IPath[]{this.m_jarFile.getFullPath()};
        }

        public boolean includesBinaries() {
            return true;
        }

        public boolean includesClasspaths() {
            return false;
        }

        public void setIncludesBinaries(boolean includesBinaries) {
        }

        public void setIncludesClasspaths(boolean includesClasspaths) {
        }
    }

    public static enum SeparatorType {
        LeadingType,
        TrailingType,
        BothType,
        None;

    }

    private static class TypeEntry {
        private IType m_sourceType;
        private IType m_binaryType;

        private TypeEntry() {
        }

        public IType getSourceType() {
            return this.m_sourceType;
        }

        public void setSourceType(IType sourceType) {
            this.m_sourceType = sourceType;
        }

        public IType getBinaryType() {
            return this.m_binaryType;
        }

        public void setBinaryType(IType binaryType) {
            this.m_binaryType = binaryType;
        }
    }
}

