/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.marker.commands;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.scout.sdk.operation.util.SourceFormatOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.log.ScoutStatus;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.AbstractExecutableMarkerCommand;
import org.eclipse.scout.sdk.ws.jaxws.swt.dialog.TypeSelectionDialog;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceConsumerNodePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceProviderNodePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WebserviceEnum;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.text.edits.ReplaceEdit;
import org.osgi.framework.BundleActivator;

public class ErrorProneWsdlLocatorCommand
extends AbstractExecutableMarkerCommand {
    private IScoutBundle m_bundle;
    private IInitializer m_initializer;
    private String m_projectRelativeWsdlPath;
    private String m_staticMemberName;
    private IType m_activator;
    private String m_markerGroupUUID;
    private WebserviceEnum m_webserviceEnum;

    public ErrorProneWsdlLocatorCommand(IScoutBundle bundle, IInitializer initializer, String projectRelativeWsdlPath, String staticMemberName, String markerGroupUUID, WebserviceEnum webserviceEnum) {
        super("Fix problem to load WSDL resource");
        this.m_bundle = bundle;
        this.m_initializer = initializer;
        this.m_projectRelativeWsdlPath = projectRelativeWsdlPath;
        this.m_staticMemberName = staticMemberName;
        this.m_markerGroupUUID = markerGroupUUID;
        this.m_webserviceEnum = webserviceEnum;
        this.setSolutionDescription("By using this task, the locator code is changed to use the bundle's class loader instead.");
    }

    @Override
    public boolean prepareForUi() throws CoreException {
        IType[] activators = this.findActivator();
        if (activators.length == 0) {
            MessageBox messageBox = new MessageBox(ScoutSdkUi.getShell(), 36);
            messageBox.setText(Texts.get("Error"));
            messageBox.setMessage("Unable to find bundle's activator class");
            messageBox.open();
            return false;
        }
        if (activators.length == 1) {
            this.m_activator = activators[0];
            return true;
        }
        TypeSelectionDialog dialog = new TypeSelectionDialog(ScoutSdkUi.getShell(), "Activator selection", "Which Activator should be used to search for resources with it's bundle's classloader?");
        dialog.setElements(Arrays.asList(activators));
        if (dialog.open() == 0) {
            this.m_activator = (IType)dialog.getElement();
            return TypeUtility.exists((IJavaElement)this.m_activator);
        }
        return false;
    }

    @Override
    public void execute(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        ICompilationUnit icu = this.m_initializer.getDeclaringType().getCompilationUnit();
        IType declaringType = this.m_initializer.getDeclaringType();
        workingCopyManager.register(icu, monitor);
        String resolvedActivatorName = JaxWsSdkUtility.resolveTypeName(declaringType, this.m_activator);
        StringBuffer buf = new StringBuffer();
        try {
            String oldCode = this.m_initializer.getSource();
            buf.append("/*\n").append(" *").append(" This is a fix by Eclipse Scout SDK to use bundle's classloader to locate WSDL file.\n").append(" * The uncommented static initializer code originates by JAX-WS stub generation process.\n").append(" */\n");
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new StringReader(oldCode));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    buf.append("// ").append(line).append("\n");
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException e) {
            JaxWsSdk.logError(e);
        }
        buf.append("static {\n");
        buf.append("URL url = " + resolvedActivatorName + ".getDefault().getBundle().getResource(\"" + this.m_projectRelativeWsdlPath + "\");\n");
        buf.append("if (url == null) {\n");
        buf.append("  logger.warning(\"Failed to create URL for the wsdl Location: '" + this.m_projectRelativeWsdlPath + "', retrying as a local file\");\n");
        buf.append("}\n");
        buf.append(String.valueOf(this.m_staticMemberName) + " = url;\n");
        buf.append("}");
        Document icuDoc = new Document(declaringType.getCompilationUnit().getBuffer().getContents());
        ReplaceEdit edit = new ReplaceEdit(this.m_initializer.getSourceRange().getOffset(), this.m_initializer.getSourceRange().getLength(), buf.toString());
        try {
            edit.apply((IDocument)icuDoc);
        }
        catch (BadLocationException e) {
            throw new CoreException((IStatus)new ScoutStatus("Failed to update static initializer. [type=" + declaringType.getElementName() + "]", (Throwable)e));
        }
        SourceFormatOperation sourceFormatOp = new SourceFormatOperation(declaringType.getJavaProject(), icuDoc, null);
        sourceFormatOp.run(monitor, workingCopyManager);
        icu.getBuffer().setContents(ScoutUtility.cleanLineSeparator((String)icuDoc.get(), (Document)icuDoc));
        JaxWsSdkUtility.createImportDirective(declaringType, this.m_activator);
        workingCopyManager.reconcile(declaringType.getCompilationUnit(), monitor);
        workingCopyManager.unregister(icu, monitor);
        if (this.m_webserviceEnum == WebserviceEnum.Provider) {
            JaxWsSdk.getDefault().notifyPageReload(WebServiceProviderNodePage.class, this.m_markerGroupUUID, 16);
        } else {
            JaxWsSdk.getDefault().notifyPageReload(WebServiceConsumerNodePage.class, this.m_markerGroupUUID, 8);
        }
    }

    public IType[] findActivator() {
        IType bundleActivator = TypeUtility.getType((String)BundleActivator.class.getName());
        IPrimaryTypeTypeHierarchy hierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)bundleActivator);
        IType[] types = hierarchy.getAllSubtypes(bundleActivator, new ITypeFilter(){

            public boolean accept(IType type) {
                block5: {
                    block4: {
                        try {
                            if (TypeUtility.exists((IJavaElement)type)) break block4;
                            return false;
                        }
                        catch (JavaModelException e) {
                            JaxWsSdk.logError("could not determine bundle's activator properly", e);
                            return false;
                        }
                    }
                    if (!Flags.isAbstract((int)type.getFlags())) break block5;
                    return false;
                }
                return ErrorProneWsdlLocatorCommand.this.m_bundle.contains((IJavaElement)type);
            }
        });
        return types;
    }

    public IType getActivator() {
        return this.m_activator;
    }

    public void setActivator(IType activator) {
        this.m_activator = activator;
    }
}

