/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.marker.commands;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.xmlparser.ScoutXmlDocument;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.AbstractExecutableMarkerCommand;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WebserviceEnum;

public class MissingBuildJaxWsEntryCommand
extends AbstractExecutableMarkerCommand {
    private IScoutBundle m_bundle;
    private String m_alias;
    private WebserviceEnum m_webserviceEnum;

    public MissingBuildJaxWsEntryCommand(IScoutBundle bundle, String alias, WebserviceEnum webserviceEnum) {
        super("Missing entry in /WEB-INF/build/build-jaxws.xml");
        this.m_bundle = bundle;
        this.m_alias = alias;
        this.m_webserviceEnum = webserviceEnum;
        this.setSolutionDescription("By using this task, the missing entry is created for the webservice '" + alias + "'.");
    }

    @Override
    public void execute(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        ScoutXmlDocument xmlDocument = ResourceFactory.getBuildJaxWsResource(this.m_bundle).loadXml();
        ScoutXmlDocument.ScoutXmlElement xml = this.m_webserviceEnum == WebserviceEnum.Provider ? xmlDocument.getRoot().addChild("provider") : xmlDocument.getRoot().addChild("consumer");
        BuildJaxWsBean bean = new BuildJaxWsBean(xml, this.m_webserviceEnum);
        bean.setAlias(this.m_alias);
        ResourceFactory.getBuildJaxWsResource(this.m_bundle).storeXml(bean.getXml().getDocument(), 4, monitor, this.m_alias);
    }
}

