/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.operation;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.xmlparser.ScoutXmlDocument;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.util.pde.PluginModelHelper;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutBundleFilter;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.operation.BuildJaxWsFileCreateOperation;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.resource.XmlResource;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.ServletRegistrationUtility;

public class JaxWsServletRegistrationOperation
implements IOperation {
    private IScoutBundle m_bundle;
    private IScoutBundle m_registrationBundle;
    private String m_jaxWsAlias;
    private SunJaxWsBean m_sunJaxWsBean;
    private String m_urlPattern;

    public void validate() throws IllegalArgumentException {
        if (this.m_bundle == null) {
            throw new IllegalArgumentException("bundle must not be null");
        }
        if (this.m_bundle.getType() != 5) {
            throw new IllegalArgumentException("bundle must be SERVER bundle");
        }
        if (this.m_registrationBundle == null) {
            throw new IllegalArgumentException("servlet registration bundle must not be null");
        }
        if (this.m_registrationBundle.getType() != 5) {
            throw new IllegalArgumentException("servlet registration bundle must be SERVER bundle");
        }
        if (!StringUtility.hasText((String)this.m_jaxWsAlias)) {
            throw new IllegalArgumentException("JAX-WS alias must not be null");
        }
    }

    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        IPluginAttribute attribute;
        ScoutXmlDocument document;
        ScoutXmlDocument.ScoutXmlElement xml;
        String oldServletRegBundleName = null;
        XmlResource buildJaxWsResource = ResourceFactory.getBuildJaxWsResource(this.m_bundle);
        if (!JaxWsSdkUtility.exists((IResource)buildJaxWsResource.getFile())) {
            BuildJaxWsFileCreateOperation op = new BuildJaxWsFileCreateOperation(this.m_bundle);
            op.run(monitor, workingCopyManager);
        }
        if ((xml = (document = buildJaxWsResource.loadXml()).getRoot().getChild("servlet-bundle")) == null) {
            xml = document.getRoot().addChild("servlet-bundle");
        }
        if (xml.hasAttribute("name")) {
            oldServletRegBundleName = xml.getAttribute("name");
            xml.removeAttribute("name");
        }
        xml.setAttribute("name", this.m_registrationBundle.getBundleName());
        ResourceFactory.getBuildJaxWsResource(this.m_bundle, true).storeXml(xml.getDocument(), 2, monitor, "");
        String jaxWsServletClass = TypeUtility.getType((String)"org.eclipse.scout.jaxws.JaxWsServlet").getFullyQualifiedName();
        String alias = StringUtility.trim((String)JaxWsSdkUtility.normalizePath(this.m_jaxWsAlias, JaxWsSdkUtility.SeparatorType.LeadingType));
        PluginModelHelper h = new PluginModelHelper(this.m_registrationBundle.getProject());
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("class", jaxWsServletClass);
        IPluginElement ext = h.PluginXml.getSimpleExtension("org.eclipse.equinox.http.registry.servlets", "servlet", attributes);
        String originalAlias = null;
        if (ext != null && (attribute = ext.getAttribute("alias")) != null) {
            originalAlias = attribute.getValue();
        }
        if (CompareUtility.equals((Object)oldServletRegBundleName, (Object)this.m_bundle.getBundleName())) {
            PluginModelHelper oldPluginHelper = new PluginModelHelper(this.m_bundle.getProject());
            attributes = new HashMap();
            attributes.put("class", jaxWsServletClass);
            oldPluginHelper.PluginXml.removeSimpleExtension("org.eclipse.equinox.http.registry.servlets", "servlet", attributes);
            oldPluginHelper.save();
        }
        attributes = new HashMap();
        attributes.put("class", jaxWsServletClass);
        h = new PluginModelHelper(this.m_registrationBundle.getProject());
        h.PluginXml.removeSimpleExtension("org.eclipse.equinox.http.registry.servlets", "servlet", attributes);
        attributes = new HashMap();
        attributes.put("class", jaxWsServletClass);
        attributes.put("alias", alias);
        h.PluginXml.addSimpleExtension("org.eclipse.equinox.http.registry.servlets", "servlet", attributes);
        h.save();
        try {
            IScoutBundle[] candidateBundles;
            IScoutBundle[] iScoutBundleArray = candidateBundles = this.m_registrationBundle.getDependentBundles(new IScoutBundleFilter(){

                public boolean accept(IScoutBundle bundle) {
                    return bundle.getType() == 5 && TypeUtility.isOnClasspath((IMember)TypeUtility.getType((String)"org.eclipse.scout.jaxws.Activator"), (IJavaProject)bundle.getJavaProject());
                }
            }, true);
            int n = candidateBundles.length;
            int n2 = 0;
            while (n2 < n) {
                ScoutXmlDocument sunJaxWsXmlDocument;
                String bundleNameOfRegistration;
                IScoutBundle candidateBundle = iScoutBundleArray[n2];
                XmlResource sunJaxWsResource = ResourceFactory.getSunJaxWsResource(candidateBundle);
                buildJaxWsResource = ResourceFactory.getBuildJaxWsResource(candidateBundle);
                if (JaxWsSdkUtility.exists((IResource)buildJaxWsResource.getFile()) && JaxWsSdkUtility.exists((IResource)sunJaxWsResource.getFile()) && (bundleNameOfRegistration = ServletRegistrationUtility.getBuildJaxServletRegistrationBundleName(candidateBundle)) != null && bundleNameOfRegistration.equals(this.m_registrationBundle.getBundleName()) && (sunJaxWsXmlDocument = sunJaxWsResource.loadXml()) != null) {
                    ArrayList<String> changedEntries = new ArrayList<String>();
                    for (Object sunJaxWsXmlEntry : sunJaxWsXmlDocument.getRoot().getChildren(StringUtility.join((String)":", (String[])new String[]{sunJaxWsXmlDocument.getRoot().getNamePrefix(), "endpoint"}))) {
                        SunJaxWsBean sunJaxWsEntryBean = new SunJaxWsBean((ScoutXmlDocument.ScoutXmlElement)sunJaxWsXmlEntry);
                        changedEntries.add(sunJaxWsEntryBean.getAlias());
                        String endpointPattern = sunJaxWsEntryBean.getUrlPattern();
                        if (originalAlias != null && endpointPattern.startsWith(originalAlias)) {
                            endpointPattern = endpointPattern.substring(originalAlias.length());
                        }
                        String urlPattern = String.valueOf(JaxWsSdkUtility.normalizePath(this.m_jaxWsAlias, JaxWsSdkUtility.SeparatorType.BothType)) + JaxWsSdkUtility.normalizePath(endpointPattern, JaxWsSdkUtility.SeparatorType.None);
                        sunJaxWsEntryBean.setUrlPattern(urlPattern);
                    }
                    if (changedEntries.size() > 0) {
                        sunJaxWsResource.storeXmlAsync(sunJaxWsXmlDocument, 32, changedEntries.toArray(new String[changedEntries.size()]));
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            JaxWsSdk.logError("faild to update URL-pattern", e);
        }
        if (this.m_sunJaxWsBean != null && this.m_urlPattern != null) {
            String urlPattern = this.m_urlPattern;
            if (!JaxWsSdkUtility.normalizePath(this.m_urlPattern, JaxWsSdkUtility.SeparatorType.LeadingType).startsWith(JaxWsSdkUtility.normalizePath(this.m_jaxWsAlias, JaxWsSdkUtility.SeparatorType.LeadingType))) {
                urlPattern = String.valueOf(JaxWsSdkUtility.normalizePath(this.m_jaxWsAlias, JaxWsSdkUtility.SeparatorType.LeadingType)) + JaxWsSdkUtility.normalizePath(this.m_urlPattern, JaxWsSdkUtility.SeparatorType.LeadingType);
            }
            this.m_sunJaxWsBean.setUrlPattern(urlPattern);
            ResourceFactory.getSunJaxWsResource(this.m_bundle).storeXmlAsync(this.m_sunJaxWsBean.getXml().getDocument(), 32, this.m_sunJaxWsBean.getAlias());
        }
    }

    public static IScoutBundleFilter getServerFilter() {
        return new IScoutBundleFilter(){

            public boolean accept(IScoutBundle bundle) {
                return bundle.getType() == 5;
            }
        };
    }

    public String getOperationName() {
        return JaxWsServletRegistrationOperation.class.getName();
    }

    public IScoutBundle getBundle() {
        return this.m_bundle;
    }

    public void setBundle(IScoutBundle bundle) {
        this.m_bundle = bundle;
    }

    public IScoutBundle getRegistrationBundle() {
        return this.m_registrationBundle;
    }

    public void setRegistrationBundle(IScoutBundle registrationBundle) {
        this.m_registrationBundle = registrationBundle;
    }

    public String getJaxWsAlias() {
        return this.m_jaxWsAlias;
    }

    public void setJaxWsAlias(String jaxWsAlias) {
        this.m_jaxWsAlias = jaxWsAlias;
    }

    public String getUrlPattern() {
        return this.m_urlPattern;
    }

    public void setUrlPattern(String urlPattern) {
        this.m_urlPattern = urlPattern;
    }

    public SunJaxWsBean getSunJaxWsBean() {
        return this.m_sunJaxWsBean;
    }

    public void setSunJaxWsBean(SunJaxWsBean sunJaxWsBean) {
        this.m_sunJaxWsBean = sunJaxWsBean;
    }
}

