/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.resource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.util.log.ScoutStatus;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.resource.ManagedResource;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;

public class WsdlResource
extends ManagedResource {
    private Definition m_wsdlDefinition;

    public WsdlResource(IScoutBundle bundle) {
        super(bundle.getProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Definition loadWsdlDefinition() {
        Object object = this.m_fileLock;
        synchronized (object) {
            block7: {
                if (this.existsFile()) break block7;
                this.m_wsdlDefinition = null;
                return null;
            }
            if (this.m_wsdlDefinition == null || this.m_file.getModificationStamp() != this.m_modificationStamp) {
                this.m_modificationStamp = this.m_file.getModificationStamp();
                this.m_wsdlDefinition = null;
                try {
                    WSDLFactory factory = WSDLFactory.newInstance();
                    WSDLReader reader = factory.newWSDLReader();
                    this.m_wsdlDefinition = reader.readWSDL(this.m_file.getRawLocationURI().getPath());
                }
                catch (Exception e) {
                    JaxWsSdk.logError("Could not load WSDL file '" + this.m_file.getName() + "'", e);
                }
            }
        }
        return this.m_wsdlDefinition;
    }

    public void storeWsdlAsync(final Definition definition, final String notificationElement, final int notificationEvent) {
        IOperation op = new IOperation(){

            public void validate() throws IllegalArgumentException {
            }

            public String getOperationName() {
                return "Store WSDL resource to disk";
            }

            public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
                WsdlResource.this.storeWsdl(definition, notificationElement, notificationEvent, monitor);
            }
        };
        new OperationJob(new IOperation[]{op}).schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeWsdl(Definition definition, String notificationElement, int notificationEvent, IProgressMonitor monitor) throws CoreException {
        try {
            Object object = this.m_fileLock;
            synchronized (object) {
                if (this.m_file == null) {
                    throw new CoreException((IStatus)new ScoutStatus("File must not be null"));
                }
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                WSDLFactory factory = WSDLFactory.newInstance();
                WSDLWriter writer = factory.newWSDLWriter();
                writer.writeWSDL(definition, (OutputStream)os);
                this.m_modificationStamp = Integer.MAX_VALUE;
                try {
                    JaxWsSdkUtility.prepareFileAccess(this.m_file, true);
                    this.m_file.setContents((InputStream)new ByteArrayInputStream(os.toByteArray()), true, true, monitor);
                    this.m_wsdlDefinition = definition;
                }
                finally {
                    this.m_modificationStamp = this.m_file.getModificationStamp();
                }
            }
            this.notifyResourceListeners(notificationElement, notificationEvent);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new ScoutStatus(4, "Failed to persist XML file '" + this.m_file.getName() + "'.", (Throwable)e));
        }
    }

    public void notifyStubRebuilt(String alias) {
        this.notifyResourceListeners(alias, 4);
    }
}

