/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.action;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.operation.WsStubGenerationOperation;
import org.eclipse.scout.sdk.ws.jaxws.resource.WsdlResource;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.AbstractLinkAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.dialog.ErrorDialog;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceConsumerNodePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceProviderNodePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WebserviceEnum;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.listener.IOperationFinishedListener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class StubRebuildAction
extends AbstractLinkAction {
    private IScoutBundle m_bundle;
    private WsdlResource m_wsdlResource;
    private String m_markerGroupUUID;
    private WebserviceEnum m_webserviceEnum;
    private BuildJaxWsBean m_buildJaxWsBean;

    public StubRebuildAction() {
        super(Texts.get("RebuildWebserviceStub"), JaxWsSdk.getImageDescriptor("rebuild_ws_stub.png"));
        this.setLinkText(Texts.get("RebuildWebserviceStub"));
        this.setToolTip(Texts.get("ClickToGenerateWsStub"));
    }

    public void init(IScoutBundle bundle, BuildJaxWsBean buildJaxWsBean, WsdlResource wsdlResource, String markerGroupUUID, WebserviceEnum webserviceEnum) {
        this.m_bundle = bundle;
        this.m_buildJaxWsBean = buildJaxWsBean;
        this.m_wsdlResource = wsdlResource;
        this.m_markerGroupUUID = markerGroupUUID;
        this.m_webserviceEnum = webserviceEnum;
    }

    public Object execute(Shell shell, IPage[] selection, ExecutionEvent event) throws ExecutionException {
        WsStubGenerationOperation op = new WsStubGenerationOperation();
        op.setBundle(this.m_bundle);
        op.setAlias(this.m_buildJaxWsBean.getAlias());
        IPath wsdlFolderPath = this.m_wsdlResource.getFile().getProjectRelativePath().removeLastSegments(1);
        op.setWsdlFolder(JaxWsSdkUtility.getFolder(this.m_bundle, wsdlFolderPath.toPortableString(), false));
        op.setProperties(this.m_buildJaxWsBean.getPropertiers());
        op.addOperationFinishedListener(new P_OperationFinishedListener());
        op.setWsdlFileName(this.m_wsdlResource.getFile().getName());
        OperationJob job = new OperationJob(new IOperation[]{op});
        job.setSystem(false);
        job.setUser(false);
        job.setPriority(10);
        job.schedule();
        return null;
    }

    private String getStacktrace(Throwable t) {
        if (t == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    private class P_OperationFinishedListener
    implements IOperationFinishedListener {
        private P_OperationFinishedListener() {
        }

        @Override
        public void operationFinished(final boolean success, final Throwable e) {
            if (StubRebuildAction.this.m_webserviceEnum == WebserviceEnum.Provider) {
                JaxWsSdk.getDefault().notifyPageReload(WebServiceProviderNodePage.class, StubRebuildAction.this.m_markerGroupUUID, 16);
            } else {
                JaxWsSdk.getDefault().notifyPageReload(WebServiceConsumerNodePage.class, StubRebuildAction.this.m_markerGroupUUID, 8);
            }
            ScoutSdkUi.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (success) {
                        MessageBox messageBox = new MessageBox(ScoutSdkUi.getShell(), 34);
                        messageBox.setMessage(Texts.get("WsStubSuccessfullyGenerated"));
                        messageBox.open();
                    } else {
                        ErrorDialog dialog = new ErrorDialog(Texts.get("StubGenerationFailed"));
                        dialog.setError(Texts.get("WsStubGenerationFailed"), e);
                        dialog.open();
                    }
                }
            });
        }
    }
}

