/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.dialog;

import java.util.LinkedList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class SourceFolderSelectionDialog
extends TitleAreaDialog {
    protected static final String IStructuredSelection = null;
    private IScoutBundle m_bundle;
    private IPath m_sourceFolderPath;
    private TableViewer m_viewer;

    public SourceFolderSelectionDialog(Shell shell, IScoutBundle bundle) {
        super(shell);
        this.m_bundle = bundle;
        SourceFolderSelectionDialog.setDialogHelpAvailable((boolean)false);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected final void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Texts.get("SourceFolder"));
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setTitle(Texts.get("SourceFolder"));
        this.setMessage(Texts.get("SelectSourceFolder"), 1);
        this.getOkButton().setEnabled(false);
        return control;
    }

    public IPath getSourceFolderPath() {
        return this.m_sourceFolderPath;
    }

    public Button getOkButton() {
        return this.getButton(0);
    }

    protected Control createDialogArea(Composite parent) {
        this.m_viewer = new TableViewer(new Table(parent, 67584));
        this.m_viewer.setUseHashlookup(true);
        this.m_viewer.getTable().setHeaderVisible(false);
        this.m_viewer.getTable().setLinesVisible(false);
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)SourceFolderSelectionDialog.this.m_viewer.getSelection();
                IClasspathEntry classpathEntry = (IClasspathEntry)selection.getFirstElement();
                SourceFolderSelectionDialog.this.m_sourceFolderPath = classpathEntry.getPath();
                SourceFolderSelectionDialog.this.getOkButton().setEnabled(true);
            }
        });
        this.m_viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)SourceFolderSelectionDialog.this.m_viewer.getSelection();
                IClasspathEntry classpathEntry = (IClasspathEntry)selection.getFirstElement();
                SourceFolderSelectionDialog.this.m_sourceFolderPath = classpathEntry.getPath();
                SourceFolderSelectionDialog.this.getOkButton().setEnabled(true);
                SourceFolderSelectionDialog.this.close();
            }
        });
        TableViewerColumn nameColumn = new TableViewerColumn(this.m_viewer, 16384);
        nameColumn.setLabelProvider((CellLabelProvider)new P_LabelProvider());
        nameColumn.getColumn().setResizable(true);
        nameColumn.getColumn().setWidth(500);
        this.m_viewer.setContentProvider((IContentProvider)new P_ContentProvider());
        this.m_viewer.setInput((Object)"");
        parent.setLayout((Layout)new GridLayout());
        this.m_viewer.getTable().setLayoutData((Object)new GridData(1808));
        return this.m_viewer.getTable();
    }

    public class P_ContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            LinkedList<IClasspathEntry> sourceFolderEntries = new LinkedList<IClasspathEntry>();
            try {
                IClasspathEntry[] iClasspathEntryArray = SourceFolderSelectionDialog.this.m_bundle.getJavaProject().getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
                    if (classpathEntry.getEntryKind() == 3) {
                        sourceFolderEntries.add(classpathEntry);
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                JaxWsSdk.logError("Error occured while fetching source folders.", e);
            }
            return sourceFolderEntries.toArray(new IClasspathEntry[sourceFolderEntries.size()]);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class P_LabelProvider
    extends CellLabelProvider {
        private P_LabelProvider() {
        }

        public void update(ViewerCell cell) {
            IClasspathEntry sourceFolderEntry = (IClasspathEntry)cell.getElement();
            cell.setText(sourceFolderEntry.getPath().toPortableString());
            cell.setImage(JaxWsSdk.getImage("packagefolder_obj.png"));
        }
    }
}

