/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.AbstractPresenter;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.IPresenterAction;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class ActionPresenter
extends AbstractPresenter {
    private IPresenterAction m_presenterAction;
    private Label m_icon;
    private Text m_text;
    private ImageHyperlink m_link;

    public ActionPresenter(Composite parent, IPresenterAction presenterAction, PropertyViewFormToolkit toolkit) {
        super(toolkit, parent);
        this.m_presenterAction = presenterAction;
        this.createPresenter();
    }

    public void setAction(IPresenterAction action) {
        this.m_presenterAction = action;
        if (!this.getContainer().isDisposed()) {
            Control[] controlArray = this.getContainer().getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.dispose();
                ++n2;
            }
        }
        this.createPresenter();
        this.getContainer().layout();
    }

    public Control createPresenter() {
        Composite presenter = this.getContainer();
        if (this.m_presenterAction == null) {
            return presenter;
        }
        this.m_icon = new Label(presenter, 0);
        this.m_icon.setToolTipText(this.m_presenterAction.getToolTip());
        if (this.m_presenterAction.getImage() != null) {
            this.m_icon.setImage(ScoutSdkUi.getImage((CompositeImageDescriptor)new JavaElementImageDescriptor(this.m_presenterAction.getImage(), 0, new Point(16, 16))));
        }
        this.m_text = new Text(presenter, 10);
        if (StringUtility.hasText((String)this.m_presenterAction.getLeadingText())) {
            this.m_text.setText(this.m_presenterAction.getLeadingText());
        }
        this.m_text.setToolTipText(this.m_presenterAction.getToolTip());
        this.m_link = this.getToolkit().createImageHyperlink(presenter, 0);
        if (StringUtility.hasText((String)this.m_presenterAction.getLinkText())) {
            this.m_link.setText(this.m_presenterAction.getLinkText());
        }
        this.m_link.setToolTipText(this.m_presenterAction.getToolTip());
        this.m_link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    ActionPresenter.this.m_presenterAction.execute(null, null, null);
                }
                catch (ExecutionException e1) {
                    JaxWsSdk.logError(e1);
                }
            }
        });
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        presenter.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.exclude = this.m_icon.getImage() == null;
        gd.widthHint = 20;
        this.m_icon.setLayoutData((Object)gd);
        gd = new GridData();
        gd.exclude = !StringUtility.hasText((String)this.m_presenterAction.getLeadingText());
        this.m_text.setLayoutData((Object)gd);
        gd = new GridData();
        gd.exclude = !StringUtility.hasText((String)this.m_presenterAction.getLinkText());
        this.m_link.setLayoutData((Object)gd);
        return presenter;
    }

    public void setEnabled(boolean enabled) {
        if (!this.isDisposed()) {
            this.m_link.setEnabled(enabled);
            this.m_icon.setEnabled(enabled);
            this.m_text.setEnabled(enabled);
        }
    }

    public boolean isMultiLine() {
        return false;
    }
}

