/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.operation.ExternalFileCopyOperation;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.AbstractPropertyPresenter;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class FilePresenter
extends AbstractPropertyPresenter<IFile> {
    private Composite m_composite;
    private Text m_textField;
    private Button m_button;
    private String m_fileExtension;
    private String m_fileDirectory;
    private boolean m_showBrowseButton;

    public FilePresenter(Composite parent, PropertyViewFormToolkit toolkit) {
        super(parent, toolkit, false);
        this.setLabel(Texts.get("File"));
        this.setUseLinkAsLabel(true);
        this.setShowBrowseButton(true);
        this.callInitializer();
    }

    @Override
    protected final Control createContent(Composite parent) {
        this.m_composite = this.getToolkit().createComposite(parent, 0);
        this.m_textField = this.getToolkit().createText(this.m_composite, "", 2308);
        this.m_textField.setEditable(false);
        this.m_textField.setBackground(JaxWsSdkUtility.getColorLightGray());
        this.m_button = new Button(this.m_composite, 0x800008);
        this.m_button.setText(this.getConfiguredBrowseButtonLabel());
        this.m_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFile file = FilePresenter.this.execBrowseAction();
                if (file != null) {
                    FilePresenter.this.setInputInternal(file);
                    FilePresenter.this.setValueFromUI(file);
                }
            }
        });
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        layout.marginBottom = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.marginTop = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.makeColumnsEqualWidth = false;
        this.m_composite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.m_textField.setLayoutData((Object)gd);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = false;
        gd.widthHint = 50;
        gd.horizontalIndent = 5;
        gd.exclude = !this.isShowBrowseButton();
        this.m_button.setLayoutData((Object)gd);
        return this.m_composite;
    }

    protected String getConfiguredBrowseButtonLabel() {
        return Texts.get("Browse");
    }

    @Override
    protected void setInputInternal(IFile input) {
        if (input != null) {
            this.m_textField.setText(input.getName());
            this.m_textField.setToolTipText(input.getName());
        } else {
            this.m_textField.setText("");
            this.m_textField.setToolTipText(null);
        }
        this.setUseLinkAsLabel(input != null && input.exists());
    }

    @Override
    protected void execLinkAction() throws CoreException {
        IFile file = (IFile)this.getValue();
        if (file != null && file.exists()) {
            IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file, (boolean)true);
        }
    }

    protected IFile execBrowseAction() {
        String path;
        FileDialog dialog = new FileDialog(ScoutSdkUi.getShell(), 4096);
        if (StringUtility.hasText((String)this.m_fileExtension)) {
            dialog.setFilterNames(new String[]{this.m_fileExtension});
            dialog.setFilterExtensions(new String[]{"*." + this.m_fileExtension});
        }
        if ((path = dialog.open()) == null) {
            return null;
        }
        File file = IOUtility.toFile((String)path);
        if (this.isCopyRequired(file)) {
            ExternalFileCopyOperation op = new ExternalFileCopyOperation();
            op.setBundle(this.m_bundle);
            op.setOverwrite(true);
            op.setExternalFile(file);
            op.setWorkspacePath((IPath)new Path(this.m_fileDirectory));
            OperationJob job = new OperationJob(new IOperation[]{op});
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException e) {
                JaxWsSdk.logError("unexpected error occured while waiting for operation to complete", e);
                return null;
            }
        }
        return JaxWsSdkUtility.getFile(this.m_bundle, String.valueOf(JaxWsSdkUtility.normalizePath(this.m_fileDirectory, JaxWsSdkUtility.SeparatorType.BothType)) + file.getName(), false);
    }

    public String getFileExtension() {
        return this.m_fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.m_fileExtension = fileExtension;
    }

    public String getFileDirectory() {
        return this.m_fileDirectory;
    }

    public void setFileDirectory(String fileDirectory) {
        this.m_fileDirectory = fileDirectory;
    }

    public boolean isShowBrowseButton() {
        return this.m_showBrowseButton;
    }

    public void setShowBrowseButton(boolean showBrowseButton) {
        if (this.m_showBrowseButton == showBrowseButton) {
            return;
        }
        this.m_showBrowseButton = showBrowseButton;
        this.m_showBrowseButton = showBrowseButton;
        if (this.isControlCreated()) {
            ((GridData)this.m_button.getLayoutData()).exclude = !showBrowseButton;
            this.m_composite.layout();
        }
    }

    private boolean isCopyRequired(File file) {
        Path filePath;
        Path potentialSameFilePath;
        IFile potentialSameFile = JaxWsSdkUtility.getFile(this.m_bundle, String.valueOf(JaxWsSdkUtility.normalizePath(this.m_fileDirectory, JaxWsSdkUtility.SeparatorType.BothType)) + file.getName(), false);
        return potentialSameFile == null || !potentialSameFile.exists() || !(potentialSameFilePath = new Path(potentialSameFile.getLocationURI().getRawPath())).equals((Object)(filePath = new Path(file.getAbsolutePath())));
    }
}

