/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter;

import java.util.LinkedList;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.AbstractPropertyPresenter;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class StringPresenter
extends AbstractPropertyPresenter<String> {
    protected StyledText m_styledText;
    protected String m_prefix;
    protected String m_suffix;
    private VerifyListener m_verifyListener = new P_VerifyListener();
    private ModifyListener m_modifyListener = new P_ModifyListener();
    private boolean m_editable;
    private String m_tooltip;

    public StringPresenter(Composite parent, PropertyViewFormToolkit toolkit) {
        super(parent, toolkit, false);
        this.setAcceptNullValue(true);
        this.callInitializer();
    }

    public void setPrefix(String prefix) {
        this.m_prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.m_suffix = suffix;
    }

    public boolean isEditable() {
        return this.m_editable;
    }

    public void setEditable(boolean editable) {
        this.m_editable = editable;
        if (this.isControlCreated()) {
            if (editable) {
                this.m_styledText.setBackground(null);
            } else {
                this.m_styledText.setBackground(JaxWsSdkUtility.getColorLightGray());
            }
        }
    }

    public String getTooltip() {
        return this.m_tooltip;
    }

    @Override
    public void setTooltip(String tooltip) {
        this.m_tooltip = tooltip;
        if (this.isControlCreated()) {
            this.m_styledText.setToolTipText(StringUtility.nvl((Object)this.m_tooltip, (String)""));
        }
    }

    @Override
    protected Control createContent(Composite parent) {
        this.m_styledText = new StyledText(parent, 2052);
        this.m_styledText.addLineStyleListener((LineStyleListener)new P_LineStyleListener());
        this.m_styledText.addSelectionListener((SelectionListener)new P_SelectionListener());
        this.m_styledText.addKeyListener((KeyListener)new P_KeyListener());
        this.m_styledText.addFocusListener((FocusListener)new P_FocusListener());
        this.m_styledText.addModifyListener(this.m_modifyListener);
        this.m_styledText.addVerifyListener(this.m_verifyListener);
        this.m_styledText.setEditable(false);
        this.m_styledText.setToolTipText(StringUtility.nvl((Object)this.m_tooltip, (String)""));
        this.setEditable(this.m_editable);
        return this.m_styledText;
    }

    @Override
    protected void setInputInternal(String input) {
        this.m_styledText.removeVerifyListener(this.m_verifyListener);
        this.m_styledText.removeModifyListener(this.m_modifyListener);
        try {
            this.m_styledText.setText(StringUtility.nvl((Object)input, (String)StringUtility.join((String)"", (String[])new String[]{this.m_prefix, this.m_suffix})));
        }
        finally {
            this.m_styledText.addVerifyListener(this.m_verifyListener);
            this.m_styledText.addModifyListener(this.m_modifyListener);
        }
    }

    private boolean isValid(String value) {
        if (!StringUtility.hasText((String)value) && !this.isAcceptNullValue()) {
            return false;
        }
        if (this.m_prefix != null && (!value.startsWith(this.m_prefix) || value.equals(this.m_prefix))) {
            return false;
        }
        if (this.m_suffix != null && (!value.endsWith(this.m_suffix) || value.equals(this.m_suffix))) {
            return false;
        }
        return this.m_prefix == null || this.m_suffix == null || !value.equals(String.valueOf(this.m_prefix) + this.m_suffix);
    }

    private final class P_FocusListener
    extends FocusAdapter {
        private P_FocusListener() {
        }

        public void focusLost(FocusEvent e) {
            String newValue = StringPresenter.this.m_styledText.getText();
            if (StringPresenter.this.isValid(newValue)) {
                StringPresenter.this.setValueFromUI(newValue);
            } else {
                StringPresenter.this.setInfo(2, Texts.get("InvalidValue"));
            }
        }
    }

    private final class P_KeyListener
    extends KeyAdapter {
        private P_KeyListener() {
        }

        public void keyReleased(KeyEvent e) {
            int key = e.character;
            if (key > 0 && key <= 26) {
                key += 96;
            }
            e.doit = true;
            if (e.stateMask == SWT.MOD1 && key == 97) {
                this.selectAll();
            }
        }

        private void selectAll() {
            int start = 0;
            int end = StringPresenter.this.m_styledText.getText().length();
            if (StringPresenter.this.m_prefix != null && StringPresenter.this.m_styledText.getText().startsWith(StringPresenter.this.m_prefix)) {
                start = StringPresenter.this.m_prefix.length();
            }
            if (StringPresenter.this.m_suffix != null && StringPresenter.this.m_styledText.getText().endsWith(StringPresenter.this.m_suffix)) {
                end = StringPresenter.this.m_styledText.getText().length() - StringPresenter.this.m_suffix.length();
            }
            StringPresenter.this.m_styledText.setSelection(start, end);
        }
    }

    private final class P_LineStyleListener
    implements LineStyleListener {
        private P_LineStyleListener() {
        }

        public void lineGetStyle(LineStyleEvent event) {
            StyleRange styleRange;
            LinkedList<StyleRange> styleRanges = new LinkedList<StyleRange>();
            if (StringPresenter.this.m_prefix != null && StringPresenter.this.m_styledText.getText().startsWith(StringPresenter.this.m_prefix)) {
                styleRange = new StyleRange();
                styleRange.start = 0;
                styleRange.length = StringPresenter.this.m_prefix.length();
                styleRange.foreground = ScoutSdkUi.getDisplay().getSystemColor(9);
                styleRanges.add(styleRange);
            }
            if (StringPresenter.this.m_suffix != null && StringPresenter.this.m_styledText.getText().endsWith(StringPresenter.this.m_suffix)) {
                styleRange = new StyleRange();
                styleRange.start = StringPresenter.this.m_styledText.getText().length() - StringPresenter.this.m_suffix.length();
                styleRange.length = StringPresenter.this.m_styledText.getText().length();
                styleRange.foreground = ScoutSdkUi.getDisplay().getSystemColor(9);
                styleRanges.add(styleRange);
            }
            event.styles = styleRanges.toArray(new StyleRange[styleRanges.size()]);
        }
    }

    private final class P_ModifyListener
    implements ModifyListener {
        private P_ModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            String newValue = StringPresenter.this.m_styledText.getText();
            if (StringPresenter.this.isValid(newValue)) {
                StringPresenter.this.clearInfo();
            } else {
                StringPresenter.this.setInfo(2, Texts.get("InvalidValue"));
            }
        }
    }

    private final class P_SelectionListener
    extends SelectionAdapter {
        private P_SelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            int start = Math.min(e.x, e.y);
            int end = Math.max(e.x, e.y);
            e.x = start;
            e.y = end;
            if (StringPresenter.this.m_prefix != null && StringPresenter.this.m_styledText.getText().startsWith(StringPresenter.this.m_prefix) && e.x < StringPresenter.this.m_prefix.length()) {
                e.x = StringPresenter.this.m_prefix.length();
                e.doit = false;
            }
            if (StringPresenter.this.m_suffix != null && StringPresenter.this.m_styledText.getText().endsWith(StringPresenter.this.m_suffix) && e.y > StringPresenter.this.m_styledText.getText().length() - StringPresenter.this.m_suffix.length()) {
                e.y = StringPresenter.this.m_styledText.getText().length() - StringPresenter.this.m_suffix.length();
                e.doit = false;
            }
            if (e.y < e.x) {
                e.y = e.x;
            }
            if (!e.doit) {
                StringPresenter.this.m_styledText.removeSelectionListener((SelectionListener)this);
                try {
                    StringPresenter.this.m_styledText.setSelection(e.x, e.y);
                }
                finally {
                    StringPresenter.this.m_styledText.addSelectionListener((SelectionListener)this);
                }
            }
        }
    }

    private final class P_VerifyListener
    implements VerifyListener {
        private P_VerifyListener() {
        }

        public void verifyText(VerifyEvent e) {
            if (StringPresenter.this.m_prefix != null && StringPresenter.this.m_styledText.getText().startsWith(StringPresenter.this.m_prefix) && e.start < StringPresenter.this.m_prefix.length()) {
                e.doit = false;
                return;
            }
            if (StringPresenter.this.m_suffix != null && StringPresenter.this.m_styledText.getText().endsWith(StringPresenter.this.m_suffix) && e.end > StringPresenter.this.m_styledText.getText().length() - StringPresenter.this.m_suffix.length()) {
                e.doit = false;
                return;
            }
            e.doit = true;
        }
    }
}

