/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.OpenNewClassWizardAction;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.fields.tooltip.JavadocTooltip;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.util.IScoutSeverityListener;
import org.eclipse.scout.sdk.util.ScoutSeverityManager;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.AbstractPropertyPresenter;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public class TypePresenter
extends AbstractPropertyPresenter<String> {
    protected StyledText m_textField;
    protected Button m_button;
    private IType m_superType;
    private String[] m_interfaceSignatures;
    private boolean m_allowChangeOfInterfaceType;
    private ISearchJavaSearchScopeFactory m_searchScopeFactory;
    private String m_defaultPackageNameNewType;
    private ModifyListener m_modifyListener;
    private boolean m_allowChangeOfSourceFolder;
    private JavadocTooltip m_javaDocTooltip;
    private P_ScoutSeverityListener m_severityListener;

    public TypePresenter(Composite parent, PropertyViewFormToolkit toolkit) {
        this(parent, toolkit, 120, true);
    }

    public TypePresenter(Composite parent, PropertyViewFormToolkit toolkit, int labelWidth, boolean initialize) {
        super(parent, toolkit, labelWidth, false);
        this.setLabel(Texts.get("class"));
        this.setUseLinkAsLabel(true);
        this.m_modifyListener = new P_ModifyListener();
        this.m_severityListener = new P_ScoutSeverityListener();
        ScoutSeverityManager.getInstance().addQualityManagerListener((IScoutSeverityListener)this.m_severityListener);
        if (initialize) {
            this.callInitializer();
        }
    }

    @Override
    protected Control createContent(Composite parent) {
        Composite composite = this.getToolkit().createComposite(parent, 0);
        this.m_textField = new StyledText(composite, 2052);
        this.m_textField.setEditable(true);
        this.m_textField.addModifyListener(this.m_modifyListener);
        this.m_textField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                IType type = TypePresenter.this.validateType(TypePresenter.this.m_textField.getText());
                if (type != null) {
                    TypePresenter.this.setValueFromUI(type.getFullyQualifiedName());
                }
            }
        });
        this.m_javaDocTooltip = new JavadocTooltip((Control)this.m_textField);
        this.m_button = new Button(composite, 0x800008);
        this.m_button.setText(Texts.get("Browse"));
        this.m_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IType newType = TypePresenter.this.openBrowseTypesDialog();
                if (TypeUtility.exists((IJavaElement)newType)) {
                    TypePresenter.this.setInputInternal(newType.getFullyQualifiedName());
                    TypePresenter.this.setValueFromUI(newType.getFullyQualifiedName(), true);
                }
            }
        });
        this.m_button.setEnabled(this.m_searchScopeFactory != null);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        this.m_textField.setLayoutData((Object)gd);
        gd = new GridData();
        this.m_button.setLayoutData((Object)gd);
        return composite;
    }

    public void dispose() {
        if (this.m_severityListener != null) {
            ScoutSeverityManager.getInstance().removeQualityManagerListener((IScoutSeverityListener)this.m_severityListener);
        }
    }

    @Override
    protected void execLinkAction() throws CoreException {
        String fqn = this.m_textField.getText();
        if (TypeUtility.existsType((String)fqn)) {
            try {
                JavaUI.openInEditor((IJavaElement)TypeUtility.getType((String)fqn));
            }
            catch (Exception e) {
                JaxWsSdk.logWarning(e);
            }
        } else {
            IType newType = this.openNewTypeDialog();
            if (TypeUtility.exists((IJavaElement)newType)) {
                this.setInputInternal(newType.getFullyQualifiedName());
                this.setValueFromUI(newType.getFullyQualifiedName());
            }
        }
    }

    @Override
    protected void setInputInternal(String input) {
        this.m_textField.removeModifyListener(this.m_modifyListener);
        try {
            this.m_textField.setText(StringUtility.nvl((Object)input, (String)""));
        }
        finally {
            this.m_textField.addModifyListener(this.m_modifyListener);
        }
        String fqn = StringUtility.nvl((Object)input, (String)"");
        if (TypeUtility.existsType((String)fqn)) {
            this.setTooltip(Signature.getSimpleName((String)fqn));
            this.m_javaDocTooltip.setMember((IMember)TypeUtility.getType((String)fqn));
        } else {
            this.setTooltip(null);
            this.m_javaDocTooltip.setMember(null);
        }
        this.validateType(fqn);
    }

    public ISearchJavaSearchScopeFactory getSearchScopeFactory() {
        return this.m_searchScopeFactory;
    }

    public void setSearchScopeFactory(ISearchJavaSearchScopeFactory searchScopeFactory) {
        this.m_searchScopeFactory = searchScopeFactory;
        if (this.isControlCreated()) {
            this.m_button.setEnabled(this.m_searchScopeFactory != null);
        }
    }

    public void setSuperType(IType superType) {
        this.m_superType = superType;
    }

    public void setInterfaceTypes(IType[] interfaceTypes) {
        ArrayList<String> signatures = new ArrayList<String>();
        IType[] iTypeArray = interfaceTypes;
        int n = interfaceTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            signatures.add(Signature.createTypeSignature((String)type.getFullyQualifiedName(), (boolean)true));
            ++n2;
        }
        this.setInterfaceSignatures(signatures.toArray(new String[signatures.size()]));
    }

    public void setInterfaceSignatures(String[] interfaceSignatures) {
        this.m_interfaceSignatures = interfaceSignatures;
    }

    public void setAllowChangeOfInterfaceType(boolean allowChangeOfInterfaceType) {
        this.m_allowChangeOfInterfaceType = allowChangeOfInterfaceType;
    }

    public String getDefaultPackageNameNewType() {
        return this.m_defaultPackageNameNewType;
    }

    public void setDefaultPackageNameNewType(String defaultPackageNameNewType) {
        this.m_defaultPackageNameNewType = defaultPackageNameNewType;
    }

    protected IType openNewTypeDialog() {
        NewClassWizardPage page = new NewClassWizardPage();
        page.setDescription(Texts.get("CreateNewType"));
        page.setEnclosingTypeSelection(false, false);
        page.setMethodStubSelection(false, true, true, true);
        String qualifier = Signature.getQualifier((String)this.m_textField.getText());
        IPackageFragment packageFragment = null;
        if (qualifier != null && qualifier.length() > 0) {
            packageFragment = this.m_bundle.getPackageFragment(qualifier);
        } else if (this.m_defaultPackageNameNewType != null) {
            packageFragment = this.m_bundle.getPackageFragment(this.m_defaultPackageNameNewType);
        }
        if (packageFragment != null) {
            page.setPackageFragmentRoot((IPackageFragmentRoot)packageFragment.getParent(), this.isAllowChangeOfSourceFolder());
            page.setPackageFragment(packageFragment, true);
        } else {
            String rootPackageName = this.m_bundle.getRootPackageName();
            page.setPackageFragmentRoot((IPackageFragmentRoot)this.m_bundle.getPackageFragment(rootPackageName).getParent(), true);
        }
        if (this.m_superType != null) {
            page.setSuperClass(this.m_superType.getFullyQualifiedName(), false);
        }
        if (this.m_interfaceSignatures != null && this.m_interfaceSignatures.length > 0) {
            LinkedList<String> interfaceTypeNames = new LinkedList<String>();
            String[] stringArray = this.m_interfaceSignatures;
            int n = this.m_interfaceSignatures.length;
            int n2 = 0;
            while (n2 < n) {
                String signature = stringArray[n2];
                interfaceTypeNames.add(this.stripSignatureToFQN(signature, false));
                ++n2;
            }
            page.setSuperInterfaces(interfaceTypeNames, this.m_allowChangeOfInterfaceType);
        }
        page.setTypeName(Signature.getSimpleName((String)this.m_textField.getText()), true);
        OpenNewClassWizardAction action = new OpenNewClassWizardAction();
        action.setConfiguredWizardPage(page);
        action.run();
        IType type = page.getCreatedType();
        if (TypeUtility.exists((IJavaElement)type)) {
            return type;
        }
        return null;
    }

    private IType openBrowseTypesDialog() {
        String fqn = this.m_textField.getText();
        IType type = null;
        if (TypeUtility.existsType((String)fqn)) {
            type = TypeUtility.getType((String)fqn);
        }
        try {
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)ScoutSdkUi.getShell(), null, (IJavaSearchScope)this.m_searchScopeFactory.create(), (int)256, (boolean)false, (String)"*.*");
            dialog.setTitle(Texts.get("BrowseForType"));
            if (TypeUtility.exists((IJavaElement)type)) {
                dialog.setInitialSelections((Object[])new IType[]{type});
            }
            dialog.setBlockOnOpen(true);
            if (dialog.open() == 0 && dialog.getResult() != null && TypeUtility.exists((IJavaElement)(type = (IType)dialog.getResult()[0]))) {
                return type;
            }
        }
        catch (JavaModelException e) {
            JaxWsSdk.logError(e);
        }
        return null;
    }

    public boolean isAllowChangeOfSourceFolder() {
        return this.m_allowChangeOfSourceFolder;
    }

    public boolean isAllowChangeOfInterfaceType() {
        return this.m_allowChangeOfInterfaceType;
    }

    public void setAllowChangeOfSourceFolder(boolean allowChangeOfSourceFolder) {
        this.m_allowChangeOfSourceFolder = allowChangeOfSourceFolder;
    }

    private IType validateType(String fullyQualifiedName) {
        if (!TypeUtility.existsType((String)fullyQualifiedName)) {
            this.setInfo(2, Texts.get("TypeDoesNotExistClickOnXToCreate", Texts.get("class")));
            return null;
        }
        IType type = TypeUtility.getType((String)fullyQualifiedName);
        if (this.m_interfaceSignatures != null) {
            String[] stringArray = this.m_interfaceSignatures;
            int n = this.m_interfaceSignatures.length;
            int n2 = 0;
            while (n2 < n) {
                String signature = stringArray[n2];
                IType interfaceType = TypeUtility.getType((String)this.stripSignatureToFQN(signature, true));
                if (!JaxWsSdkUtility.isJdtSubType(interfaceType.getFullyQualifiedName(), type)) {
                    this.setInfo(2, Texts.get("XMustBeSubtypeOfY", type.getElementName(), interfaceType.getFullyQualifiedName()));
                    return null;
                }
                ++n2;
            }
        }
        if (this.m_superType != null && !JaxWsSdkUtility.isJdtSubType(this.m_superType.getFullyQualifiedName(), type)) {
            this.setInfo(2, Texts.get("XMustBeSubtypeOfY", type.getElementName(), this.m_superType.getFullyQualifiedName()));
            return null;
        }
        this.clearInfo();
        return type;
    }

    @Override
    protected void updateSeverity(List<AbstractPropertyPresenter.SeverityEntry> statusList) throws CoreException {
        int quality;
        if (StringUtility.hasText((String)((String)this.getValue())) && TypeUtility.existsType((String)((String)this.getValue())) && (quality = ScoutSeverityManager.getInstance().getSeverityOf((Object)TypeUtility.getType((String)((String)this.getValue())))) > 0) {
            statusList.add(new AbstractPropertyPresenter.SeverityEntry(quality, "Unresolved compilation errors"));
        }
    }

    private String stripSignatureToFQN(String signature, boolean eraseGenericTypes) {
        if (signature == null) {
            return null;
        }
        String typeSignature = SignatureUtil.stripSignatureToFQN((String)signature);
        if (!eraseGenericTypes) {
            String typeArguments = null;
            String[] stringArray = Signature.getTypeArguments((String)signature);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String typeArgument = stringArray[n2];
                typeArguments = StringUtility.join((String)",", (String[])new String[]{typeArguments, SignatureUtil.stripSignatureToFQN((String)typeArgument)});
                ++n2;
            }
            if (typeArguments != null) {
                typeSignature = String.valueOf(typeSignature) + "<" + typeArguments + ">";
            }
        }
        return typeSignature;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.m_button.setEnabled(enabled);
        this.m_textField.setEnabled(enabled);
        if (enabled) {
            this.m_textField.setBackground(null);
        } else {
            this.m_textField.setBackground(JaxWsSdkUtility.getColorLightGray());
        }
        super.setEnabled(enabled);
    }

    public static interface ISearchJavaSearchScopeFactory {
        public IJavaSearchScope create();
    }

    private class P_ModifyListener
    implements ModifyListener {
        private P_ModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            TypePresenter.this.validateType(TypePresenter.this.m_textField.getText());
        }
    }

    private class P_ScoutSeverityListener
    implements IScoutSeverityListener {
        private P_ScoutSeverityListener() {
        }

        public void severityChanged(final IResource resource) {
            ScoutSdkUi.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (TypePresenter.this.isDisposed()) {
                        return;
                    }
                    String value = (String)TypePresenter.this.getValue();
                    if (!StringUtility.hasText((String)value)) {
                        return;
                    }
                    String simpleName = Signature.getSimpleName((String)value);
                    if (TypeUtility.existsType((String)value) && resource.getType() == 1 && resource.getFileExtension() != null && resource.getFileExtension().equalsIgnoreCase("java") && (resource.getName().endsWith(String.valueOf(simpleName) + ".java") || resource.getName().endsWith(String.valueOf(simpleName) + ".class"))) {
                        IType type = TypeUtility.getType((String)((String)TypePresenter.this.getValue()));
                        ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)((IFile)resource));
                        if (cu == null) {
                            return;
                        }
                        try {
                            IType[] iTypeArray = cu.getTypes();
                            int n = iTypeArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IType typeChanged = iTypeArray[n2];
                                if (TypeUtility.exists((IJavaElement)typeChanged) && CompareUtility.equals((Object)(typeChanged = TypeUtility.getToplevelType((IType)typeChanged)), (Object)type)) {
                                    TypePresenter.this.updateInfo();
                                    return;
                                }
                                ++n2;
                            }
                        }
                        catch (Exception e) {
                            JaxWsSdk.logError(e);
                        }
                    }
                }
            });
        }
    }
}

