/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.operation.WsProviderDeleteOperation;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.ElementBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.ResourceSelectionWizardPage;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.SchemaUtility;

public class WsProviderDeleteWizard
extends AbstractWorkspaceWizard {
    private ResourceSelectionWizardPage m_wizardPage;
    private IScoutBundle m_bundle;
    private SunJaxWsBean m_sunJaxWsBean;
    private BuildJaxWsBean m_buildJaxWsBean;
    private WsProviderDeleteOperation m_operation;

    public WsProviderDeleteWizard() {
        this.setWindowTitle(Texts.get("DeleteWebServiceProvider"));
    }

    public void addPages() {
        this.m_wizardPage = new ResourceSelectionWizardPage(Texts.get("DeleteWebServiceProvider"), Texts.get("QuestionDeletion"));
        this.m_wizardPage.setElements(this.getElementsToBeDeleted());
        this.addPage((IWizardPage)this.m_wizardPage);
    }

    private List<ElementBean> getElementsToBeDeleted() {
        int n;
        int n2;
        SchemaUtility.Artefact[] artefactArray;
        IFile stubJarFile;
        LinkedList<ElementBean> elements = new LinkedList<ElementBean>();
        elements.add(new ElementBean(1, "Registration entry in sun-jaxws.xml and build-jaxws.xml", JaxWsSdk.getImageDescriptor("sunJaxWs.png"), true));
        String fqn = this.m_sunJaxWsBean.getImplementation();
        if (TypeUtility.existsType((String)fqn)) {
            IType portType = TypeUtility.getType((String)fqn);
            elements.add(new ElementBean(4, "Port type '" + portType.getFullyQualifiedName() + "'", ScoutSdkUi.getImageDescriptor((String)"class_obj.gif"), (IJavaElement)portType, false));
        }
        if ((stubJarFile = JaxWsSdkUtility.getStubJarFile(this.m_bundle, this.m_buildJaxWsBean, this.m_sunJaxWsBean.getWsdl())) != null && stubJarFile.exists()) {
            elements.add(new ElementBean(2, "Stub JAR file '" + stubJarFile.getFullPath().toPortableString() + "'", JaxWsSdk.getImageDescriptor("jar_obj.gif"), (IResource)stubJarFile, false));
        }
        IFile wsdlFile = null;
        if (StringUtility.hasText((String)this.m_sunJaxWsBean.getWsdl())) {
            wsdlFile = JaxWsSdkUtility.getFile(this.m_bundle, this.m_sunJaxWsBean.getWsdl(), false);
        }
        if (wsdlFile != null && wsdlFile.exists()) {
            elements.add(new ElementBean(16, "WSDL file '" + wsdlFile.getProjectRelativePath().toPortableString() + "'", JaxWsSdk.getImageDescriptor("wsdl_file_obj.gif"), (IResource)wsdlFile, false));
        }
        if (wsdlFile != null) {
            SchemaUtility.Artefact[] artefacts;
            artefactArray = artefacts = SchemaUtility.getArtefacts(wsdlFile, false);
            n2 = artefacts.length;
            n = 0;
            while (n < n2) {
                IFile includedSchemaFile;
                SchemaUtility.SchemaArtefact schemaArtefact;
                IFile importedSchemaFile;
                IFile referencedWsdlFile;
                SchemaUtility.WsdlArtefact wsdlArtefact;
                SchemaUtility.Artefact artefact = artefactArray[n];
                if (artefact instanceof SchemaUtility.WsdlArtefact && (wsdlArtefact = (SchemaUtility.WsdlArtefact)artefact).getTypeEnum() == SchemaUtility.WsdlArtefact.TypeEnum.ReferencedWsdl && (referencedWsdlFile = JaxWsSdkUtility.toFile(this.m_bundle, wsdlArtefact.getFile())) != null && referencedWsdlFile.exists()) {
                    elements.add(new ElementBean(32, "Referenced WSDL file '" + referencedWsdlFile.getProjectRelativePath().toPortableString() + "'", JaxWsSdk.getImageDescriptor("wsdl_file_obj.gif"), (IResource)referencedWsdlFile, false));
                }
                if (artefact instanceof SchemaUtility.SchemaImportArtefact && (importedSchemaFile = JaxWsSdkUtility.toFile(this.m_bundle, (schemaArtefact = (SchemaUtility.SchemaImportArtefact)artefact).getFile())) != null && importedSchemaFile.exists()) {
                    elements.add(new ElementBean(64, "Imported XSD schema '" + importedSchemaFile.getProjectRelativePath().toPortableString() + "'", JaxWsSdk.getImageDescriptor("xsdFile.gif"), (IResource)importedSchemaFile, false));
                }
                if (artefact instanceof SchemaUtility.SchemaIncludeArtefact && (includedSchemaFile = JaxWsSdkUtility.toFile(this.m_bundle, (schemaArtefact = (SchemaUtility.SchemaIncludeArtefact)artefact).getFile())) != null && includedSchemaFile.exists()) {
                    elements.add(new ElementBean(64, "Included XSD schema '" + includedSchemaFile.getProjectRelativePath().toPortableString() + "'", JaxWsSdk.getImageDescriptor("xsdFile.gif"), (IResource)includedSchemaFile, false));
                }
                ++n;
            }
        }
        if (this.m_buildJaxWsBean != null) {
            IFile[] bindingFiles = JaxWsSdkUtility.getBindingFiles(this.m_bundle, this.m_buildJaxWsBean.getPropertiers());
            artefactArray = bindingFiles;
            n2 = bindingFiles.length;
            n = 0;
            while (n < n2) {
                SchemaUtility.Artefact bindingFile = artefactArray[n];
                if (bindingFile != null && bindingFile.exists()) {
                    elements.add(new ElementBean(8, "Binding file '" + bindingFile.getProjectRelativePath().toPortableString() + "'", JaxWsSdk.getImageDescriptor("XSDTypeDefinition.gif"), (IResource)bindingFile, false));
                }
                ++n;
            }
        }
        return elements;
    }

    protected boolean beforeFinish() throws CoreException {
        this.m_operation = new WsProviderDeleteOperation();
        this.m_operation.setBundle(this.m_bundle);
        this.m_operation.setSunJaxWsBean(this.m_sunJaxWsBean);
        this.m_operation.setBuildJaxWsBean(this.m_buildJaxWsBean);
        LinkedList<ElementBean> elements = new LinkedList<ElementBean>();
        for (ElementBean element : this.m_wizardPage.getElements()) {
            if (!element.isChecked() && !element.isMandatory()) continue;
            elements.add(element);
        }
        this.m_operation.setElements(elements);
        return true;
    }

    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        OperationJob job = new OperationJob(new IOperation[]{this.m_operation});
        job.schedule();
        return true;
    }

    public IScoutBundle getBundle() {
        return this.m_bundle;
    }

    public void setBundle(IScoutBundle bundle) {
        this.m_bundle = bundle;
    }

    public SunJaxWsBean getSunJaxWsBean() {
        return this.m_sunJaxWsBean;
    }

    public void setSunJaxWsBean(SunJaxWsBean sunJaxWsBean) {
        this.m_sunJaxWsBean = sunJaxWsBean;
    }

    public BuildJaxWsBean getBuildJaxWsBean() {
        return this.m_buildJaxWsBean;
    }

    public void setBuildJaxWsBean(BuildJaxWsBean buildJaxWsBean) {
        this.m_buildJaxWsBean = buildJaxWsBean;
    }
}

