/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard;

import java.io.File;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.operation.ExternalFileCopyOperation;
import org.eclipse.scout.sdk.ws.jaxws.operation.WsStubGenerationOperation;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WsdlLocationWizardPage;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;

public class WsdlLocationWizard
extends AbstractWorkspaceWizard {
    private IScoutBundle m_bundle;
    private BuildJaxWsBean m_buildJaxWsBean;
    private SunJaxWsBean m_sunJaxWsBean;
    private String m_wsdlFileName;
    private WsdlLocationWizardPage m_wsdlLocationWizardPage;
    private ExternalFileCopyOperation[] m_copyOperations;
    private WsStubGenerationOperation m_stubGenerationOperation;
    private IFolder m_wsdlFolder;

    public WsdlLocationWizard(IScoutBundle bundle, BuildJaxWsBean buildJaxWsBean, SunJaxWsBean sunJaxWsBean) {
        this.m_bundle = bundle;
        this.m_copyOperations = new ExternalFileCopyOperation[0];
        this.m_buildJaxWsBean = buildJaxWsBean;
        this.m_sunJaxWsBean = sunJaxWsBean;
        this.setWindowTitle(Texts.get("BrowseForWsdlFile"));
    }

    public void addPages() {
        IFolder oldWsdlFolder = null;
        IFolder wsdlRootFolder = null;
        String wsdlLocation = null;
        if (this.m_sunJaxWsBean != null) {
            wsdlLocation = this.m_sunJaxWsBean.getWsdl();
            oldWsdlFolder = JaxWsSdkUtility.getFolder(this.m_bundle, "/WEB-INF/wsdl/provider", false);
            wsdlRootFolder = JaxWsSdkUtility.getFolder(this.m_bundle, "/WEB-INF/wsdl/provider", false);
        } else {
            wsdlLocation = this.m_buildJaxWsBean.getWsdl();
            oldWsdlFolder = JaxWsSdkUtility.getFolder(this.m_bundle, "/WEB-INF/wsdl/consumer", false);
            wsdlRootFolder = JaxWsSdkUtility.getFolder(this.m_bundle, "/WEB-INF/wsdl/consumer", false);
        }
        if (StringUtility.hasText((String)wsdlLocation)) {
            oldWsdlFolder = JaxWsSdkUtility.getParentFolder(this.m_bundle, JaxWsSdkUtility.getFile(this.m_bundle, wsdlLocation, false));
        }
        this.m_wsdlLocationWizardPage = new WsdlLocationWizardPage(this.m_bundle);
        this.m_wsdlLocationWizardPage.setRebuildStubOptionVisible(true);
        this.m_wsdlLocationWizardPage.setRebuildStub(true);
        this.m_wsdlLocationWizardPage.setWsdlFolderVisible(true);
        this.m_wsdlLocationWizardPage.setWsdlFolder(oldWsdlFolder);
        this.m_wsdlLocationWizardPage.setRootWsdlFolder(wsdlRootFolder);
        this.addPage((IWizardPage)this.m_wsdlLocationWizardPage);
    }

    protected boolean beforeFinish() throws CoreException {
        File wsdlFile = this.m_wsdlLocationWizardPage.getWsdlFile();
        this.m_wsdlFolder = this.m_wsdlLocationWizardPage.getWsdlFolder();
        this.m_wsdlFileName = wsdlFile.getName();
        LinkedList<ExternalFileCopyOperation> copyOperations = new LinkedList<ExternalFileCopyOperation>();
        if (this.isCopyRequired(this.m_wsdlFolder, wsdlFile)) {
            ExternalFileCopyOperation op = new ExternalFileCopyOperation();
            op.setBundle(this.m_bundle);
            op.setOverwrite(true);
            op.setExternalFile(this.m_wsdlLocationWizardPage.getWsdlFile());
            op.setWorkspacePath(this.m_wsdlFolder.getProjectRelativePath());
            copyOperations.add(op);
        }
        File[] fileArray = this.m_wsdlLocationWizardPage.getAdditionalFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (this.isCopyRequired(this.m_wsdlFolder, file)) {
                ExternalFileCopyOperation op = new ExternalFileCopyOperation();
                op.setBundle(this.m_bundle);
                op.setOverwrite(true);
                op.setExternalFile(file);
                op.setWorkspacePath(this.m_wsdlFolder.getProjectRelativePath());
                copyOperations.add(op);
            }
            ++n2;
        }
        this.m_copyOperations = copyOperations.toArray(new ExternalFileCopyOperation[copyOperations.size()]);
        if (this.m_wsdlLocationWizardPage.isRebuildStub()) {
            this.m_stubGenerationOperation = new WsStubGenerationOperation();
            this.m_stubGenerationOperation.setBundle(this.m_bundle);
            this.m_stubGenerationOperation.setAlias(this.m_buildJaxWsBean.getAlias());
            this.m_stubGenerationOperation.setWsdlFolder(this.m_wsdlFolder);
            this.m_stubGenerationOperation.setProperties(this.m_buildJaxWsBean.getPropertiers());
            this.m_stubGenerationOperation.setWsdlFileName(wsdlFile.getName());
        }
        return true;
    }

    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        ExternalFileCopyOperation[] externalFileCopyOperationArray = this.m_copyOperations;
        int n = this.m_copyOperations.length;
        int n2 = 0;
        while (n2 < n) {
            ExternalFileCopyOperation op = externalFileCopyOperationArray[n2];
            op.validate();
            op.run(monitor, workingCopyManager);
            ++n2;
        }
        if (this.m_sunJaxWsBean != null) {
            this.m_sunJaxWsBean.setWsdl(JaxWsSdkUtility.normalizePath(this.m_wsdlFolder.getProjectRelativePath().append(this.m_wsdlFileName).toPortableString(), JaxWsSdkUtility.SeparatorType.None));
            ResourceFactory.getSunJaxWsResource(this.m_bundle).storeXml(this.m_sunJaxWsBean.getXml().getDocument(), 16, monitor, this.m_sunJaxWsBean.getAlias());
        } else {
            this.m_buildJaxWsBean.setWsdl(JaxWsSdkUtility.normalizePath(this.m_wsdlFolder.getProjectRelativePath().append(this.m_wsdlFileName).toPortableString(), JaxWsSdkUtility.SeparatorType.None));
            ResourceFactory.getBuildJaxWsResource(this.m_bundle).storeXml(this.m_buildJaxWsBean.getXml().getDocument(), 16, monitor, this.m_buildJaxWsBean.getAlias());
        }
        if (this.m_stubGenerationOperation != null) {
            this.m_stubGenerationOperation.run(monitor, workingCopyManager);
        }
        return true;
    }

    private boolean isCopyRequired(IFolder wsdlFolder, File wsdlFile) {
        Path wsdlFilePath;
        Path potentialSameFilePath;
        IFile potentialSameFile = JaxWsSdkUtility.getFile(this.m_bundle, wsdlFolder.getProjectRelativePath().toPortableString(), wsdlFile.getName(), false);
        return potentialSameFile == null || !potentialSameFile.exists() || !(potentialSameFilePath = new Path(potentialSameFile.getLocationURI().getRawPath())).equals((Object)(wsdlFilePath = new Path(wsdlFile.getAbsolutePath())));
    }
}

