/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;

public final class SchemaUtility {
    private SchemaUtility() {
    }

    public static Artefact[] getArtefacts(IFile wsdlFile, boolean includeRootWsdl) {
        return SchemaUtility.getArtefacts(JaxWsSdkUtility.toFile(wsdlFile), includeRootWsdl);
    }

    public static Artefact[] getArtefacts(File wsdlFile, boolean includeRootWsdl) {
        Artefact[] wsdlArtefacts;
        if (wsdlFile == null || !wsdlFile.exists()) {
            return new Artefact[0];
        }
        Definition wsdlDefinition = SchemaUtility.loadWsdlDefinition(wsdlFile);
        if (wsdlDefinition == null) {
            return new Artefact[0];
        }
        ArrayList<Artefact> artefacts = new ArrayList<Artefact>();
        WsdlArtefact rootWsdlArtefact = new WsdlArtefact(wsdlFile, WsdlArtefact.TypeEnum.RootWsdl, wsdlDefinition);
        artefacts.add(rootWsdlArtefact);
        artefacts.addAll(Arrays.asList(SchemaUtility.getReferencedWsdlResourcesRec(wsdlFile, wsdlDefinition)));
        Artefact[] artefactArray = wsdlArtefacts = artefacts.toArray(new Artefact[artefacts.size()]);
        int n = wsdlArtefacts.length;
        int n2 = 0;
        while (n2 < n) {
            Artefact artefact = artefactArray[n2];
            if (artefact instanceof WsdlArtefact) {
                WsdlArtefact wsdlArtefact = (WsdlArtefact)artefact;
                if (wsdlArtefact.getWsdlDefintion() == null) {
                    JaxWsSdk.logWarning("Unexpected: WSDL definition should not be null '" + wsdlArtefact + "'");
                } else {
                    Types types = wsdlArtefact.getWsdlDefintion().getTypes();
                    if (types != null) {
                        ArrayList<Schema> inlineSchemas = new ArrayList<Schema>();
                        for (Object type : types.getExtensibilityElements()) {
                            if (!(type instanceof Schema)) continue;
                            Schema schema = (Schema)type;
                            inlineSchemas.add(schema);
                            artefacts.addAll(Arrays.asList(SchemaUtility.getReferencedSchemaResourcesRec(wsdlArtefact.getFile(), schema)));
                        }
                        wsdlArtefact.setInlineSchemas(inlineSchemas.toArray(new Schema[inlineSchemas.size()]));
                    }
                }
            }
            ++n2;
        }
        if (!includeRootWsdl) {
            artefacts.remove(rootWsdlArtefact);
        }
        JaxWsSdkUtility.removeDuplicateEntries(artefacts);
        return artefacts.toArray(new Artefact[artefacts.size()]);
    }

    public static String getSchemaTargetNamespace(Schema schema) {
        if (schema == null) {
            return null;
        }
        if (schema.getElement().hasAttribute("targetNamespace")) {
            return schema.getElement().getAttribute("targetNamespace");
        }
        return null;
    }

    private static WsdlArtefact[] getReferencedWsdlResourcesRec(File parentWsdlFile, Definition parentWsdlDefinition) {
        if (parentWsdlFile == null || !parentWsdlFile.exists() || parentWsdlDefinition == null) {
            return new WsdlArtefact[0];
        }
        ArrayList<WsdlArtefact> wsdlArtefacts = new ArrayList<WsdlArtefact>();
        Map importMap = parentWsdlDefinition.getImports();
        for (Object importValue : importMap.values()) {
            if (!(importValue instanceof List)) continue;
            List importList = (List)importValue;
            for (Object importObject : importList) {
                if (!(importObject instanceof Import)) continue;
                Import importDirective = (Import)importObject;
                Definition wsdlDefinition = importDirective.getDefinition();
                File wsdlFile = SchemaUtility.toFile(parentWsdlFile.getParentFile(), importDirective.getLocationURI());
                if (wsdlFile == null) continue;
                wsdlArtefacts.add(new WsdlArtefact(wsdlFile, WsdlArtefact.TypeEnum.ReferencedWsdl, wsdlDefinition));
                wsdlArtefacts.addAll(Arrays.asList(SchemaUtility.getReferencedWsdlResourcesRec(wsdlFile, wsdlDefinition)));
            }
        }
        return wsdlArtefacts.toArray(new WsdlArtefact[wsdlArtefacts.size()]);
    }

    private static SchemaArtefact[] getReferencedSchemaResourcesRec(File file, Schema schema) {
        Map importMap;
        if (file == null || !file.exists() || schema == null) {
            return new SchemaArtefact[0];
        }
        File folder = file.getParentFile();
        ArrayList<SchemaArtefact> artefacts = new ArrayList<SchemaArtefact>();
        List includes = schema.getIncludes();
        if (includes != null && includes.size() > 0) {
            for (Object include : includes) {
                SchemaReference schemaInclude;
                File referencedSchemaFile;
                if (!(include instanceof SchemaReference) || (referencedSchemaFile = SchemaUtility.toFile(folder, (schemaInclude = (SchemaReference)include).getSchemaLocationURI())) == null) continue;
                Schema referencedSchema = schemaInclude.getReferencedSchema();
                SchemaIncludeArtefact artefact = new SchemaIncludeArtefact(referencedSchemaFile, referencedSchema);
                artefacts.add(artefact);
                artefacts.addAll(Arrays.asList(SchemaUtility.getReferencedSchemaResourcesRec(referencedSchemaFile, referencedSchema)));
            }
        }
        if ((importMap = schema.getImports()) != null && importMap.size() > 0) {
            for (Object importObject : importMap.values()) {
                if (!(importObject instanceof List)) continue;
                List importList = (List)importObject;
                for (Object importDirective : importList) {
                    SchemaImport schemaImport;
                    File referencedSchemaFile;
                    if (!(importDirective instanceof SchemaImport) || (referencedSchemaFile = SchemaUtility.toFile(folder, (schemaImport = (SchemaImport)importDirective).getSchemaLocationURI())) == null) continue;
                    Schema referencedSchema = schemaImport.getReferencedSchema();
                    SchemaImportArtefact artefact = new SchemaImportArtefact(referencedSchemaFile, referencedSchema, schemaImport.getNamespaceURI());
                    artefacts.add(artefact);
                    artefacts.addAll(Arrays.asList(SchemaUtility.getReferencedSchemaResourcesRec(referencedSchemaFile, referencedSchema)));
                }
            }
        }
        return artefacts.toArray(new SchemaArtefact[artefacts.size()]);
    }

    private static Definition loadWsdlDefinition(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader reader = factory.newWSDLReader();
            return reader.readWSDL(file.getAbsolutePath());
        }
        catch (Exception e) {
            JaxWsSdk.logError("Could not load WSDL file '" + file.getAbsolutePath() + "'", e);
            return null;
        }
    }

    private static File toFile(File folder, String locationUri) {
        File file;
        if (locationUri == null) {
            return null;
        }
        if (folder != null && folder.exists() && (file = new File(folder, locationUri)).exists()) {
            return file;
        }
        file = new File(locationUri);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public static abstract class Artefact {
        private File m_file;

        public Artefact(File file) {
            this.m_file = file;
        }

        public File getFile() {
            return this.m_file;
        }

        public void setFile(File file) {
            this.m_file = file;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.m_file == null ? 0 : this.m_file.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Artefact other = (Artefact)obj;
            return !(this.m_file == null ? other.m_file != null : !this.m_file.equals(other.m_file));
        }
    }

    public static abstract class SchemaArtefact
    extends Artefact {
        private Schema m_schema;

        public SchemaArtefact(File schemaFile, Schema schema) {
            super(schemaFile);
            this.m_schema = schema;
        }

        public Schema getSchema() {
            return this.m_schema;
        }

        public void setSchema(Schema schema) {
            this.m_schema = schema;
        }
    }

    public static class SchemaImportArtefact
    extends SchemaArtefact {
        private String m_namespaceUri;

        public SchemaImportArtefact(File schemaFile, Schema schema, String namespaceUri) {
            super(schemaFile, schema);
            this.m_namespaceUri = namespaceUri;
        }

        public String getNamespaceUri() {
            return this.m_namespaceUri;
        }

        public void setNamespaceUri(String namespaceUri) {
            this.m_namespaceUri = namespaceUri;
        }
    }

    public static class SchemaIncludeArtefact
    extends SchemaArtefact {
        public SchemaIncludeArtefact(File schemaFile, Schema schema) {
            super(schemaFile, schema);
        }
    }

    public static class WsdlArtefact
    extends Artefact {
        private TypeEnum m_typeEnum;
        private Definition m_wsdlDefintion;
        private Schema[] m_inlineSchemas = new Schema[0];

        public WsdlArtefact(File wsdlFile, TypeEnum typeEnum, Definition wsdlDefintion) {
            super(wsdlFile);
            this.m_typeEnum = typeEnum;
            this.m_wsdlDefintion = wsdlDefintion;
        }

        public TypeEnum getTypeEnum() {
            return this.m_typeEnum;
        }

        public void setTypeEnum(TypeEnum typeEnum) {
            this.m_typeEnum = typeEnum;
        }

        public Definition getWsdlDefintion() {
            return this.m_wsdlDefintion;
        }

        public void setWsdlDefintion(Definition wsdlDefintion) {
            this.m_wsdlDefintion = wsdlDefintion;
        }

        public Schema[] getInlineSchemas() {
            if (this.m_inlineSchemas == null) {
                return new Schema[0];
            }
            return this.m_inlineSchemas;
        }

        public void setInlineSchemas(Schema[] inlineSchemas) {
            this.m_inlineSchemas = inlineSchemas;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.m_typeEnum == null ? 0 : this.m_typeEnum.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WsdlArtefact other = (WsdlArtefact)obj;
            return this.m_typeEnum == other.m_typeEnum;
        }

        public static enum TypeEnum {
            RootWsdl,
            ReferencedWsdl;

        }
    }
}

