/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.service.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.service.CreateServiceImmediatelySchedulingRule;

public class ExtensionPointTracker {
    private static final Listener NULL_LISTENER = new Listener(){

        @Override
        public void added(IExtension extension) {
        }

        @Override
        public void removed(IExtension extension) {
        }
    };
    private final IExtensionRegistry m_registry;
    private final String m_extensionPointId;
    private final String m_namespace;
    private final String m_simpleName;
    private final Set<IExtension> m_extensionCache = new HashSet<IExtension>();
    private final Listener m_listener;
    private final RegistryChangeListener m_registryChangeListener = new RegistryChangeListener();
    private final Object m_trackerLock = new Object();
    private boolean m_open = false;

    public ExtensionPointTracker(IExtensionRegistry registry, String extensionPointId, Listener listener) {
        this.m_registry = registry;
        this.m_extensionPointId = extensionPointId;
        Listener listener2 = this.m_listener = listener != null ? listener : NULL_LISTENER;
        if (extensionPointId == null || -1 == extensionPointId.indexOf(46)) {
            throw new IllegalArgumentException("Unexpected Extension Point Identifier: " + extensionPointId);
        }
        int lastDotIndex = extensionPointId.lastIndexOf(46);
        this.m_namespace = extensionPointId.substring(0, lastDotIndex);
        this.m_simpleName = extensionPointId.substring(lastDotIndex + 1);
    }

    public final Object getTrackerLock() {
        return this.m_trackerLock;
    }

    public boolean isOpen() {
        return this.m_open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        if (this.m_open) {
            return;
        }
        Object object = this.m_trackerLock;
        synchronized (object) {
            if (this.m_open) {
                return;
            }
            IExtension[] extensions = null;
            this.m_registry.addRegistryChangeListener((IRegistryChangeListener)this.m_registryChangeListener, this.m_namespace);
            try {
                IExtensionPoint point = this.m_registry.getExtensionPoint(this.m_extensionPointId);
                if (point != null) {
                    extensions = point.getExtensions();
                    this.m_extensionCache.addAll(Arrays.asList(extensions));
                }
            }
            catch (InvalidRegistryObjectException e) {
                this.m_registry.removeRegistryChangeListener((IRegistryChangeListener)this.m_registryChangeListener);
                throw e;
            }
            if (extensions != null) {
                int i = 0;
                while (i < extensions.length) {
                    this.m_listener.added(extensions[i]);
                    ++i;
                }
            }
            this.m_open = true;
        }
        Job job = new Job("Wait for all 'create immediately' services"){

            protected IStatus run(IProgressMonitor monitor) {
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)new CreateServiceImmediatelySchedulingRule());
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        HashSet<IExtension> extensions = null;
        Object object = this.m_trackerLock;
        synchronized (object) {
            if (!this.m_open) {
                return;
            }
            this.m_open = false;
            this.m_registry.removeRegistryChangeListener((IRegistryChangeListener)this.m_registryChangeListener);
            extensions = new HashSet<IExtension>(this.m_extensionCache);
            this.m_extensionCache.clear();
            for (IExtension x : extensions) {
                this.m_listener.removed(x);
            }
        }
    }

    private boolean removeExtensionNoLocking(IExtension extension) {
        if (!this.m_open) {
            return false;
        }
        return this.m_extensionCache.remove(extension);
    }

    private boolean addExtensionNoLocking(IExtension extension) {
        if (!this.m_open) {
            return false;
        }
        return this.m_extensionCache.add(extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IExtension[] getExtensions() {
        Object object = this.m_trackerLock;
        synchronized (object) {
            return this.m_extensionCache.toArray(new IExtension[this.m_extensionCache.size()]);
        }
    }

    public static interface Listener {
        public void added(IExtension var1);

        public void removed(IExtension var1);
    }

    class RegistryChangeListener
    implements IRegistryChangeListener {
        RegistryChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registryChanged(IRegistryChangeEvent event) {
            IExtensionDelta[] deltas = event.getExtensionDeltas(ExtensionPointTracker.this.m_namespace, ExtensionPointTracker.this.m_simpleName);
            int i = 0;
            while (i < deltas.length) {
                IExtensionDelta delta = deltas[i];
                IExtension extension = delta.getExtension();
                switch (delta.getKind()) {
                    case 1: {
                        Object object = ExtensionPointTracker.this.m_trackerLock;
                        synchronized (object) {
                            if (ExtensionPointTracker.this.addExtensionNoLocking(extension)) {
                                ExtensionPointTracker.this.m_listener.added(extension);
                            }
                            break;
                        }
                    }
                    case 2: {
                        Object object = ExtensionPointTracker.this.m_trackerLock;
                        synchronized (object) {
                            if (ExtensionPointTracker.this.removeExtensionNoLocking(extension)) {
                                ExtensionPointTracker.this.m_listener.removed(extension);
                            }
                            break;
                        }
                    }
                }
                ++i;
            }
        }
    }
}

