/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.service.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.service.DefaultServiceFactory;
import org.eclipse.scout.service.IServiceFactory;
import org.eclipse.scout.service.ServiceUtility;
import org.eclipse.scout.service.internal.Activator;
import org.eclipse.scout.service.internal.ExtensionPointTracker;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ServicesExtensionManager
implements ExtensionPointTracker.Listener {
    public static final String PROP_DEFAULT_PROXY_SERVICE_RANKING = String.valueOf(ServicesExtensionManager.class.getName()) + ".defaultProxyServiceRanking";
    public static final String PROP_DEFAULT_SERVICE_RANKING = String.valueOf(ServicesExtensionManager.class.getName()) + ".defaultServiceRanking";
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ServicesExtensionManager.class);
    private final HashMap<IExtension, List<ServiceRegistration>> m_serviceRegistrations = new HashMap();
    private ExtensionPointTracker m_tracker;
    private int m_defaultProxyServiceRanking;
    private int m_defaultServiceRanking;

    public ServicesExtensionManager(IExtensionRegistry registry, String extensionPointId) {
        BundleContext bundleContext = Activator.getDefault().getBundle().getBundleContext();
        this.m_defaultProxyServiceRanking = -2;
        String defaultProxyRankingString = bundleContext.getProperty(PROP_DEFAULT_PROXY_SERVICE_RANKING);
        if (!StringUtility.isNullOrEmpty((String)defaultProxyRankingString)) {
            try {
                this.m_defaultProxyServiceRanking = Integer.parseInt(defaultProxyRankingString);
            }
            catch (Exception e) {
                LOG.warn("could not parse defaultProxyServiceRanking '" + defaultProxyRankingString + "'.", (Throwable)e);
            }
        }
        this.m_defaultServiceRanking = 0;
        String defaultServiceRankingString = bundleContext.getProperty(PROP_DEFAULT_SERVICE_RANKING);
        if (!StringUtility.isNullOrEmpty((String)defaultServiceRankingString)) {
            try {
                this.m_defaultServiceRanking = Integer.parseInt(defaultServiceRankingString);
            }
            catch (Exception e) {
                LOG.warn("could not parse defaultServiceRanking '" + defaultServiceRankingString + "'.", (Throwable)e);
            }
        }
        this.m_tracker = new ExtensionPointTracker(registry, extensionPointId, this);
    }

    public void start() {
        if (this.m_tracker != null) {
            this.m_tracker.open();
        }
    }

    public void stop() {
        this.m_tracker.close();
        this.m_tracker = null;
    }

    @Override
    public void added(IExtension extension) {
        Bundle contributorBundle = Platform.getBundle((String)extension.getContributor().getName());
        if (contributorBundle == null) {
            return;
        }
        BundleContext context = contributorBundle.getBundleContext();
        if (context == null) {
            return;
        }
        ArrayList<ServiceRegistration> list = new ArrayList<ServiceRegistration>();
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            block27: {
                IConfigurationElement serviceElement = iConfigurationElementArray[n2];
                try {
                    ServiceRegistration reg;
                    Class[] classArray;
                    ArrayList<String> clazzes;
                    String createImmediately;
                    Class serviceClass = contributorBundle.loadClass(serviceElement.getAttribute("class"));
                    Object factory = null;
                    if (serviceElement.getAttribute("factory") != null) {
                        factory = this.createServiceFactory(contributorBundle, serviceElement.getAttribute("factory"), serviceClass);
                    }
                    String sessionType = null;
                    if (serviceElement.getAttribute("session") != null) {
                        sessionType = serviceElement.getAttribute("session");
                    }
                    Integer ranking = null;
                    if (!StringUtility.isNullOrEmpty((String)serviceElement.getAttribute("ranking"))) {
                        ranking = Integer.parseInt(serviceElement.getAttribute("ranking"));
                    } else {
                        Priority prio = serviceClass.getAnnotation(Priority.class);
                        if (prio != null) {
                            ranking = (int)prio.value();
                        }
                    }
                    Hashtable<String, Object> initParams = new Hashtable<String, Object>();
                    if (serviceElement.getAttribute("createImmediately") != null && "true".equals(createImmediately = serviceElement.getAttribute("createImmediately"))) {
                        initParams.put("service.createImmediately", true);
                    }
                    if (sessionType != null) {
                        initParams.put("service.scope", sessionType);
                    }
                    IConfigurationElement[] iConfigurationElementArray2 = serviceElement.getChildren("init-param");
                    int n3 = iConfigurationElementArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement initParamElement = iConfigurationElementArray2[n4];
                        initParams.put(initParamElement.getAttribute("name"), initParamElement.getAttribute("value"));
                        ++n4;
                    }
                    if (serviceElement.getName().equals("service")) {
                        if (sessionType != null && factory == null) {
                            throw new IllegalArgumentException("cannot specify a session without a factory");
                        }
                        if (factory == null) {
                            factory = new DefaultServiceFactory(serviceClass);
                        }
                        clazzes = new ArrayList<String>();
                        clazzes.add(serviceClass.getName());
                        classArray = ServiceUtility.getInterfacesHierarchy(serviceClass, Object.class);
                        int n5 = classArray.length;
                        n3 = 0;
                        while (n3 < n5) {
                            Class c = classArray[n3];
                            clazzes.add(c.getName());
                            ++n3;
                        }
                        if (ranking == null) {
                            initParams.put("service.ranking", this.m_defaultServiceRanking);
                        } else {
                            initParams.put("service.ranking", ranking);
                        }
                        reg = context.registerService(clazzes.toArray(new String[clazzes.size()]), factory, initParams);
                        list.add(reg);
                        if (factory instanceof IServiceFactory) {
                            ((IServiceFactory)factory).serviceRegistered(reg);
                        }
                        break block27;
                    }
                    if (serviceElement.getName().equals("proxy")) {
                        if (factory == null) {
                            throw new IllegalArgumentException("a proxy requires a factory");
                        }
                        clazzes = new ArrayList();
                        clazzes.add(serviceClass.getName());
                        if (!serviceClass.isInterface()) {
                            classArray = ServiceUtility.getInterfacesHierarchy(serviceClass, Object.class);
                            int n6 = classArray.length;
                            n3 = 0;
                            while (n3 < n6) {
                                Class c = classArray[n3];
                                clazzes.add(c.getName());
                                ++n3;
                            }
                        }
                        if (ranking == null) {
                            initParams.put("service.ranking", this.m_defaultProxyServiceRanking);
                        } else {
                            initParams.put("service.ranking", ranking);
                        }
                        reg = context.registerService(clazzes.toArray(new String[clazzes.size()]), factory, initParams);
                        list.add(reg);
                        if (factory instanceof IServiceFactory) {
                            ((IServiceFactory)factory).serviceRegistered(reg);
                        }
                        break block27;
                    }
                    throw new IllegalArgumentException("unexpected element name: " + serviceElement.getName());
                }
                catch (Throwable t) {
                    LOG.error("register " + serviceElement.getName() + ": bundle=" + contributorBundle.getSymbolicName() + ", service=" + serviceElement.getAttribute("class"), t);
                }
            }
            ++n2;
        }
        this.m_serviceRegistrations.put(extension, list);
    }

    @Override
    public void removed(IExtension extension) {
        List<ServiceRegistration> list = this.m_serviceRegistrations.remove(extension);
        if (list != null) {
            for (ServiceRegistration reg : list) {
                try {
                    reg.unregister();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private Object createServiceFactory(Bundle bundle, String factoryClazz, Class<?> serviceClass) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class c = bundle.loadClass(factoryClazz);
        try {
            return c.getConstructor(Class.class).newInstance(serviceClass);
        }
        catch (Throwable throwable) {
            return c.newInstance();
        }
    }
}

