/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.sca1_0.diagram.extension;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.soa.sca.core.common.diagram.ScaDiagramExtensionManager;
import org.eclipse.soa.sca.core.common.diagram.extension.edit.part.ScaElementExtendedInformation;
import org.eclipse.soa.sca.core.common.diagram.extension.edit.part.ScaElementInformation;
import org.eclipse.soa.sca.core.common.diagram.extension.edit.part.VisualIDRegistry;
import org.eclipse.soa.sca.sca1_0.diagram.extension.LocalDiagramExtensionUtils;
import org.eclipse.soa.sca.sca1_0.diagram.extension.edit.part.VisualIDRegistryBase;
import org.eclipse.soa.sca.sca1_0.diagram.extension.view.factories.BindingViewFactory;
import org.eclipse.soa.sca.sca1_0.diagram.extension.view.factories.ImplementationViewFactory;
import org.eclipse.soa.sca.sca1_0.diagram.extension.view.factories.InterfaceViewFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalDiagramExtensionManager {
    public static LocalDiagramExtensionManager INSTANCE = new LocalDiagramExtensionManager();
    private final List<ScaElementExtendedInformation> implExtensions = new ArrayList<ScaElementExtendedInformation>();
    private final List<ScaElementExtendedInformation> itfExtensions;
    private final List<ScaElementExtendedInformation> bindExtensions;

    public List<ScaElementExtendedInformation> getImplementationExtensions() {
        return this.implExtensions;
    }

    public List<ScaElementExtendedInformation> getInterfaceExtensions() {
        return this.itfExtensions;
    }

    public List<ScaElementExtendedInformation> getBindingExtensions() {
        return this.bindExtensions;
    }

    public List<ScaElementExtendedInformation> getAllExtensions() {
        ArrayList<ScaElementExtendedInformation> result = new ArrayList<ScaElementExtendedInformation>();
        result.addAll(this.bindExtensions);
        result.addAll(this.implExtensions);
        result.addAll(this.itfExtensions);
        return result;
    }

    private LocalDiagramExtensionManager() {
        this.populateList(this.implExtensions, ScaDiagramExtensionManager.INSTANCE.getImplementationExtensions("1.0"), ImplementationViewFactory.class);
        this.itfExtensions = new ArrayList<ScaElementExtendedInformation>();
        this.populateList(this.itfExtensions, ScaDiagramExtensionManager.INSTANCE.getInterfaceExtensions("1.0"), InterfaceViewFactory.class);
        this.bindExtensions = new ArrayList<ScaElementExtendedInformation>();
        this.populateList(this.bindExtensions, ScaDiagramExtensionManager.INSTANCE.getBindingExtensions("1.0"), BindingViewFactory.class);
    }

    private void populateList(List<ScaElementExtendedInformation> targetList, List<ScaElementInformation> sourceList, Class<?> viewFactoryClass) {
        for (ScaElementInformation info : sourceList) {
            ScaElementExtendedInformation ext = new ScaElementExtendedInformation();
            ext.setElementLiteral(info.getElementLiteral());
            ext.setElementType(info.getElementType());
            ext.setIconPath(info.getIconPath());
            int visualId = -1;
            if (!(info.getElementType() instanceof IHintedType)) continue;
            String semanticHint = ((IHintedType)info.getElementType()).getSemanticHint();
            try {
                visualId = LocalDiagramExtensionUtils.getVisualID(semanticHint);
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            VisualIDRegistryBase visualIDRegistry = new VisualIDRegistryBase(info.getElementType().getEClass(), visualId);
            ext.setVisualId(visualId);
            ext.setVisualIDRegistry((VisualIDRegistry)visualIDRegistry);
            ext.setViewFactoryClass(viewFactoryClass);
            targetList.add(ext);
        }
    }
}

