/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.sca1_0.diagram.extension.edit.part;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.providers.AbstractViewProvider;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.soa.sca.core.common.diagram.extension.edit.part.ScaElementExtendedInformation;
import org.eclipse.soa.sca.core.common.diagram.extension.edit.part.ScaElementType;
import org.eclipse.soa.sca.sca1_0.diagram.extension.LocalDiagramExtensionManager;
import org.eclipse.soa.sca.sca1_0.diagram.extension.LocalDiagramExtensionUtils;
import org.eclipse.soa.sca.sca1_0.diagram.part.ScaVisualIDRegistry;

public abstract class ElementViewProvider
extends AbstractViewProvider {
    private List<ScaElementExtendedInformation> elementList;

    protected ElementViewProvider(ScaElementType type) {
        switch (type) {
            case BINDING: {
                this.elementList = LocalDiagramExtensionManager.INSTANCE.getBindingExtensions();
                break;
            }
            case IMPLEMENTATION: {
                this.elementList = LocalDiagramExtensionManager.INSTANCE.getImplementationExtensions();
                break;
            }
            case INTERFACE: {
                this.elementList = LocalDiagramExtensionManager.INSTANCE.getInterfaceExtensions();
                break;
            }
            default: {
                this.elementList = Collections.emptyList();
            }
        }
    }

    protected boolean canCreateNode(View containerView, int nodeVisualID) {
        for (ScaElementExtendedInformation elementInformation : this.elementList) {
            if (!elementInformation.getVisualIDRegistry().canCreateNode(containerView, nodeVisualID)) continue;
            return true;
        }
        return false;
    }

    protected int getNodeVisualID(View containerView, EObject domainElement) {
        for (ScaElementExtendedInformation elementInformation : this.elementList) {
            int result = elementInformation.getVisualIDRegistry().getNodeVisualID(containerView, domainElement);
            if (result < 0) continue;
            return result;
        }
        return -1;
    }

    protected boolean isKnownElementType(IElementType elementType) {
        for (ScaElementExtendedInformation elementInformation : this.elementList) {
            if (!elementInformation.isKnownElementType(elementType)) continue;
            return true;
        }
        return false;
    }

    protected Class getNodeViewClass(IAdaptable semanticAdapter, View containerView, String semanticHint) {
        int visualID;
        if (containerView == null) {
            return null;
        }
        IElementType elementType = this.getSemanticElementType(semanticAdapter);
        EObject domainElement = this.getSemanticElement(semanticAdapter);
        if (semanticHint == null) {
            if (elementType != null || domainElement == null) {
                return null;
            }
            visualID = this.getNodeVisualID(containerView, domainElement);
        } else {
            visualID = LocalDiagramExtensionUtils.getVisualID(semanticHint);
            if (elementType != null) {
                if (!this.isKnownElementType(elementType) || !(elementType instanceof IHintedType)) {
                    return null;
                }
                String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
                if (!semanticHint.equals(elementTypeHint)) {
                    return null;
                }
                if (domainElement != null && visualID != this.getNodeVisualID(containerView, domainElement)) {
                    return null;
                }
            } else {
                if (!"Sca".equals(this.getModelID(containerView))) {
                    return null;
                }
                boolean matchId = false;
                for (ScaElementExtendedInformation elementInformation : this.elementList) {
                    if (visualID != elementInformation.getVisualId()) continue;
                    matchId = true;
                    int id = elementInformation.getVisualIDRegistry().getNodeVisualID(containerView, domainElement);
                    if (domainElement != null && visualID == id) continue;
                    return null;
                }
                if (!matchId) {
                    return null;
                }
            }
        }
        return this.getNodeViewClass(containerView, visualID);
    }

    protected Class getNodeViewClass(View containerView, int visualID) {
        if (containerView == null || !this.canCreateNode(containerView, visualID)) {
            return null;
        }
        for (ScaElementExtendedInformation elementInformation : this.elementList) {
            if (visualID != elementInformation.getVisualId()) continue;
            return elementInformation.getViewFactoryClass();
        }
        return null;
    }

    private IElementType getSemanticElementType(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        return (IElementType)semanticAdapter.getAdapter(IElementType.class);
    }

    protected String getModelID(View view) {
        return ScaVisualIDRegistry.getModelID(view);
    }

    protected int getVisualID(String type) {
        return ScaVisualIDRegistry.getVisualID(type);
    }
}

