/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.sca1_0.runtime.frascati.intents.ui;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.soa.sca.sca1_0.runtime.frascati.intents.ui.util.Messages;
import org.eclipse.soa.sca.sca1_0.runtime.frascati.intents.ui.util.SCAUtils;
import org.eclipse.soa.sca.sca1_0.runtime.frascati.model.frascati.provider.FrascatiEditPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class FraSCAtiTimeoutIntentWizardPage
extends WizardPage {
    private Text containerText;
    private File containerFile;
    private Text timeout;
    private Combo scope;
    private final String[] scopes;
    private final ISelection selection;

    public FraSCAtiTimeoutIntentWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle(Messages.FraSCAtiTimeoutIntentWizardPage_title);
        this.setDescription(Messages.FraSCAtiTimeoutIntentWizardPage_description);
        this.setImageDescriptor(FrascatiEditPlugin.getImageDescriptor("icons/full/misc/timeout.png"));
        this.selection = selection;
        this.scopes = SCAUtils.getScaScopes();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("&Container:");
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FraSCAtiTimeoutIntentWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FraSCAtiTimeoutIntentWizardPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText("&Timeout (ms) :");
        this.timeout = new Text(container, 2052);
        this.timeout.setLayoutData((Object)gd);
        this.timeout.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FraSCAtiTimeoutIntentWizardPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText("\t");
        label = new Label(container, 0);
        label.setText("&Scope :");
        this.scope = new Combo(container, 8);
        this.scope.setItems(this.scopes);
        this.scope.setLayoutData((Object)gd);
        this.scope.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FraSCAtiTimeoutIntentWizardPage.this.dialogChanged();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.containerText.setText(container.getFullPath().toString());
                this.containerFile = container.getLocation().toFile();
            }
        }
        this.timeout.setText(Messages.FraSCAtiTimeoutIntentWizardPage_defaultValue);
        this.scope.select(0);
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Messages.CommonIntentWizardPage_browseComment);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toString());
            this.containerFile = ResourcesPlugin.getWorkspace().getRoot().getLocation().append((IPath)((Path)result[0])).toFile();
        }
    }

    private void dialogChanged() {
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String timeout = this.getTimeout();
        if (this.getContainerName().length() == 0) {
            this.updateStatus(Messages.CommonIntentWizardPage_containerNotSpecifiedErrorMessage);
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus(Messages.CommonIntentWizardPage_containerNotExistantErrorMessage);
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus(Messages.CommonIntentWizardPage_projectNotWritableErrorMessage);
            return;
        }
        if (timeout.length() == 0) {
            this.updateStatus(Messages.FraSCAtiTimeoutIntentWizardPage_timeoutNotSpecifiedErrorMessage);
            return;
        }
        if (timeout.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus(Messages.FraSCAtiTimeoutIntentWizardPage_timeoutNotValidErrorMessage);
            return;
        }
        try {
            Long.parseLong(timeout);
        }
        catch (Exception exception) {
            this.updateStatus(Messages.FraSCAtiTimeoutIntentWizardPage_timeoutNotValidErrorMessage);
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private String getContainerName() {
        return this.containerText.getText();
    }

    public String getTimeout() {
        return this.timeout.getText();
    }

    public File getContainerFile() {
        return this.containerFile;
    }

    public String getSelectedScope() {
        return this.scope.getText();
    }
}

