/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.commands;

import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.internal.debug.ui.commands.AbstractActionDelegate;
import org.eclipse.tcf.internal.debug.ui.commands.MemoryMapDialog;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeArrayPartition;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExpression;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeLaunch;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeModule;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeRegister;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tcf.services.IMemory;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tcf.util.TCFTask;

public class MemoryMapCommand
extends AbstractActionDelegate {
    private static boolean isValidNode(final TCFNode n) {
        if (n instanceof TCFNodeLaunch) {
            return true;
        }
        if (n instanceof TCFNodeExecContext) {
            return (Boolean)new TCFTask<Boolean>(n.getChannel()){

                public void run() {
                    TCFDataCache<TCFNodeExecContext> mem_cache = n.getModel().searchMemoryContext(n);
                    if (mem_cache == null) {
                        this.done(false);
                        return;
                    }
                    if (!mem_cache.validate((Runnable)((Object)this))) {
                        return;
                    }
                    TCFNodeExecContext mem_node = (TCFNodeExecContext)mem_cache.getData();
                    if (mem_node == null) {
                        this.done(false);
                        return;
                    }
                    TCFDataCache<TCFNodeExecContext> syms_cache = mem_node.getSymbolsNode();
                    if (!syms_cache.validate((Runnable)((Object)this))) {
                        return;
                    }
                    TCFNodeExecContext syms_node = (TCFNodeExecContext)syms_cache.getData();
                    if (syms_node == null) {
                        this.done(false);
                        return;
                    }
                    TCFDataCache<IMemory.MemoryContext> ctx_cache = syms_node.getMemoryContext();
                    if (!ctx_cache.validate((Runnable)((Object)this))) {
                        return;
                    }
                    this.done(ctx_cache.getData() != null);
                }
            }.getE();
        }
        if (n instanceof TCFNodeStackFrame) {
            return true;
        }
        if (n instanceof TCFNodeExpression) {
            return true;
        }
        if (n instanceof TCFNodeArrayPartition) {
            return true;
        }
        if (n instanceof TCFNodeRegister) {
            return true;
        }
        return n instanceof TCFNodeModule;
    }

    protected void selectionChanged() {
        this.getAction().setEnabled(MemoryMapCommand.isValidNode(this.getSelectedNode()));
    }

    protected void run() {
        TCFNode node = this.getSelectedNode();
        if (!MemoryMapCommand.isValidNode(node)) {
            return;
        }
        Shell shell = this.getWindow().getShell();
        try {
            new MemoryMapDialog(shell, node).open();
        }
        catch (Throwable x) {
            MessageBox mb = new MessageBox(shell, 33);
            mb.setText("Cannot open Symbol Files dialog");
            mb.setMessage(TCFModel.getErrorMessage(x, true));
            mb.open();
        }
    }
}

