/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.launch.setup;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.ArrayList;

class TelnetInputStream
extends FilterInputStream {
    private final boolean echo;
    private final String prompt;
    private final InputStream inp;
    private final OutputStream out;
    private final boolean[] mode_rem = new boolean[256];
    private final int[] mode_cnt = new int[256];
    private final Reader reader = new Reader();
    private final byte[] buf = new byte[512];
    private int buf_inp = 0;
    private int buf_out = 0;
    private boolean eof;
    private IOException err;
    private boolean closed;
    private final ArrayList<TelnetTraceListener> trace_listeners = new ArrayList();
    private static final int cm_IAC = 255;
    private static final int cm_WILL = 251;
    private static final int cm_WONT = 252;
    private static final int cm_DO = 253;
    private static final int cm_DONT = 254;
    private static final int cm_SB = 250;
    private static final int cm_SE = 240;
    private static final int cm_DataMark = 242;
    private static final int co_ECHO = 1;
    private static final int co_SUPPRESS_GO_AHEAD = 3;
    private static final int co_STATUS = 5;
    private static final int co_TERMINAL_TYPE = 24;
    private static final int co_NAWS = 31;
    private static final int co_TERMINAL_SPEED = 32;
    private static final int co_TOGGLE_FLOW_CONTROL = 33;
    private static final int co_X_DISPLAY_LOCATION = 35;
    private static final int co_ENVIRON = 36;
    private static final int co_NEW_ENVIRON = 39;
    private static final int sp_VAR = 0;
    private static final int sp_VALUE = 1;
    private static final int sp_ESC = 2;
    private static final int sp_USERVAR = 3;
    private static final int ac_IS = 0;
    private static final int ac_SEND = 1;
    private static final int ac_INFO = 2;

    TelnetInputStream(InputStream inp, OutputStream out, boolean echo, String prompt) {
        super(inp);
        if (!(inp instanceof BufferedInputStream)) {
            inp = new BufferedInputStream(inp);
        }
        this.inp = inp;
        this.out = out;
        this.echo = echo;
        this.prompt = prompt;
        this.reader.start();
    }

    public synchronized void addTraceListener(TelnetTraceListener l) {
        this.trace_listeners.add(l);
    }

    public synchronized void removeTraceListener(TelnetTraceListener l) {
        this.trace_listeners.remove(l);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int read() throws IOException {
        try {
            while (true) {
                if (this.buf_out != this.buf_inp) {
                    int res = this.buf[this.buf_out] & 0xFF;
                    this.buf_out = (this.buf_out + 1) % this.buf.length;
                    this.notify();
                    return res;
                }
                if (this.err != null) {
                    throw new IOException(this.err.getMessage());
                }
                if (this.eof) {
                    return -1;
                }
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        boolean nfy = false;
        try {
            int cnt = 0;
            block7: while (true) {
                if (cnt >= len) {
                    int n = cnt;
                    return n;
                }
                while (true) {
                    if (this.buf_out != this.buf_inp) {
                        b[off++] = this.buf[this.buf_out];
                        this.buf_out = (this.buf_out + 1) % this.buf.length;
                        nfy = true;
                        ++cnt;
                        continue block7;
                    }
                    if (cnt > 0) {
                        int n = cnt;
                        return n;
                    }
                    if (this.err != null) {
                        throw new IOException(this.err.getMessage());
                    }
                    if (this.eof) {
                        return -1;
                    }
                    if (nfy) {
                        this.notify();
                        nfy = false;
                    }
                    this.wait();
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException();
        }
        finally {
            if (nfy) {
                this.notify();
            }
        }
    }

    public synchronized int available() throws IOException {
        return (this.buf_inp + this.buf.length - this.buf_out) % this.buf.length;
    }

    public synchronized void close() throws IOException {
        this.closed = true;
        super.close();
    }

    static /* synthetic */ void access$2(TelnetInputStream telnetInputStream, boolean bl) {
        telnetInputStream.eof = bl;
    }

    static /* synthetic */ OutputStream access$3(TelnetInputStream telnetInputStream) {
        return telnetInputStream.out;
    }

    static /* synthetic */ boolean access$4(TelnetInputStream telnetInputStream) {
        return telnetInputStream.echo;
    }

    static /* synthetic */ int[] access$5(TelnetInputStream telnetInputStream) {
        return telnetInputStream.mode_cnt;
    }

    static /* synthetic */ boolean[] access$6(TelnetInputStream telnetInputStream) {
        return telnetInputStream.mode_rem;
    }

    static /* synthetic */ String access$7(TelnetInputStream telnetInputStream) {
        return telnetInputStream.prompt;
    }

    static /* synthetic */ int access$8(TelnetInputStream telnetInputStream) {
        return telnetInputStream.buf_inp;
    }

    static /* synthetic */ byte[] access$9(TelnetInputStream telnetInputStream) {
        return telnetInputStream.buf;
    }

    static /* synthetic */ int access$10(TelnetInputStream telnetInputStream) {
        return telnetInputStream.buf_out;
    }

    static /* synthetic */ void access$11(TelnetInputStream telnetInputStream, int n) {
        telnetInputStream.buf_inp = n;
    }

    static /* synthetic */ void access$12(TelnetInputStream telnetInputStream, IOException iOException) {
        telnetInputStream.err = iOException;
    }

    static /* synthetic */ boolean access$13(TelnetInputStream telnetInputStream) {
        return telnetInputStream.closed;
    }

    private class Reader
    extends Thread {
        private Reader() {
        }

        private void logCommand(int cmd, int opt) {
            String s = "" + cmd;
            switch (cmd) {
                case 251: {
                    s = "WILL";
                    break;
                }
                case 252: {
                    s = "WONT";
                    break;
                }
                case 253: {
                    s = "DO";
                    break;
                }
                case 254: {
                    s = "DONT";
                    break;
                }
                case 250: {
                    s = "SB";
                }
            }
            s = String.valueOf(s) + " ";
            switch (opt) {
                case 1: {
                    s = String.valueOf(s) + "ECHO";
                    break;
                }
                case 3: {
                    s = String.valueOf(s) + "SUPPRESS_GO_AHEAD";
                    break;
                }
                case 5: {
                    s = String.valueOf(s) + "STATUS";
                    break;
                }
                case 24: {
                    s = String.valueOf(s) + "TERMINAL_TYPE";
                    break;
                }
                case 31: {
                    s = String.valueOf(s) + "NAWS";
                    break;
                }
                case 32: {
                    s = String.valueOf(s) + "TERMINAL_SPEED";
                    break;
                }
                case 33: {
                    s = String.valueOf(s) + "TOGGLE_FLOW_CONTROL";
                    break;
                }
                case 35: {
                    s = String.valueOf(s) + "X_DISPLAY_LOCATION";
                    break;
                }
                case 36: {
                    s = String.valueOf(s) + "ENVIRON";
                    break;
                }
                case 39: {
                    s = String.valueOf(s) + "NEW_ENVIRON";
                    break;
                }
                default: {
                    s = String.valueOf(s) + opt;
                }
            }
            for (TelnetTraceListener l : TelnetInputStream.this.trace_listeners) {
                l.command(s);
            }
        }

        private int read_ch() throws IOException {
            try {
                return TelnetInputStream.this.inp.read();
            }
            catch (SocketException x) {
                String s = x.getMessage();
                if (s.startsWith("Socket closed")) {
                    return -1;
                }
                if (s.startsWith("socket closed")) {
                    return -1;
                }
                throw x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            block50: {
                block49: {
                    try {
                        var1_1 = TelnetInputStream.access$3(TelnetInputStream.this);
                        synchronized (var1_1) {
                            TelnetInputStream.access$3(TelnetInputStream.this).write(255);
                            TelnetInputStream.access$3(TelnetInputStream.this).write(TelnetInputStream.access$4(TelnetInputStream.this) != false ? 253 : 254);
                            TelnetInputStream.access$3(TelnetInputStream.this).write(1);
                            TelnetInputStream.access$3(TelnetInputStream.this).flush();
                        }
                        while ((rd = this.read_ch()) >= 0) {
                            block51: {
                                if (rd != 255) break block51;
                                cm = this.read_ch();
                                if (cm < 0) break block49;
                                if (cm != 255) {
                                    co = this.read_ch();
                                    if (co >= 0) {
                                        if (co == 242) continue;
                                        this.logCommand(cm, co);
                                        var4_7 = TelnetInputStream.access$3(TelnetInputStream.this);
                                        synchronized (var4_7) {
                                            if (TelnetInputStream.access$5(TelnetInputStream.this)[co] >= 5) {
                                                continue;
                                            }
                                            block17 : switch (cm) {
                                                case 251: {
                                                    TelnetInputStream.access$6((TelnetInputStream)TelnetInputStream.this)[co] = true;
                                                    break;
                                                }
                                                case 252: {
                                                    TelnetInputStream.access$6((TelnetInputStream)TelnetInputStream.this)[co] = false;
                                                    break;
                                                }
                                                case 253: {
                                                    TelnetInputStream.access$3(TelnetInputStream.this).write(255);
                                                    if (co == 3) {
                                                        TelnetInputStream.access$3(TelnetInputStream.this).write(251);
                                                    } else if (co == 39 && TelnetInputStream.access$7(TelnetInputStream.this) != null) {
                                                        TelnetInputStream.access$3(TelnetInputStream.this).write(251);
                                                    } else {
                                                        TelnetInputStream.access$3(TelnetInputStream.this).write(252);
                                                    }
                                                    TelnetInputStream.access$3(TelnetInputStream.this).write(co);
                                                    break;
                                                }
                                                case 254: {
                                                    TelnetInputStream.access$3(TelnetInputStream.this).write(255);
                                                    TelnetInputStream.access$3(TelnetInputStream.this).write(252);
                                                    TelnetInputStream.access$3(TelnetInputStream.this).write(co);
                                                    break;
                                                }
                                                case 250: {
                                                    ac = this.read_ch();
                                                    if (ac < 0) break;
                                                    if (ac == 1 && co == 39) {
                                                        TelnetInputStream.access$3(TelnetInputStream.this).write(255);
                                                        TelnetInputStream.access$3(TelnetInputStream.this).write(250);
                                                        TelnetInputStream.access$3(TelnetInputStream.this).write(39);
                                                        TelnetInputStream.access$3(TelnetInputStream.this).write(0);
                                                        if (TelnetInputStream.access$7(TelnetInputStream.this) != null) {
                                                            TelnetInputStream.access$3(TelnetInputStream.this).write(0);
                                                            TelnetInputStream.access$3(TelnetInputStream.this).write(80);
                                                            TelnetInputStream.access$3(TelnetInputStream.this).write(83);
                                                            TelnetInputStream.access$3(TelnetInputStream.this).write(49);
                                                            TelnetInputStream.access$3(TelnetInputStream.this).write(1);
                                                            k = 0;
                                                            while (k < TelnetInputStream.access$7(TelnetInputStream.this).length()) {
                                                                TelnetInputStream.access$3(TelnetInputStream.this).write(TelnetInputStream.access$7(TelnetInputStream.this).charAt(k));
                                                                ++k;
                                                            }
                                                        }
                                                        TelnetInputStream.access$3(TelnetInputStream.this).write(255);
                                                        TelnetInputStream.access$3(TelnetInputStream.this).write(240);
                                                    }
                                                    c0 = 0;
                                                    while (true) {
                                                        c1 = this.read_ch();
                                                        if (c0 == 255 && c1 == 240) break block17;
                                                        if (c0 == 255 && c1 == 255) {
                                                            c1 = 0;
                                                        }
                                                        c0 = c1;
                                                    }
                                                }
                                                default: {
                                                    throw new IOException("Invalid command: " + cm);
                                                }
                                            }
                                            TelnetInputStream.access$3(TelnetInputStream.this).flush();
                                            v1 = TelnetInputStream.access$5(TelnetInputStream.this);
                                            v2 = co;
                                            v1[v2] = v1[v2] + 1;
                                            continue;
                                        }
                                    } else {
                                        ** GOTO lbl89
                                    }
                                }
                                break block51;
lbl89:
                                // 2 sources

                                break;
                            }
                            var2_5 = TelnetInputStream.this;
                            synchronized (var2_5) {
                                new_inp = (TelnetInputStream.access$8(TelnetInputStream.this) + 1) % TelnetInputStream.access$9(TelnetInputStream.this).length;
                                while (new_inp == TelnetInputStream.access$10(TelnetInputStream.this)) {
                                    TelnetInputStream.this.wait();
                                }
                                TelnetInputStream.access$9((TelnetInputStream)TelnetInputStream.this)[TelnetInputStream.access$8((TelnetInputStream)TelnetInputStream.this)] = (byte)rd;
                                TelnetInputStream.access$11(TelnetInputStream.this, new_inp);
                                TelnetInputStream.this.notify();
                            }
                        }
                    }
                    catch (InterruptedException v5) {
                        TelnetInputStream.access$12(TelnetInputStream.this, new InterruptedIOException());
                        var9_11 = TelnetInputStream.this;
                        synchronized (var9_11) {
                            TelnetInputStream.access$2(TelnetInputStream.this, true);
                            TelnetInputStream.this.notify();
                            break block50;
                        }
                    }
                    catch (IOException x) {
                        try {
                            if (!TelnetInputStream.access$13(TelnetInputStream.this)) {
                                TelnetInputStream.access$12(TelnetInputStream.this, x);
                            }
                            var9_12 = TelnetInputStream.this;
                        }
                        catch (Throwable var8_15) {
                            var9_13 = TelnetInputStream.this;
                            synchronized (var9_13) {
                                TelnetInputStream.access$2(TelnetInputStream.this, true);
                                TelnetInputStream.this.notify();
                            }
                            throw var8_15;
                        }
                        synchronized (var9_12) {
                            TelnetInputStream.access$2(TelnetInputStream.this, true);
                            TelnetInputStream.this.notify();
                            break block50;
                        }
                    }
                }
                var9_14 = TelnetInputStream.this;
                synchronized (var9_14) {
                    TelnetInputStream.access$2(TelnetInputStream.this, true);
                    TelnetInputStream.this.notify();
                }
            }
        }
    }

    public static interface TelnetTraceListener {
        public void command(String var1);
    }
}

