/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tcf.debug.ui.ITCFAnnotationProvider;
import org.eclipse.tcf.internal.debug.launch.TCFSourceLookupDirector;
import org.eclipse.tcf.internal.debug.model.ITCFBreakpointListener;
import org.eclipse.tcf.internal.debug.model.TCFBreakpointsModel;
import org.eclipse.tcf.internal.debug.model.TCFBreakpointsStatus;
import org.eclipse.tcf.internal.debug.model.TCFContextState;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.internal.debug.model.TCFSourceRef;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.model.TCFAnnotationProvider;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenStackTrace;
import org.eclipse.tcf.internal.debug.ui.model.TCFModelPresentation;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ILineNumbers;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.services.IStackTrace;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFAnnotationManager {
    private static final String TYPE_BP_INSTANCE = "org.eclipse.tcf.debug.breakpoint_instance";
    private static final String TYPE_TOP_FRAME = "org.eclipse.tcf.debug.top_frame";
    private static final String TYPE_STACK_FRAME = "org.eclipse.tcf.debug.stack_frame";
    private final HashMap<IWorkbenchWindow, WorkbenchWindowInfo> windows = new HashMap();
    private final HashSet<IWorkbenchWindow> dirty_windows = new HashSet();
    private final HashSet<TCFLaunch> dirty_launches = new HashSet();
    private final HashSet<TCFLaunch> changed_launch_cfgs = new HashSet();
    private final TCFLaunch.LaunchListener launch_listener = new TCFLaunch.LaunchListener(){

        public void onCreated(TCFLaunch launch) {
        }

        public void onConnected(final TCFLaunch launch) {
            TCFAnnotationManager.this.updateAnnotations(null, launch);
            TCFBreakpointsStatus bps = launch.getBreakpointsStatus();
            if (bps == null) {
                return;
            }
            bps.addListener(new ITCFBreakpointListener(){

                public void breakpointStatusChanged(String id) {
                    TCFAnnotationManager.this.updateAnnotations(null, launch);
                }

                public void breakpointRemoved(String id) {
                    TCFAnnotationManager.this.updateAnnotations(null, launch);
                }

                public void breakpointChanged(String id) {
                }
            });
        }

        public void onDisconnected(TCFLaunch launch) {
            if (!$assertionsDisabled && !Protocol.isDispatchThread()) {
                throw new AssertionError();
            }
            TCFAnnotationManager.this.updateAnnotations(null, launch);
        }

        public void onProcessOutput(TCFLaunch launch, String process_id, int stream_id, byte[] data) {
        }

        public void onProcessStreamError(TCFLaunch launch, String process_id, int stream_id, Exception error, int lost_size) {
        }
    };
    private final ISelectionListener selection_listener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            Object obj;
            TCFAnnotationManager.this.updateAnnotations(part.getSite().getWorkbenchWindow(), (TCFLaunch)null);
            if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof TCFNodeStackFrame && ((TCFNodeStackFrame)obj).isTraceLimit()) {
                Protocol.invokeLater((Runnable)new Runnable(){

                    public void run() {
                        ((TCFNodeStackFrame)obj).riseTraceLimit();
                    }
                });
            }
        }
    };
    private final IWindowListener window_listener = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            if (!$assertionsDisabled && TCFAnnotationManager.this.windows.get(window) == null) {
                throw new AssertionError();
            }
            window.getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", TCFAnnotationManager.this.selection_listener);
            ((WorkbenchWindowInfo)TCFAnnotationManager.this.windows.remove(window)).dispose();
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
            if (TCFAnnotationManager.this.windows.get(window) != null) {
                return;
            }
            window.getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", TCFAnnotationManager.this.selection_listener);
            TCFAnnotationManager.this.windows.put(window, new WorkbenchWindowInfo());
            TCFAnnotationManager.this.updateAnnotations(window, (TCFLaunch)null);
        }
    };
    private final ILaunchConfigurationListener launch_conf_listener = new ILaunchConfigurationListener(){

        public void launchConfigurationAdded(ILaunchConfiguration cfg) {
        }

        public void launchConfigurationChanged(final ILaunchConfiguration cfg) {
            TCFAnnotationManager.this.displayExec(new Runnable(){

                public void run() {
                    ILaunch[] arr;
                    ILaunch[] iLaunchArray = arr = TCFAnnotationManager.this.launch_manager.getLaunches();
                    int n = arr.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TCFLaunch t;
                        ILaunch l = iLaunchArray[n2];
                        if (l instanceof TCFLaunch && cfg.equals((t = (TCFLaunch)l).getLaunchConfiguration())) {
                            TCFAnnotationManager.this.changed_launch_cfgs.add(t);
                            TCFAnnotationManager.this.updateAnnotations(null, t);
                        }
                        ++n2;
                    }
                }
            });
        }

        public void launchConfigurationRemoved(ILaunchConfiguration cfg) {
        }
    };
    private final Display display = Display.getDefault();
    private final ILaunchManager launch_manager = DebugPlugin.getDefault().getLaunchManager();
    private int update_unnotations_cnt = 0;
    private boolean started;
    private boolean disposed;

    public TCFAnnotationManager() {
        assert (Protocol.isDispatchThread());
        TCFLaunch.addListener((TCFLaunch.LaunchListener)this.launch_listener);
        this.launch_manager.addLaunchConfigurationListener(this.launch_conf_listener);
        this.displayExec(new Runnable(){

            public void run() {
                if (!PlatformUI.isWorkbenchRunning() || PlatformUI.getWorkbench().isStarting()) {
                    TCFAnnotationManager.this.display.timerExec(200, (Runnable)this);
                } else if (!PlatformUI.getWorkbench().isClosing()) {
                    TCFAnnotationManager.this.started = true;
                    PlatformUI.getWorkbench().addWindowListener(TCFAnnotationManager.this.window_listener);
                    IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
                    int n = iWorkbenchWindowArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                        TCFAnnotationManager.this.window_listener.windowOpened(window);
                        ++n2;
                    }
                    IWorkbenchWindow w = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (w != null) {
                        TCFAnnotationManager.this.window_listener.windowActivated(w);
                    }
                }
            }
        });
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        assert (Protocol.isDispatchThread());
        this.disposed = true;
        this.launch_manager.removeLaunchConfigurationListener(this.launch_conf_listener);
        TCFLaunch.removeListener((TCFLaunch.LaunchListener)this.launch_listener);
        this.displayExec(new Runnable(){

            public void run() {
                if (!TCFAnnotationManager.this.started) {
                    return;
                }
                PlatformUI.getWorkbench().removeWindowListener(TCFAnnotationManager.this.window_listener);
                for (IWorkbenchWindow window : TCFAnnotationManager.this.windows.keySet()) {
                    window.getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", TCFAnnotationManager.this.selection_listener);
                    ((WorkbenchWindowInfo)TCFAnnotationManager.this.windows.get(window)).dispose();
                }
                TCFAnnotationManager.this.windows.clear();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayExec(Runnable r) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (!this.display.isDisposed()) {
                this.display.asyncExec(r);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    Map<TCFLaunch, Map<String, Object>> getBreakpointStatus(IBreakpoint breakpoint) {
        ILaunch[] launches;
        assert (Protocol.isDispatchThread());
        HashMap<TCFLaunch, Map<String, Object>> map = new HashMap<TCFLaunch, Map<String, Object>>();
        if (this.disposed) {
            return null;
        }
        ILaunch[] iLaunchArray = launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            TCFLaunch launch;
            TCFBreakpointsStatus bs;
            ILaunch l = iLaunchArray[n2];
            if (l instanceof TCFLaunch && (bs = (launch = (TCFLaunch)l).getBreakpointsStatus()) != null) {
                map.put(launch, bs.getStatus(breakpoint));
            }
            ++n2;
        }
        return map;
    }

    String getBreakpointStatusText(IBreakpoint breakpoint) {
        assert (Protocol.isDispatchThread());
        String error = null;
        for (Map<String, Object> map : this.getBreakpointStatus(breakpoint).values()) {
            Object planted;
            if (map == null) continue;
            String s = (String)map.get("Error");
            if (s != null && error == null) {
                error = s;
            }
            if ((planted = map.get("Instances")) == null) continue;
            Collection list = (Collection)planted;
            for (Map m : list) {
                if (m.get("Error") != null) continue;
                return "Planted";
            }
        }
        return error;
    }

    private Object[] toObjectArray(Object o) {
        if (o == null) {
            return null;
        }
        Collection c = (Collection)o;
        return c.toArray(new Object[c.size()]);
    }

    private Map<String, Object> toObjectMap(Object o) {
        return (Map)o;
    }

    private ILineNumbers.CodeArea getBreakpointCodeArea(TCFLaunch launch, String id) {
        Map props = launch.getBreakpointsStatus().getProperties(id);
        if (props != null) {
            String file = (String)props.get("File");
            Number line = (Number)props.get("Line");
            if (file != null && line != null) {
                return new ILineNumbers.CodeArea(null, file, line.intValue(), 0, line.intValue() + 1, 0, null, null, 0, false, false, false, false);
            }
        }
        return null;
    }

    private void addBreakpointErrorAnnotation(Set<TCFAnnotation> set, TCFLaunch launch, String ctx, String id, String error) {
        ILineNumbers.CodeArea area = this.getBreakpointCodeArea(launch, id);
        if (area != null) {
            TCFAnnotation a = new TCFAnnotation(ctx, id, area, ImageCache.getImage("icons/ovr16/error_ovr.gif"), "Cannot plant breakpoint: " + error, TYPE_BP_INSTANCE);
            set.add(a);
        }
    }

    private boolean hidePlantingAnnotation(IAnnotationModel model, IBreakpoint bp, Position p) {
        Iterator i = model.getAnnotationIterator();
        while (i.hasNext()) {
            Position q;
            Annotation a = (Annotation)i.next();
            if (!(a instanceof MarkerAnnotation) || (q = model.getPosition(a)) == null || p.getOffset() != q.getOffset() || !bp.getMarker().equals((Object)((MarkerAnnotation)a).getMarker())) continue;
            return true;
        }
        return false;
    }

    private void updateAnnotations(IWorkbenchWindow window, TCFNode node, Set<TCFAnnotation> set) {
        if (this.disposed) {
            return;
        }
        assert (Thread.currentThread() == this.display.getThread());
        WorkbenchWindowInfo win_info = this.windows.get(window);
        if (win_info == null) {
            return;
        }
        HashMap<IEditorInput, ITextEditor> editors = new HashMap<IEditorInput, ITextEditor>();
        IEditorReference[] iEditorReferenceArray = window.getActivePage().getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            IEditorPart part = ref.getEditor(false);
            if (part instanceof ITextEditor) {
                ITextEditor editor = (ITextEditor)part;
                editors.put(editor.getEditorInput(), editor);
            }
            ++n2;
        }
        boolean flush_all = node == null || !editors.equals(win_info.editors) || this.changed_launch_cfgs.contains(node.launch);
        Iterator<TCFAnnotation> i = win_info.annotations.iterator();
        while (i.hasNext()) {
            TCFAnnotation a = i.next();
            if (!flush_all && set != null && set.remove((Object)a)) continue;
            a.dispose();
            i.remove();
        }
        if (set == null || set.size() == 0) {
            return;
        }
        win_info.editors.clear();
        win_info.editors.putAll(editors);
        TCFModelPresentation presentation = TCFModelPresentation.getDefault();
        for (TCFAnnotation a : set) {
            IRegion region;
            IAnnotationModel ann_model;
            block16: {
                IDocumentProvider doc_provider;
                IEditorInput editor_input;
                ITextEditor editor;
                win_info.annotations.add(a);
                Object source_element = TCFSourceLookupDirector.lookup((TCFLaunch)node.launch, (String)a.ctx, (Object)a.area);
                if (source_element == null || (editor = (ITextEditor)editors.get(editor_input = presentation.getEditorInput(source_element))) == null || (ann_model = (doc_provider = editor.getDocumentProvider()).getAnnotationModel((Object)editor_input)) == null) continue;
                region = null;
                try {
                    doc_provider.connect((Object)editor_input);
                }
                catch (CoreException coreException) {}
                try {
                    try {
                        IDocument document = doc_provider.getDocument((Object)editor_input);
                        if (document != null) {
                            region = document.getLineInformation(a.area.start_line - 1);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        doc_provider.disconnect((Object)editor_input);
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    doc_provider.disconnect((Object)editor_input);
                    throw throwable;
                }
                doc_provider.disconnect((Object)editor_input);
            }
            if (region == null) continue;
            Position p = new Position(region.getOffset(), region.getLength());
            if (a.breakpoint != null && this.hidePlantingAnnotation(ann_model, a.breakpoint, p) || a.planted != null && a.planted.model == null) continue;
            ann_model.addAnnotation((Annotation)a, p);
            a.model = ann_model;
        }
    }

    private void updateAnnotations(final IWorkbenchWindow window, final TCFNode node) {
        if (this.disposed) {
            return;
        }
        assert (Thread.currentThread() == this.display.getThread());
        final WorkbenchWindowInfo win_info = this.windows.get(window);
        if (win_info == null) {
            return;
        }
        if (win_info.update_task != null && win_info.update_node == node) {
            return;
        }
        if (win_info.update_node != node && node != null) {
            win_info.provider = TCFAnnotationProvider.getAnnotationProvider(node);
        }
        if (win_info.provider != null) {
            if (win_info.annotations.size() > 0) {
                for (TCFAnnotation a : win_info.annotations) {
                    a.dispose();
                }
                win_info.annotations.clear();
            }
            win_info.update_node = node;
            win_info.update_task = null;
            win_info.provider.updateAnnotations(window, node);
            return;
        }
        win_info.update_node = node;
        win_info.update_task = new Runnable(){

            @Override
            public void run() {
                TCFAnnotation a;
                TCFSourceRef line_data;
                TCFDataCache<TCFSourceRef> line_cache;
                TCFLaunch launch;
                TCFBreakpointsStatus bs;
                if (win_info.update_task != this) {
                    return;
                }
                if (node == null) {
                    this.done(null);
                    return;
                }
                if (node.isDisposed()) {
                    this.done(null);
                    return;
                }
                TCFNodeExecContext thread = null;
                TCFNodeExecContext memory = null;
                TCFNodeStackFrame frame = null;
                TCFNodeStackFrame last_top_frame = null;
                String bp_group = null;
                boolean suspended = false;
                if (node instanceof TCFNodeStackFrame) {
                    thread = (TCFNodeExecContext)node.parent;
                    frame = (TCFNodeStackFrame)node;
                } else if (node instanceof TCFNodeExecContext) {
                    thread = (TCFNodeExecContext)node;
                    TCFChildrenStackTrace trace = thread.getStackTrace();
                    if (!trace.validate(this)) {
                        return;
                    }
                    frame = trace.getTopFrame();
                }
                if (thread != null) {
                    TCFDataCache<TCFNodeExecContext> mem_cache;
                    TCFDataCache<IRunControl.RunControlContext> rc_ctx_cache = thread.getRunContext();
                    if (!rc_ctx_cache.validate((Runnable)this)) {
                        return;
                    }
                    IRunControl.RunControlContext rc_ctx_data = (IRunControl.RunControlContext)rc_ctx_cache.getData();
                    if (rc_ctx_data != null) {
                        bp_group = rc_ctx_data.getBPGroup();
                    }
                    if (!(mem_cache = thread.getMemoryNode()).validate((Runnable)this)) {
                        return;
                    }
                    memory = (TCFNodeExecContext)mem_cache.getData();
                    if (bp_group == null && memory != null && rc_ctx_data != null && rc_ctx_data.hasState()) {
                        bp_group = memory.id;
                    }
                    last_top_frame = thread.getLastTopFrame();
                    TCFDataCache<TCFContextState> state_cache = thread.getState();
                    if (!state_cache.validate((Runnable)this)) {
                        return;
                    }
                    suspended = state_cache.getData() != null && ((TCFContextState)state_cache.getData()).is_suspended;
                }
                LinkedHashSet<TCFAnnotation> set = new LinkedHashSet<TCFAnnotation>();
                if (memory != null && (bs = (launch = node.launch).getBreakpointsStatus()) != null) {
                    for (String id : bs.getStatusIDs()) {
                        Object[] arr;
                        Map map = bs.getStatus(id);
                        if (map == null) continue;
                        String error = (String)map.get("Error");
                        if (error != null) {
                            TCFAnnotationManager.this.addBreakpointErrorAnnotation(set, launch, memory.id, id, error);
                        }
                        if ((arr = TCFAnnotationManager.this.toObjectArray(map.get("Instances"))) == null) continue;
                        Object[] objectArray = arr;
                        int n = arr.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object o = objectArray[n2];
                            Map m = TCFAnnotationManager.this.toObjectMap(o);
                            String ctx_id = (String)m.get("LocationContext");
                            if (ctx_id != null && (ctx_id.equals(node.id) || ctx_id.equals(bp_group))) {
                                error = (String)m.get("Error");
                                BigInteger addr = JSON.toBigInteger((Number)((Number)m.get("Address")));
                                if (addr != null) {
                                    ILineNumbers.CodeArea area = null;
                                    TCFDataCache<TCFSourceRef> line_cache2 = memory.getLineInfo(addr);
                                    if (line_cache2 != null) {
                                        if (!line_cache2.validate((Runnable)this)) {
                                            return;
                                        }
                                        TCFSourceRef line_data2 = (TCFSourceRef)line_cache2.getData();
                                        if (line_data2 != null && line_data2.area != null) {
                                            area = line_data2.area;
                                        }
                                    }
                                    if (area == null) {
                                        area = TCFAnnotationManager.this.getBreakpointCodeArea(launch, id);
                                    }
                                    if (area != null) {
                                        String bp_name = "Breakpoint";
                                        IBreakpoint bp = TCFBreakpointsModel.getBreakpointsModel().getBreakpoint(id);
                                        if (bp != null) {
                                            bp_name = bp.getMarker().getAttribute("message", bp_name);
                                        }
                                        if (error != null) {
                                            TCFAnnotation a2 = new TCFAnnotation(memory.id, id, area, ImageCache.getImage("icons/ovr16/error_ovr.gif"), String.valueOf(bp_name) + " failed to plant at 0x" + addr.toString(16) + ": " + error, TCFAnnotationManager.TYPE_BP_INSTANCE);
                                            set.add(a2);
                                            error = null;
                                        } else {
                                            String location = " planted at 0x" + addr.toString(16) + ", line " + area.start_line;
                                            TCFAnnotation a3 = new TCFAnnotation(memory.id, id, area, ImageCache.getImage("icons/ovr16/installed_ovr.gif"), String.valueOf(bp_name) + location, TCFAnnotationManager.TYPE_BP_INSTANCE);
                                            a3.breakpoint = bp;
                                            set.add(a3);
                                            ILineNumbers.CodeArea org_area = TCFAnnotationManager.this.getBreakpointCodeArea(launch, id);
                                            if (org_area != null) {
                                                TCFAnnotation b = new TCFAnnotation(memory.id, id, org_area, ImageCache.getImage("icons/ovr16/warning_ovr.gif"), "Breakpoint location is adjusted: " + location, TCFAnnotationManager.TYPE_BP_INSTANCE);
                                                b.planted = a3;
                                                set.add(b);
                                            }
                                        }
                                    }
                                }
                                if (error != null) {
                                    TCFAnnotationManager.this.addBreakpointErrorAnnotation(set, launch, memory.id, id, error);
                                }
                            }
                            ++n2;
                        }
                    }
                }
                if (suspended && frame != null && frame.getFrameNo() >= 0) {
                    line_cache = frame.getLineInfo();
                    if (!line_cache.validate((Runnable)this)) {
                        return;
                    }
                    line_data = (TCFSourceRef)line_cache.getData();
                    if (line_data != null && line_data.area != null) {
                        BigInteger i;
                        TCFDataCache<IStackTrace.StackTraceContext> frame_cache;
                        a = null;
                        String addr_str = "";
                        TCFDataCache<BigInteger> addr_cache = frame.getAddress();
                        if (!addr_cache.validate((Runnable)this)) {
                            return;
                        }
                        BigInteger addr_data = (BigInteger)addr_cache.getData();
                        if (addr_data != null) {
                            addr_str = String.valueOf(addr_str) + ", IP: 0x" + addr_data.toString(16);
                        }
                        if (!(frame_cache = frame.getStackTraceContext()).validate((Runnable)this)) {
                            return;
                        }
                        IStackTrace.StackTraceContext frame_data = (IStackTrace.StackTraceContext)frame_cache.getData();
                        if (frame_data != null && (i = JSON.toBigInteger((Number)frame_data.getFrameAddress())) != null) {
                            addr_str = String.valueOf(addr_str) + ", FP: 0x" + i.toString(16);
                        }
                        addr_str = String.valueOf(addr_str) + ", line: " + line_data.area.start_line;
                        a = frame.getFrameNo() == 0 ? new TCFAnnotation(line_data.context_id, null, line_data.area, DebugUITools.getImage((String)"IMG_OBJS_INSTRUCTION_POINTER_TOP"), "Current Instruction Pointer" + addr_str, TCFAnnotationManager.TYPE_TOP_FRAME) : new TCFAnnotation(line_data.context_id, null, line_data.area, DebugUITools.getImage((String)"IMG_OBJS_INSTRUCTION_POINTER"), "Call Stack Frame" + addr_str, TCFAnnotationManager.TYPE_STACK_FRAME);
                        set.add(a);
                    }
                }
                if (!suspended && last_top_frame != null) {
                    line_cache = last_top_frame.getLineInfo();
                    if (!line_cache.validate((Runnable)this)) {
                        return;
                    }
                    line_data = (TCFSourceRef)line_cache.getData();
                    if (line_data != null && line_data.area != null) {
                        a = new TCFAnnotation(line_data.context_id, null, line_data.area, DebugUITools.getImage((String)"IMG_OBJS_INSTRUCTION_POINTER"), "Last Instruction Pointer position", TCFAnnotationManager.TYPE_STACK_FRAME);
                        set.add(a);
                    }
                }
                this.done(set);
            }

            private void done(final Set<TCFAnnotation> res) {
                final 7 update_task = this;
                TCFAnnotationManager.this.displayExec(new Runnable(){

                    public void run() {
                        if (update_task != win_info.update_task) {
                            return;
                        }
                        if (!$assertionsDisabled && win_info.update_node != node) {
                            throw new AssertionError();
                        }
                        win_info.update_task = null;
                        try {
                            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                                public void run(IProgressMonitor monitor) throws CoreException {
                                    TCFAnnotationManager.this.updateAnnotations(window, node, res);
                                }
                            }, null);
                        }
                        catch (Exception e) {
                            Activator.log(e);
                        }
                    }
                });
            }
        };
        Protocol.invokeLater((Runnable)win_info.update_task);
    }

    private void updateAnnotations(final int cnt) {
        this.displayExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                TCFAnnotationManager tCFAnnotationManager = TCFAnnotationManager.this;
                synchronized (tCFAnnotationManager) {
                    if (cnt != TCFAnnotationManager.this.update_unnotations_cnt) {
                        return;
                    }
                }
                for (IWorkbenchWindow window : TCFAnnotationManager.this.windows.keySet()) {
                    if (!TCFAnnotationManager.this.dirty_windows.contains(null) && !TCFAnnotationManager.this.dirty_windows.contains(window)) continue;
                    TCFNode node = null;
                    try {
                        Object first_element;
                        IStructuredSelection selection;
                        ISelection active_context = DebugUITools.getDebugContextManager().getContextService(window).getActiveContext();
                        if (active_context instanceof IStructuredSelection && !(selection = (IStructuredSelection)active_context).isEmpty() && (first_element = selection.getFirstElement()) instanceof IAdaptable) {
                            node = (TCFNode)((IAdaptable)first_element).getAdapter(TCFNode.class);
                        }
                        if (!TCFAnnotationManager.this.dirty_launches.contains(null) && (node == null || !TCFAnnotationManager.this.dirty_launches.contains(node.launch))) continue;
                        TCFAnnotationManager.this.updateAnnotations(window, node);
                    }
                    catch (Throwable x) {
                        if (node != null && node.isDisposed()) continue;
                        Activator.log("Cannot update editor annotations", x);
                    }
                }
                for (TCFLaunch launch : TCFAnnotationManager.this.dirty_launches) {
                    if (launch == null) continue;
                    launch.removePendingClient((Object)TCFAnnotationManager.this);
                }
                TCFAnnotationManager.this.changed_launch_cfgs.clear();
                TCFAnnotationManager.this.dirty_windows.clear();
                TCFAnnotationManager.this.dirty_launches.clear();
            }
        });
    }

    synchronized void updateAnnotations(final IWorkbenchWindow window, final TCFLaunch launch) {
        final int cnt = ++this.update_unnotations_cnt;
        this.displayExec(new Runnable(){

            public void run() {
                TCFAnnotationManager.this.dirty_windows.add(window);
                TCFAnnotationManager.this.dirty_launches.add(launch);
                TCFAnnotationManager.this.updateAnnotations(cnt);
            }
        });
    }

    class TCFAnnotation
    extends Annotation {
        final String ctx;
        final String bp_id;
        final ILineNumbers.CodeArea area;
        final Image image;
        final String text;
        final String type;
        final int hash_code;
        IAnnotationModel model;
        IBreakpoint breakpoint;
        TCFAnnotation planted;

        TCFAnnotation(String ctx, String bp_id, ILineNumbers.CodeArea area, Image image, String text, String type) {
            super(type, false, text);
            this.ctx = ctx;
            this.bp_id = bp_id;
            this.area = area;
            this.image = image;
            this.text = text;
            this.type = type;
            this.hash_code = area.hashCode() + image.hashCode() + text.hashCode() + type.hashCode();
        }

        protected Image getImage() {
            return this.image;
        }

        void dispose() {
            assert (Thread.currentThread() == TCFAnnotationManager.this.display.getThread());
            if (this.model != null) {
                this.model.removeAnnotation((Annotation)this);
                this.model = null;
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof TCFAnnotation)) {
                return false;
            }
            TCFAnnotation a = (TCFAnnotation)((Object)o);
            if (!this.ctx.equals(a.ctx)) {
                return false;
            }
            if (this.bp_id != a.bp_id) {
                if (this.bp_id == null) {
                    return false;
                }
                if (!this.bp_id.equals(a.bp_id)) {
                    return false;
                }
            }
            if (!this.area.equals((Object)a.area)) {
                return false;
            }
            if (!this.image.equals((Object)a.image)) {
                return false;
            }
            if (!this.text.equals(a.text)) {
                return false;
            }
            return this.type.equals(a.type);
        }

        public int hashCode() {
            return this.hash_code;
        }

        public String toString() {
            StringBuffer bf = new StringBuffer();
            bf.append('[');
            bf.append(this.area);
            bf.append(',');
            bf.append(this.text);
            bf.append(',');
            bf.append(this.type);
            bf.append(',');
            bf.append(this.model);
            bf.append(']');
            return bf.toString();
        }
    }

    private class WorkbenchWindowInfo {
        final HashSet<TCFAnnotation> annotations = new HashSet();
        final Map<IEditorInput, ITextEditor> editors = new HashMap<IEditorInput, ITextEditor>();
        ITCFAnnotationProvider provider;
        Runnable update_task;
        TCFNode update_node;

        private WorkbenchWindowInfo() {
        }

        void dispose() {
            for (TCFAnnotation a : this.annotations) {
                a.dispose();
            }
            this.annotations.clear();
        }
    }
}

