/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.rse.processes;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.rse.core.subsystems.AbstractResource;
import org.eclipse.rse.services.clientserver.processes.IHostProcess;
import org.eclipse.tcf.internal.rse.processes.TCFProcessService;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ISysMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFProcessResource
extends AbstractResource
implements IHostProcess {
    public static final String PROP_PC_UTIME = "PCUTime";
    public static final String PROP_PC_STIME = "PCSTime";
    private final TCFProcessService rse_service;
    private final ISysMonitor tcf_service;
    private final TCFProcessResource prev;
    private final String id;
    private Throwable error;
    private ISysMonitor.SysMonitorContext context;
    private final List<Runnable> children_wait_list = new ArrayList<Runnable>();
    private final HashMap<String, TCFProcessResource> children = new HashMap();
    private boolean children_loading;
    private boolean children_loaded;
    private Throwable children_error;
    private boolean running_wait_list;
    private long timestamp;
    private final String[] propertyKeys = new String[11];
    private Map<String, Object> properties;

    TCFProcessResource(TCFProcessService rse_service, ISysMonitor service, TCFProcessResource prev, String id) {
        this.propertyKeys[1] = "File";
        this.propertyKeys[8] = "GroupName";
        this.propertyKeys[0] = "PID";
        this.propertyKeys[4] = "PPID";
        this.propertyKeys[2] = "State";
        this.propertyKeys[3] = "TGID";
        this.propertyKeys[5] = "TracerPID";
        this.propertyKeys[6] = "UID";
        this.propertyKeys[7] = "UserName";
        this.propertyKeys[9] = "VSize";
        this.propertyKeys[10] = "RSS";
        this.properties = new HashMap<String, Object>();
        this.rse_service = rse_service;
        this.tcf_service = service;
        this.prev = prev;
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    public String getParentID() {
        return (String)this.properties.get("ParentID");
    }

    public TCFProcessService getService() {
        return this.rse_service;
    }

    public void invalidate() {
        assert (Protocol.isDispatchThread());
        this.error = null;
        this.context = null;
    }

    public boolean validate(final Runnable done) {
        assert (Protocol.isDispatchThread());
        if (this.error != null) {
            return true;
        }
        if (this.context != null) {
            return true;
        }
        this.tcf_service.getContext(this.id, new ISysMonitor.DoneGetContext(){

            public void doneGetContext(IToken token, Exception error, ISysMonitor.SysMonitorContext context) {
                TCFProcessResource.this.error = error;
                TCFProcessResource.this.context = context;
                TCFProcessResource.this.timestamp = System.currentTimeMillis();
                if (error != null) {
                    TCFProcessResource.this.properties = new HashMap();
                } else {
                    TCFProcessResource.this.properties = new HashMap(context.getProperties());
                    if (TCFProcessResource.this.prev != null && TCFProcessResource.this.timestamp > TCFProcessResource.this.prev.timestamp) {
                        TCFProcessResource.this.setPCProperty(TCFProcessResource.PROP_PC_UTIME, "UTime");
                        TCFProcessResource.this.setPCProperty(TCFProcessResource.PROP_PC_STIME, "STime");
                    }
                    TCFProcessResource.this.toLong("PID");
                    TCFProcessResource.this.toLong("PPID");
                    TCFProcessResource.this.toLong("UTime");
                    TCFProcessResource.this.toLong("STime");
                    TCFProcessResource.this.toLong("CUTime");
                    TCFProcessResource.this.toLong("CSTime");
                    TCFProcessResource.this.toLong("StartTime");
                    TCFProcessResource.this.toLong("ITRealValue");
                    TCFProcessResource.this.toBigInteger("CodeStart");
                    TCFProcessResource.this.toBigInteger("CodeEnd");
                    TCFProcessResource.this.toBigInteger("StackStart");
                    TCFProcessResource.this.toBigInteger("WChan");
                }
                Protocol.invokeLater((Runnable)done);
            }
        });
        return false;
    }

    private void toLong(String name) {
        Number n = (Number)this.properties.get(name);
        if (n == null || n instanceof Long) {
            return;
        }
        this.properties.put(name, n.longValue());
    }

    private void toBigInteger(String name) {
        Number n = (Number)this.properties.get(name);
        if (n == null || n instanceof BigInteger) {
            return;
        }
        this.properties.put(name, new BigInteger(n.toString()));
    }

    private void setPCProperty(String property, String name) {
        Object x = this.prev.properties.get(name);
        Object y = this.properties.get(name);
        if (x instanceof Number && y instanceof Number) {
            BigInteger nx = x instanceof BigInteger ? (BigInteger)x : new BigInteger(x.toString());
            BigInteger ny = y instanceof BigInteger ? (BigInteger)y : new BigInteger(y.toString());
            double d = ny.subtract(nx).doubleValue() / (double)(this.timestamp - this.prev.timestamp);
            this.properties.put(property, d);
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Throwable getError() {
        assert (Protocol.isDispatchThread());
        return this.error;
    }

    public ISysMonitor.SysMonitorContext getContext() {
        assert (Protocol.isDispatchThread());
        return this.context;
    }

    public String getAllProperties() {
        String result = "";
        int i = 0;
        while (i < 11) {
            result = String.valueOf(result) + this.properties.get(this.propertyKeys[i]);
            if (i != 10) {
                result = String.valueOf(result) + "|";
            }
            ++i;
        }
        return result;
    }

    public long getGid() {
        Number n = (Number)this.properties.get("UGID");
        if (n == null) {
            return -1L;
        }
        return n.longValue();
    }

    public String getLabel() {
        return String.valueOf(Long.toString(this.getPid())) + " " + this.notNull(this.getName());
    }

    public String getName() {
        return (String)this.properties.get("File");
    }

    public long getPPid() {
        Number n = (Number)this.properties.get("PPID");
        if (n == null) {
            return -1L;
        }
        return n.longValue();
    }

    public long getPid() {
        Number n = (Number)this.properties.get("PID");
        if (n == null) {
            return -1L;
        }
        return n.longValue();
    }

    public String getState() {
        return (String)this.properties.get("State");
    }

    public long getTgid() {
        Number n = (Number)this.properties.get("TGID");
        if (n == null) {
            return -1L;
        }
        return n.longValue();
    }

    public long getTracerPid() {
        Number n = (Number)this.properties.get("TracerPID");
        if (n == null) {
            return -1L;
        }
        return n.longValue();
    }

    public long getUid() {
        Number n = (Number)this.properties.get("UID");
        if (n == null) {
            return -1L;
        }
        return n.longValue();
    }

    public String getUsername() {
        return (String)this.properties.get("UserName");
    }

    public long getVmRSSInKB() {
        Number rss = (Number)this.properties.get("RSS");
        Number psz = (Number)this.properties.get("PSize");
        if (rss == null || psz == null) {
            return 0L;
        }
        return (rss.longValue() * psz.longValue() + 1023L) / 1024L;
    }

    public long getVmSizeInKB() {
        Number vsz = (Number)this.properties.get("VSize");
        if (vsz == null) {
            return 0L;
        }
        return (vsz.longValue() + 1023L) / 1024L;
    }

    public boolean isRoot() {
        return true;
    }

    private String notNull(String s) {
        return s == null ? "" : s;
    }

    String getStatusLine() {
        StringBuffer s = new StringBuffer();
        s.append(this.getPid()).append("|");
        s.append(this.notNull(this.getName())).append("|");
        s.append(this.notNull(this.getState())).append("|");
        s.append(this.getTgid()).append("|");
        s.append(this.getPPid()).append("|");
        s.append('0').append("|");
        s.append(this.getUid()).append("|");
        s.append(this.notNull(this.getUsername())).append("|");
        s.append(this.getGid()).append("|");
        s.append(this.getVmSizeInKB()).append("|");
        s.append(this.getVmRSSInKB()).append("|");
        return s.toString();
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    private void runChildrenWaitList() {
        assert (!this.children_loading);
        assert (this.children_loaded);
        try {
            this.running_wait_list = true;
            for (Runnable r : this.children_wait_list) {
                r.run();
            }
            this.children_wait_list.clear();
        }
        finally {
            this.running_wait_list = false;
        }
    }

    public Throwable getChildrenError() {
        return this.children_error;
    }

    public void flushChildrenCache() {
        Map<Long, TCFProcessResource> pid2res = this.rse_service.getProcessCache();
        for (TCFProcessResource r : this.children.values()) {
            long pid = r.getPid();
            if (pid <= 0L || this.getPid() == pid) continue;
            pid2res.remove(r.getPid());
        }
        this.children_loaded = false;
        this.children_error = null;
    }

    public boolean loadChildren(Runnable run) {
        if (this.children_loaded) {
            return true;
        }
        assert (!this.running_wait_list);
        this.children_wait_list.add(run);
        if (this.children_loading) {
            return false;
        }
        this.children_loading = true;
        try {
            final ISysMonitor m = this.rse_service.getTCFConnectorService().getSysMonitorService();
            m.getChildren(this.getID(), new ISysMonitor.DoneGetChildren(){

                public void doneGetChildren(IToken token, Exception error, String[] ids) {
                    try {
                        if (error != null) {
                            TCFProcessResource.this.loadProcessesDone(error, null);
                        } else if (ids == null) {
                            TCFProcessResource.this.loadProcessesDone(null, new TCFProcessResource[0]);
                        } else {
                            final TCFProcessResource[] arr = new TCFProcessResource[ids.length];
                            final HashSet<TCFProcessResource> pending = new HashSet<TCFProcessResource>();
                            int i = 0;
                            while (i < ids.length) {
                                final TCFProcessResource r = new TCFProcessResource(TCFProcessResource.this.rse_service, m, (TCFProcessResource)((Object)TCFProcessResource.this.children.get(ids[i])), ids[i]);
                                if (!r.validate(new Runnable(){

                                    public void run() {
                                        pending.remove((Object)r);
                                        if (pending.isEmpty()) {
                                            TCFProcessResource.this.loadProcessesDone(null, arr);
                                        }
                                    }
                                })) {
                                    pending.add(r);
                                }
                                arr[i] = r;
                                ++i;
                            }
                            if (pending.isEmpty()) {
                                TCFProcessResource.this.loadProcessesDone(null, arr);
                            }
                        }
                    }
                    catch (Throwable x) {
                        TCFProcessResource.this.loadProcessesDone(x, null);
                    }
                }
            });
            return false;
        }
        catch (Throwable x) {
            this.loadProcessesDone(x, null);
            return true;
        }
    }

    private void loadProcessesDone(Throwable error, TCFProcessResource[] arr) {
        assert (this.children_loading);
        this.children_loading = false;
        this.children_loaded = true;
        this.children.clear();
        if (arr != null && error == null) {
            Map<Long, TCFProcessResource> pid2res = this.rse_service.getProcessCache();
            TCFProcessResource[] tCFProcessResourceArray = arr;
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                TCFProcessResource r = tCFProcessResourceArray[n2];
                long pid = r.getPid();
                if (pid > 0L && this.getPid() != pid) {
                    pid2res.put(pid, r);
                }
                if (r.getError() == null) {
                    this.children.put(r.getID(), r);
                }
                ++n2;
            }
        }
        this.children_error = error;
        this.runChildrenWaitList();
    }

    public String toString() {
        return "[" + this.getStatusLine() + "]";
    }
}

