/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.core.concurrent.internal;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tcf.te.tcf.core.concurrent.interfaces.IProxyDescriptor;

public class DefaultProxyDescriptor
implements IProxyDescriptor {
    private static volatile Map<Class<?>, IProxyDescriptor> descriptorCache;
    private Map<Method, Integer> callbacks = Collections.synchronizedMap(new HashMap());

    public static IProxyDescriptor getProxyDescriptor(Class<?> proxyInterface) {
        IProxyDescriptor descriptor;
        if (descriptorCache == null) {
            descriptorCache = Collections.synchronizedMap(new HashMap());
        }
        if ((descriptor = descriptorCache.get(proxyInterface)) == null) {
            descriptor = new DefaultProxyDescriptor(proxyInterface);
            descriptorCache.put(proxyInterface, descriptor);
        }
        return descriptor;
    }

    private DefaultProxyDescriptor(Class<?> proxyInterface) {
        Method[] methods = proxyInterface.getDeclaredMethods();
        if (methods != null && methods.length > 0) {
            Method[] methodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                int index = this.findCallbackIndex(method);
                if (index != -1) {
                    this.callbacks.put(method, index);
                }
                ++n2;
            }
        }
    }

    private int findCallbackIndex(Method method) {
        Class<?>[] pTypes = method.getParameterTypes();
        if (pTypes != null && pTypes.length > 0) {
            int i = 0;
            while (i < pTypes.length) {
                Class<?> type = pTypes[i];
                if (type.isInterface() && type.getName().indexOf("$Done") != -1) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    @Override
    public boolean isDispatchMethod(Method method) {
        return this.isProxyMethod(method);
    }

    @Override
    public boolean isProxyMethod(Method method) {
        return this.getCallbackIndex(method) != -1;
    }

    @Override
    public int getCallbackIndex(Method method) {
        Integer integer = this.callbacks.get(method);
        return integer == null ? -1 : integer;
    }
}

